/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.api.WxCpDepartmentService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpDepartmentServiceImpl
implements WxCpDepartmentService {
    private WxCpService mainService;

    public WxCpDepartmentServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public Integer create(WxCpDepart depart) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/create";
        String responseContent = this.mainService.post(url, depart.toJson());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return GsonHelper.getAsInteger((JsonElement)tmpJsonElement.getAsJsonObject().get("id"));
    }

    @Override
    public void update(WxCpDepart group) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/update";
        this.mainService.post(url, group.toJson());
    }

    @Override
    public void delete(Integer departId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?id=" + departId;
        this.mainService.get(url, null);
    }

    @Override
    public List<WxCpDepart> list(Integer id) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/list";
        if (id != null) {
            url = url + "?id=" + id;
        }
        String responseContent = this.mainService.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("department"), new TypeToken<List<WxCpDepart>>(){}.getType());
    }
}

