/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpUserDetail;

public class WxCpOAuth2ServiceImpl
implements WxCpOAuth2Service {
    private WxCpService mainService;

    public WxCpOAuth2ServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public String buildAuthorizationUrl(String state) {
        return this.buildAuthorizationUrl(this.mainService.getWxCpConfigStorage().getOauth2redirectUri(), state);
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state) {
        return this.buildAuthorizationUrl(redirectUri, state, "snsapi_base");
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state, String scope) {
        StringBuilder url = new StringBuilder("https://open.weixin.qq.com/connect/oauth2/authorize?");
        url.append("appid=").append(this.mainService.getWxCpConfigStorage().getCorpId());
        url.append("&redirect_uri=").append(URIUtil.encodeURIComponent((String)redirectUri));
        url.append("&response_type=code");
        url.append("&scope=").append(scope);
        if ("snsapi_privateinfo".equals(scope) || "snsapi_userinfo".equals(scope)) {
            url.append("&agentid=").append(this.mainService.getWxCpConfigStorage().getAgentId());
        }
        if (state != null) {
            url.append("&state=").append(state);
        }
        url.append("#wechat_redirect");
        return url.toString();
    }

    @Override
    public String[] getUserInfo(String code) throws WxErrorException {
        return this.getUserInfo(this.mainService.getWxCpConfigStorage().getAgentId(), code);
    }

    @Override
    public String[] getUserInfo(Integer agentId, String code) throws WxErrorException {
        String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?code=%s&agentid=%d", code, agentId);
        String responseText = this.mainService.get(url, null);
        JsonElement je = new JsonParser().parse(responseText);
        JsonObject jo = je.getAsJsonObject();
        return new String[]{GsonHelper.getString((JsonObject)jo, (String)"UserId"), GsonHelper.getString((JsonObject)jo, (String)"DeviceId"), GsonHelper.getString((JsonObject)jo, (String)"OpenId"), GsonHelper.getString((JsonObject)jo, (String)"user_ticket"), GsonHelper.getString((JsonObject)jo, (String)"expires_in")};
    }

    @Override
    public WxCpUserDetail getUserDetail(String userTicket) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserdetail";
        JsonObject param = new JsonObject();
        param.addProperty("user_ticket", userTicket);
        String responseText = this.mainService.post(url, param.toString());
        return (WxCpUserDetail)new GsonBuilder().create().fromJson(responseText, WxCpUserDetail.class);
    }
}

