/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean;

import com.google.common.base.Splitter;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class WxCpMessageSendResult
implements Serializable {
    private static final long serialVersionUID = 916455987193190004L;
    @SerializedName(value="errcode")
    private Integer errCode;
    @SerializedName(value="errmsg")
    private String errMsg;
    @SerializedName(value="invaliduser")
    private String invalidUser;
    @SerializedName(value="invalidparty")
    private String invalidParty;
    @SerializedName(value="invalidtag")
    private String invalidTag;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public static WxCpMessageSendResult fromJson(String json) {
        return (WxCpMessageSendResult)WxCpGsonBuilder.INSTANCE.create().fromJson(json, WxCpMessageSendResult.class);
    }

    public List<String> getInvalidUserList() {
        return this.content2List(this.invalidUser);
    }

    private List<String> content2List(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.emptyList();
        }
        return Splitter.on((String)"|").splitToList((CharSequence)content);
    }

    public List<String> getInvalidPartyList() {
        return this.content2List(this.invalidParty);
    }

    public List<String> getInvalidTagList() {
        return this.content2List(this.invalidTag);
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public String getInvalidUser() {
        return this.invalidUser;
    }

    public String getInvalidParty() {
        return this.invalidParty;
    }

    public String getInvalidTag() {
        return this.invalidTag;
    }

    public void setErrCode(Integer errCode) {
        this.errCode = errCode;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setInvalidUser(String invalidUser) {
        this.invalidUser = invalidUser;
    }

    public void setInvalidParty(String invalidParty) {
        this.invalidParty = invalidParty;
    }

    public void setInvalidTag(String invalidTag) {
        this.invalidTag = invalidTag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpMessageSendResult)) {
            return false;
        }
        WxCpMessageSendResult other = (WxCpMessageSendResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$errCode = this.getErrCode();
        Integer other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !((Object)this$errCode).equals(other$errCode)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        String this$invalidUser = this.getInvalidUser();
        String other$invalidUser = other.getInvalidUser();
        if (this$invalidUser == null ? other$invalidUser != null : !this$invalidUser.equals(other$invalidUser)) {
            return false;
        }
        String this$invalidParty = this.getInvalidParty();
        String other$invalidParty = other.getInvalidParty();
        if (this$invalidParty == null ? other$invalidParty != null : !this$invalidParty.equals(other$invalidParty)) {
            return false;
        }
        String this$invalidTag = this.getInvalidTag();
        String other$invalidTag = other.getInvalidTag();
        return !(this$invalidTag == null ? other$invalidTag != null : !this$invalidTag.equals(other$invalidTag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpMessageSendResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : ((Object)$errCode).hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        String $invalidUser = this.getInvalidUser();
        result = result * 59 + ($invalidUser == null ? 43 : $invalidUser.hashCode());
        String $invalidParty = this.getInvalidParty();
        result = result * 59 + ($invalidParty == null ? 43 : $invalidParty.hashCode());
        String $invalidTag = this.getInvalidTag();
        result = result * 59 + ($invalidTag == null ? 43 : $invalidTag.hashCode());
        return result;
    }
}

