/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.bean.Gender;
import me.chanjar.weixin.cp.bean.WxCpUser;

public class WxCpUserGsonAdapter
implements JsonDeserializer<WxCpUser>,
JsonSerializer<WxCpUser> {
    public WxCpUser deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject o = json.getAsJsonObject();
        WxCpUser user = new WxCpUser();
        if (o.get("department") != null) {
            JsonArray departJsonArray = o.get("department").getAsJsonArray();
            Integer[] departIds = new Integer[departJsonArray.size()];
            int i = 0;
            for (JsonElement jsonElement : departJsonArray) {
                departIds[i++] = jsonElement.getAsInt();
            }
            user.setDepartIds(departIds);
        }
        user.setUserId(GsonHelper.getString((JsonObject)o, (String)"userid"));
        user.setName(GsonHelper.getString((JsonObject)o, (String)"name"));
        user.setPosition(GsonHelper.getString((JsonObject)o, (String)"position"));
        user.setMobile(GsonHelper.getString((JsonObject)o, (String)"mobile"));
        user.setGender(Gender.fromCode(GsonHelper.getString((JsonObject)o, (String)"gender")));
        user.setEmail(GsonHelper.getString((JsonObject)o, (String)"email"));
        user.setAvatar(GsonHelper.getString((JsonObject)o, (String)"avatar"));
        user.setAvatarMediaId(GsonHelper.getString((JsonObject)o, (String)"avatar_mediaid"));
        user.setStatus(GsonHelper.getInteger((JsonObject)o, (String)"status"));
        user.setEnable(GsonHelper.getInteger((JsonObject)o, (String)"enable"));
        user.setIsLeader(GsonHelper.getInteger((JsonObject)o, (String)"isleader"));
        user.setHideMobile(GsonHelper.getInteger((JsonObject)o, (String)"hide_mobile"));
        user.setEnglishName(GsonHelper.getString((JsonObject)o, (String)"english_name"));
        user.setTelephone(GsonHelper.getString((JsonObject)o, (String)"telephone"));
        user.setQrCode(GsonHelper.getString((JsonObject)o, (String)"qr_code"));
        user.setToInvite(GsonHelper.getBoolean((JsonObject)o, (String)"to_invite"));
        if (GsonHelper.isNotNull((JsonElement)o.get("extattr"))) {
            JsonArray attrJsonElements = o.get("extattr").getAsJsonObject().get("attrs").getAsJsonArray();
            for (JsonElement attrJsonElement : attrJsonElements) {
                WxCpUser.Attr attr = new WxCpUser.Attr(GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)"name"), GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)"value"));
                user.getExtAttrs().add(attr);
            }
        }
        return user;
    }

    public JsonElement serialize(WxCpUser user, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        if (user.getUserId() != null) {
            o.addProperty("userid", user.getUserId());
        }
        if (user.getName() != null) {
            o.addProperty("name", user.getName());
        }
        if (user.getDepartIds() != null) {
            JsonArray jsonArray = new JsonArray();
            for (Integer departId : user.getDepartIds()) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)departId));
            }
            o.add("department", (JsonElement)jsonArray);
        }
        if (user.getPosition() != null) {
            o.addProperty("position", user.getPosition());
        }
        if (user.getMobile() != null) {
            o.addProperty("mobile", user.getMobile());
        }
        if (user.getGender() != null) {
            o.addProperty("gender", user.getGender().getCode());
        }
        if (user.getEmail() != null) {
            o.addProperty("email", user.getEmail());
        }
        if (user.getAvatar() != null) {
            o.addProperty("avatar", user.getAvatar());
        }
        if (user.getAvatarMediaId() != null) {
            o.addProperty("avatar_mediaid", user.getAvatarMediaId());
        }
        if (user.getStatus() != null) {
            o.addProperty("status", (Number)user.getStatus());
        }
        if (user.getEnable() != null) {
            o.addProperty("enable", (Number)user.getEnable());
        }
        if (user.getIsLeader() != null) {
            o.addProperty("isleader", (Number)user.getIsLeader());
        }
        if (user.getHideMobile() != null) {
            o.addProperty("hide_mobile", (Number)user.getHideMobile());
        }
        if (user.getEnglishName() != null) {
            o.addProperty("english_name", user.getEnglishName());
        }
        if (user.getTelephone() != null) {
            o.addProperty("telephone", user.getTelephone());
        }
        if (user.getQrCode() != null) {
            o.addProperty("qr_code", user.getQrCode());
        }
        if (user.getToInvite() != null) {
            o.addProperty("to_invite", user.getToInvite());
        }
        if (user.getExtAttrs().size() > 0) {
            JsonArray attrsJsonArray = new JsonArray();
            for (WxCpUser.Attr attr : user.getExtAttrs()) {
                JsonObject attrJson = new JsonObject();
                attrJson.addProperty("name", attr.getName());
                attrJson.addProperty("value", attr.getValue());
                attrsJsonArray.add((JsonElement)attrJson);
            }
            JsonObject attrsJson = new JsonObject();
            attrsJson.add("attrs", (JsonElement)attrsJsonArray);
            o.add("extattr", (JsonElement)attrsJson);
        }
        return o;
    }
}

