/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.cp.api.WxCpChatService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpAppChatMessage;
import me.chanjar.weixin.cp.bean.WxCpChat;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.apache.commons.lang3.StringUtils;

public class WxCpChatServiceImpl
implements WxCpChatService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private final WxCpService cpService;

    WxCpChatServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }

    @Override
    public String chatCreate(String name, String owner, List<String> users, String chatId) throws WxErrorException {
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            data.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            data.put("owner", owner);
        }
        if (users != null) {
            data.put("userlist", users);
        }
        if (StringUtils.isNotBlank((CharSequence)chatId)) {
            data.put("chatid", chatId);
        }
        String result = this.cpService.post("https://qyapi.weixin.qq.com/cgi-bin/appchat/create", WxGsonBuilder.create().toJson(data));
        return new JsonParser().parse(result).getAsJsonObject().get("chatid").getAsString();
    }

    @Override
    public String create(String name, String owner, List<String> users, String chatId) throws WxErrorException {
        return this.chatCreate(name, owner, users, chatId);
    }

    @Override
    public void chatUpdate(String chatId, String name, String owner, List<String> usersToAdd, List<String> usersToDelete) throws WxErrorException {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        if (StringUtils.isNotBlank((CharSequence)chatId)) {
            data.put("chatid", chatId);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            data.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            data.put("owner", owner);
        }
        if (usersToAdd != null && !usersToAdd.isEmpty()) {
            data.put("add_user_list", usersToAdd);
        }
        if (usersToDelete != null && !usersToDelete.isEmpty()) {
            data.put("del_user_list", usersToDelete);
        }
        this.cpService.post("https://qyapi.weixin.qq.com/cgi-bin/appchat/update", WxGsonBuilder.create().toJson(data));
    }

    @Override
    public void update(String chatId, String name, String owner, List<String> usersToAdd, List<String> usersToDelete) throws WxErrorException {
        this.chatUpdate(chatId, name, owner, usersToAdd, usersToDelete);
    }

    @Override
    public WxCpChat chatGet(String chatId) throws WxErrorException {
        String result = this.cpService.get("https://qyapi.weixin.qq.com/cgi-bin/appchat/get?chatid=" + chatId, null);
        return (WxCpChat)WxCpGsonBuilder.create().fromJson(JSON_PARSER.parse(result).getAsJsonObject().getAsJsonObject("chat_info").toString(), WxCpChat.class);
    }

    @Override
    public WxCpChat get(String chatId) throws WxErrorException {
        return this.chatGet(chatId);
    }

    @Override
    public void sendMsg(WxCpAppChatMessage message) throws WxErrorException {
        this.cpService.post("https://qyapi.weixin.qq.com/cgi-bin/appchat/send", message.toJson());
    }
}

