/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpExternalContactService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpUserExternalContactInfo;
import me.chanjar.weixin.cp.bean.WxCpUserExternalContactList;
import me.chanjar.weixin.cp.bean.WxCpUserWithExternalPermission;

public class WxCpExternalContactServiceImpl
implements WxCpExternalContactService {
    private WxCpService mainService;

    public WxCpExternalContactServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public WxCpUserExternalContactInfo getExternalContact(String userId) throws WxErrorException {
        String responseContent = this.mainService.get(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/crm/get_external_contact?external_userid=" + userId), null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public List<String> listExternalContacts(String userId) throws WxErrorException {
        String responseContent = this.mainService.get(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/list?userid=" + userId), null);
        WxCpUserExternalContactList list = WxCpUserExternalContactList.fromJson(responseContent);
        return list.getExternalUserId();
    }

    @Override
    public List<String> listFollowUser() throws WxErrorException {
        String responseContent = this.mainService.get(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_follow_user_list"), null);
        WxCpUserWithExternalPermission list = WxCpUserWithExternalPermission.fromJson(responseContent);
        return list.getFollowUser();
    }
}

