/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.BaseMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.cp.api.WxCpMediaService;
import me.chanjar.weixin.cp.api.WxCpService;

public class WxCpMediaServiceImpl
implements WxCpMediaService {
    private final WxCpService mainService;

    @Override
    public WxMediaUploadResult upload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.upload(mediaType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    @Override
    public WxMediaUploadResult upload(String mediaType, File file) throws WxErrorException {
        return (WxMediaUploadResult)this.mainService.execute(MediaUploadRequestExecutor.create(this.mainService.getRequestHttp()), this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/upload?type=" + mediaType), file);
    }

    @Override
    public File download(String mediaId) throws WxErrorException {
        return (File)this.mainService.execute(BaseMediaDownloadRequestExecutor.create(this.mainService.getRequestHttp(), (File)this.mainService.getWxCpConfigStorage().getTmpDirFile()), this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/get"), "media_id=" + mediaId);
    }

    @Override
    public File getJssdkFile(String mediaId) throws WxErrorException {
        return (File)this.mainService.execute(BaseMediaDownloadRequestExecutor.create(this.mainService.getRequestHttp(), (File)this.mainService.getWxCpConfigStorage().getTmpDirFile()), this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/get/jssdk"), "media_id=" + mediaId);
    }

    @Override
    public String uploadImg(File file) throws WxErrorException {
        WxMediaUploadResult result = (WxMediaUploadResult)this.mainService.execute(MediaUploadRequestExecutor.create(this.mainService.getRequestHttp()), this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/uploadimg"), file);
        return result.getUrl();
    }

    @ConstructorProperties(value={"mainService"})
    public WxCpMediaServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

