/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpOaService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpApprovalDataResult;
import me.chanjar.weixin.cp.bean.WxCpCheckinData;
import me.chanjar.weixin.cp.bean.WxCpCheckinOption;
import me.chanjar.weixin.cp.bean.WxCpDialRecord;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpOaServiceImpl
implements WxCpOaService {
    private final WxCpService mainService;

    @Override
    public List<WxCpCheckinData> getCheckinData(Integer openCheckinDataType, Date startTime, Date endTime, List<String> userIdList) throws WxErrorException {
        long starttimestamp;
        if (startTime == null || endTime == null) {
            throw new RuntimeException("starttime and endtime can't be null");
        }
        if (userIdList == null || userIdList.size() > 100) {
            throw new RuntimeException("\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8d85\u8fc7100\u4e2a\uff0c\u82e5\u7528\u6237\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
        }
        long endtimestamp = endTime.getTime() / 1000L;
        if (endtimestamp - (starttimestamp = startTime.getTime() / 1000L) < 0L || endtimestamp - starttimestamp >= 2592000L) {
            throw new RuntimeException("\u83b7\u53d6\u8bb0\u5f55\u65f6\u95f4\u8de8\u5ea6\u4e0d\u8d85\u8fc7\u4e00\u4e2a\u6708");
        }
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.addProperty("opencheckindatatype", (Number)openCheckinDataType);
        jsonObject.addProperty("starttime", (Number)starttimestamp);
        jsonObject.addProperty("endtime", (Number)endtimestamp);
        for (String userid : userIdList) {
            jsonArray.add(userid);
        }
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        String responseContent = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/checkin/getcheckindata"), jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJsonElement.getAsJsonObject().get("checkindata"), new TypeToken<List<WxCpCheckinData>>(){}.getType());
    }

    @Override
    public List<WxCpCheckinOption> getCheckinOption(Date datetime, List<String> userIdList) throws WxErrorException {
        if (datetime == null) {
            throw new RuntimeException("datetime can't be null");
        }
        if (userIdList == null || userIdList.size() > 100) {
            throw new RuntimeException("\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8d85\u8fc7100\u4e2a\uff0c\u82e5\u7528\u6237\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
        }
        JsonArray jsonArray = new JsonArray();
        for (String userid : userIdList) {
            jsonArray.add(userid);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("datetime", (Number)(datetime.getTime() / 1000L));
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        String responseContent = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/checkin/getcheckinoption"), jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJsonElement.getAsJsonObject().get("info"), new TypeToken<List<WxCpCheckinOption>>(){}.getType());
    }

    @Override
    public WxCpApprovalDataResult getApprovalData(Date startTime, Date endTime, Long nextSpnum) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("starttime", (Number)(startTime.getTime() / 1000L));
        jsonObject.addProperty("endtime", (Number)(endTime.getTime() / 1000L));
        if (nextSpnum != null) {
            jsonObject.addProperty("next_spnum", (Number)nextSpnum);
        }
        String responseContent = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/corp/getapprovaldata"), jsonObject.toString());
        return (WxCpApprovalDataResult)WxCpGsonBuilder.create().fromJson(responseContent, WxCpApprovalDataResult.class);
    }

    @Override
    public List<WxCpDialRecord> getDialRecord(Date startTime, Date endTime, Integer offset, Integer limit) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        if (offset == null) {
            offset = 0;
        }
        if (limit == null || limit <= 0) {
            limit = 100;
        }
        jsonObject.addProperty("offset", (Number)offset);
        jsonObject.addProperty("limit", (Number)limit);
        if (startTime != null && endTime != null) {
            long starttimestamp;
            long endtimestamp = endTime.getTime() / 1000L;
            if (endtimestamp - (starttimestamp = startTime.getTime() / 1000L) < 0L || endtimestamp - starttimestamp >= 2592000L) {
                throw new RuntimeException("\u53d7\u9650\u4e8e\u7f51\u7edc\u4f20\u8f93\uff0c\u8d77\u6b62\u65f6\u95f4\u7684\u6700\u5927\u8de8\u5ea6\u4e3a30\u5929\uff0c\u5982\u8d85\u8fc730\u5929\uff0c\u5219\u4ee5\u7ed3\u675f\u65f6\u95f4\u4e3a\u57fa\u51c6\u5411\u524d\u53d630\u5929\u8fdb\u884c\u67e5\u8be2");
            }
            jsonObject.addProperty("start_time", (Number)starttimestamp);
            jsonObject.addProperty("end_time", (Number)endtimestamp);
        }
        String responseContent = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/dial/get_dial_record"), jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJsonElement.getAsJsonObject().get("record"), new TypeToken<List<WxCpDialRecord>>(){}.getType());
    }

    public WxCpOaServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

