/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.config.impl;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpTpRedissonConfigImpl
implements WxCpTpConfigStorage,
Serializable {
    @NonNull
    private final WxRedisOps wxRedisOps;
    private final String keyPrefix = "";
    private final String suiteAccessTokenKey = ":suiteAccessTokenKey:";
    private final String suiteTicketKey = ":suiteTicketKey:";
    private final String accessTokenKey = ":accessTokenKey:";
    private final String authCorpJsApiTicketKey = ":authCorpJsApiTicketKey:";
    private final String authSuiteJsApiTicketKey = ":authSuiteJsApiTicketKey:";
    private volatile String baseApiUrl;
    private volatile String httpProxyHost;
    private volatile int httpProxyPort;
    private volatile String httpProxyUsername;
    private volatile String httpProxyPassword;
    private volatile ApacheHttpClientBuilder apacheHttpClientBuilder;
    private volatile File tmpDirFile;
    private volatile String suiteId;
    private volatile String suiteSecret;
    private volatile String token;
    private volatile String aesKey;
    private volatile String corpId;
    private volatile String corpSecret;

    @Override
    public void setBaseApiUrl(String baseUrl) {
        this.baseApiUrl = baseUrl;
    }

    @Override
    public String getApiUrl(String path) {
        if (this.baseApiUrl == null) {
            this.baseApiUrl = "https://qyapi.weixin.qq.com";
        }
        return this.baseApiUrl + path;
    }

    @Override
    public String getSuiteAccessToken() {
        return this.wxRedisOps.getValue(this.keyWithPrefix(":suiteAccessTokenKey:"));
    }

    @Override
    public boolean isSuiteAccessTokenExpired() {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteAccessTokenKey:")) == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteAccessTokenKey:")) == -2L;
    }

    @Override
    public void expireSuiteAccessToken() {
        this.wxRedisOps.expire(this.keyWithPrefix(":suiteAccessTokenKey:"), 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateSuiteAccessToken(WxAccessToken suiteAccessToken) {
        this.updateSuiteAccessToken(suiteAccessToken.getAccessToken(), suiteAccessToken.getExpiresIn());
    }

    @Override
    public void updateSuiteAccessToken(String suiteAccessToken, int expiresInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(":suiteAccessTokenKey:"), suiteAccessToken, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getSuiteTicket() {
        return this.wxRedisOps.getValue(this.keyWithPrefix(":suiteTicketKey:"));
    }

    @Override
    public boolean isSuiteTicketExpired() {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteTicketKey:")) == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteTicketKey:")) == -2L;
    }

    @Override
    public void expireSuiteTicket() {
        this.wxRedisOps.expire(this.keyWithPrefix(":suiteTicketKey:"), 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateSuiteTicket(String suiteTicket, int expiresInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(":suiteTicketKey:"), suiteTicket, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getSuiteId() {
        return this.suiteId;
    }

    @Override
    public String getSuiteSecret() {
        return this.suiteSecret;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getAesKey() {
        return this.aesKey;
    }

    @Override
    public String getCorpId() {
        return this.corpId;
    }

    @Override
    public String getCorpSecret() {
        return this.corpSecret;
    }

    @Override
    public String getAccessToken(String authCorpId) {
        return this.wxRedisOps.getValue(this.keyWithPrefix(authCorpId) + ":accessTokenKey:");
    }

    @Override
    public boolean isAccessTokenExpired(String authCorpId) {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":accessTokenKey:") == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":accessTokenKey:") == -2L;
    }

    @Override
    public void updateAccessToken(String authCorpId, String accessToken, int expiredInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(authCorpId) + ":accessTokenKey:", accessToken, expiredInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getAuthCorpJsApiTicket(String authCorpId) {
        return this.wxRedisOps.getValue(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:");
    }

    @Override
    public boolean isAuthCorpJsApiTicketExpired(String authCorpId) {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:") == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:") == -2L;
    }

    @Override
    public void updateAuthCorpJsApiTicket(String authCorpId, String jsApiTicket, int expiredInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:", jsApiTicket, expiredInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getAuthSuiteJsApiTicket(String authCorpId) {
        return this.wxRedisOps.getValue(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:");
    }

    @Override
    public boolean isAuthSuiteJsApiTicketExpired(String authCorpId) {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:") == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:") == -2L;
    }

    @Override
    public void updateAuthSuiteJsApiTicket(String authCorpId, String jsApiTicket, int expiredInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:", jsApiTicket, expiredInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Override
    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    @Override
    public boolean autoRefreshToken() {
        return false;
    }

    public String toString() {
        return WxCpGsonBuilder.create().toJson((Object)this);
    }

    private String keyWithPrefix(String key) {
        return "" + key;
    }

    WxCpTpRedissonConfigImpl(@NonNull WxRedisOps wxRedisOps, String baseApiUrl, String httpProxyHost, int httpProxyPort, String httpProxyUsername, String httpProxyPassword, ApacheHttpClientBuilder apacheHttpClientBuilder, File tmpDirFile, String suiteId, String suiteSecret, String token, String aesKey, String corpId, String corpSecret) {
        if (wxRedisOps == null) {
            throw new NullPointerException("wxRedisOps is marked non-null but is null");
        }
        this.wxRedisOps = wxRedisOps;
        this.baseApiUrl = baseApiUrl;
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.httpProxyUsername = httpProxyUsername;
        this.httpProxyPassword = httpProxyPassword;
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
        this.tmpDirFile = tmpDirFile;
        this.suiteId = suiteId;
        this.suiteSecret = suiteSecret;
        this.token = token;
        this.aesKey = aesKey;
        this.corpId = corpId;
        this.corpSecret = corpSecret;
    }

    public static WxCpTpRedissonConfigImplBuilder builder() {
        return new WxCpTpRedissonConfigImplBuilder();
    }

    public static class WxCpTpRedissonConfigImplBuilder {
        private WxRedisOps wxRedisOps;
        private String baseApiUrl;
        private String httpProxyHost;
        private int httpProxyPort;
        private String httpProxyUsername;
        private String httpProxyPassword;
        private ApacheHttpClientBuilder apacheHttpClientBuilder;
        private File tmpDirFile;
        private String suiteId;
        private String suiteSecret;
        private String token;
        private String aesKey;
        private String corpId;
        private String corpSecret;

        WxCpTpRedissonConfigImplBuilder() {
        }

        public WxCpTpRedissonConfigImplBuilder wxRedisOps(@NonNull WxRedisOps wxRedisOps) {
            if (wxRedisOps == null) {
                throw new NullPointerException("wxRedisOps is marked non-null but is null");
            }
            this.wxRedisOps = wxRedisOps;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder baseApiUrl(String baseApiUrl) {
            this.baseApiUrl = baseApiUrl;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder httpProxyHost(String httpProxyHost) {
            this.httpProxyHost = httpProxyHost;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder httpProxyPort(int httpProxyPort) {
            this.httpProxyPort = httpProxyPort;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder httpProxyUsername(String httpProxyUsername) {
            this.httpProxyUsername = httpProxyUsername;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder httpProxyPassword(String httpProxyPassword) {
            this.httpProxyPassword = httpProxyPassword;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder apacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
            this.apacheHttpClientBuilder = apacheHttpClientBuilder;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder tmpDirFile(File tmpDirFile) {
            this.tmpDirFile = tmpDirFile;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder suiteId(String suiteId) {
            this.suiteId = suiteId;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder suiteSecret(String suiteSecret) {
            this.suiteSecret = suiteSecret;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder token(String token) {
            this.token = token;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder aesKey(String aesKey) {
            this.aesKey = aesKey;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder corpId(String corpId) {
            this.corpId = corpId;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder corpSecret(String corpSecret) {
            this.corpSecret = corpSecret;
            return this;
        }

        public WxCpTpRedissonConfigImpl build() {
            return new WxCpTpRedissonConfigImpl(this.wxRedisOps, this.baseApiUrl, this.httpProxyHost, this.httpProxyPort, this.httpProxyUsername, this.httpProxyPassword, this.apacheHttpClientBuilder, this.tmpDirFile, this.suiteId, this.suiteSecret, this.token, this.aesKey, this.corpId, this.corpSecret);
        }

        public String toString() {
            return "WxCpTpRedissonConfigImpl.WxCpTpRedissonConfigImplBuilder(wxRedisOps=" + this.wxRedisOps + ", baseApiUrl=" + this.baseApiUrl + ", httpProxyHost=" + this.httpProxyHost + ", httpProxyPort=" + this.httpProxyPort + ", httpProxyUsername=" + this.httpProxyUsername + ", httpProxyPassword=" + this.httpProxyPassword + ", apacheHttpClientBuilder=" + this.apacheHttpClientBuilder + ", tmpDirFile=" + this.tmpDirFile + ", suiteId=" + this.suiteId + ", suiteSecret=" + this.suiteSecret + ", token=" + this.token + ", aesKey=" + this.aesKey + ", corpId=" + this.corpId + ", corpSecret=" + this.corpSecret + ")";
        }
    }
}

