/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.cp.bean.article.MpnewsArticle;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.messagebuilder.FileBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MarkdownMsgBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MiniProgramNoticeMsgBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MpnewsBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TaskCardBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextCardBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.VideoBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.VoiceBuilder;
import me.chanjar.weixin.cp.bean.taskcard.TaskCardButton;
import org.apache.commons.lang3.StringUtils;

public class WxCpMessage
implements Serializable {
    private static final long serialVersionUID = -2082278303476631708L;
    private String toUser;
    private String toParty;
    private String toTag;
    private Integer agentId;
    private String msgType;
    private String content;
    private String mediaId;
    private String thumbMediaId;
    private String title;
    private String description;
    private String musicUrl;
    private String hqMusicUrl;
    private String safe;
    private String url;
    private String btnTxt;
    private List<NewArticle> articles = new ArrayList<NewArticle>();
    private List<MpnewsArticle> mpnewsArticles = new ArrayList<MpnewsArticle>();
    private String appId;
    private String page;
    private Boolean emphasisFirstItem;
    private Map<String, String> contentItems;
    private Boolean enableIdTrans;
    private Boolean enableDuplicateCheck;
    private Integer duplicateCheckInterval;
    private String taskId;
    private List<TaskCardButton> taskButtons = new ArrayList<TaskCardButton>();

    public static TextBuilder TEXT() {
        return new TextBuilder();
    }

    public static TextCardBuilder TEXTCARD() {
        return new TextCardBuilder();
    }

    public static ImageBuilder IMAGE() {
        return new ImageBuilder();
    }

    public static VoiceBuilder VOICE() {
        return new VoiceBuilder();
    }

    public static VideoBuilder VIDEO() {
        return new VideoBuilder();
    }

    public static NewsBuilder NEWS() {
        return new NewsBuilder();
    }

    public static MpnewsBuilder MPNEWS() {
        return new MpnewsBuilder();
    }

    public static MarkdownMsgBuilder MARKDOWN() {
        return new MarkdownMsgBuilder();
    }

    public static FileBuilder FILE() {
        return new FileBuilder();
    }

    public static TaskCardBuilder TASKCARD() {
        return new TaskCardBuilder();
    }

    public static MiniProgramNoticeMsgBuilder newMiniProgramNoticeBuilder() {
        return new MiniProgramNoticeMsgBuilder();
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String toJson() {
        JsonObject messageJson = new JsonObject();
        if (this.getAgentId() != null) {
            messageJson.addProperty("agentid", (Number)this.getAgentId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getToUser())) {
            messageJson.addProperty("touser", this.getToUser());
        }
        messageJson.addProperty("msgtype", this.getMsgType());
        if (StringUtils.isNotBlank((CharSequence)this.getToParty())) {
            messageJson.addProperty("toparty", this.getToParty());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getToTag())) {
            messageJson.addProperty("totag", this.getToTag());
        }
        if (this.getEnableIdTrans().booleanValue()) {
            messageJson.addProperty("enable_id_trans", (Number)1);
        }
        if (this.getEnableDuplicateCheck().booleanValue()) {
            messageJson.addProperty("enable_duplicate_check", (Number)1);
        }
        if (this.getDuplicateCheckInterval() != null) {
            messageJson.addProperty("duplicate_check_interval", (Number)this.getDuplicateCheckInterval());
        }
        this.handleMsgType(messageJson);
        if (StringUtils.isNotBlank((CharSequence)this.getSafe())) {
            messageJson.addProperty("safe", this.getSafe());
        }
        return messageJson.toString();
    }

    private void handleMsgType(JsonObject messageJson) {
        switch (this.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "markdown": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("markdown", (JsonElement)text);
                break;
            }
            case "textcard": {
                JsonObject text = new JsonObject();
                text.addProperty("title", this.getTitle());
                text.addProperty("description", this.getDescription());
                text.addProperty("url", this.getUrl());
                text.addProperty("btntxt", this.getBtnTxt());
                messageJson.add("textcard", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("image", (JsonElement)image);
                break;
            }
            case "file": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("file", (JsonElement)image);
                break;
            }
            case "voice": {
                JsonObject voice = new JsonObject();
                voice.addProperty("media_id", this.getMediaId());
                messageJson.add("voice", (JsonElement)voice);
                break;
            }
            case "video": {
                JsonObject video = new JsonObject();
                video.addProperty("media_id", this.getMediaId());
                video.addProperty("thumb_media_id", this.getThumbMediaId());
                video.addProperty("title", this.getTitle());
                video.addProperty("description", this.getDescription());
                messageJson.add("video", (JsonElement)video);
                break;
            }
            case "news": {
                JsonObject newsJsonObject = new JsonObject();
                JsonArray articleJsonArray = new JsonArray();
                for (NewArticle article : this.getArticles()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("title", article.getTitle());
                    articleJson.addProperty("description", article.getDescription());
                    articleJson.addProperty("url", article.getUrl());
                    articleJson.addProperty("picurl", article.getPicUrl());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("news", (JsonElement)newsJsonObject);
                break;
            }
            case "mpnews": {
                JsonObject newsJsonObject = new JsonObject();
                if (this.getMediaId() != null) {
                    newsJsonObject.addProperty("media_id", this.getMediaId());
                } else {
                    JsonArray articleJsonArray = new JsonArray();
                    for (MpnewsArticle article : this.getMpnewsArticles()) {
                        this.article2Json(articleJsonArray, article);
                    }
                    newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                }
                messageJson.add("mpnews", (JsonElement)newsJsonObject);
                break;
            }
            case "taskcard": {
                JsonObject text = new JsonObject();
                text.addProperty("title", this.getTitle());
                text.addProperty("description", this.getDescription());
                if (StringUtils.isNotBlank((CharSequence)this.getUrl())) {
                    text.addProperty("url", this.getUrl());
                }
                text.addProperty("task_id", this.getTaskId());
                JsonArray buttonJsonArray = new JsonArray();
                for (TaskCardButton button : this.getTaskButtons()) {
                    this.btn2Json(buttonJsonArray, button);
                }
                text.add("btn", (JsonElement)buttonJsonArray);
                messageJson.add("taskcard", (JsonElement)text);
                break;
            }
            case "miniprogram_notice": {
                JsonObject notice = new JsonObject();
                notice.addProperty("appid", this.getAppId());
                notice.addProperty("page", this.getPage());
                notice.addProperty("description", this.getDescription());
                notice.addProperty("title", this.getTitle());
                notice.addProperty("emphasis_first_item", this.getEmphasisFirstItem());
                JsonArray content = new JsonArray();
                for (Map.Entry<String, String> item : this.getContentItems().entrySet()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("key", item.getKey());
                    articleJson.addProperty("value", item.getValue());
                    content.add((JsonElement)articleJson);
                }
                notice.add("content_item", (JsonElement)content);
                messageJson.add("miniprogram_notice", (JsonElement)notice);
                break;
            }
        }
    }

    private void btn2Json(JsonArray buttonJsonArray, TaskCardButton button) {
        JsonObject buttonJson = new JsonObject();
        buttonJson.addProperty("key", button.getKey());
        buttonJson.addProperty("name", button.getName());
        if (StringUtils.isNotBlank((CharSequence)button.getReplaceName())) {
            buttonJson.addProperty("replace_name", button.getReplaceName());
        }
        if (StringUtils.isNotBlank((CharSequence)button.getColor())) {
            buttonJson.addProperty("color", button.getColor());
        }
        if (button.getBold() != null) {
            buttonJson.addProperty("is_bold", button.getBold());
        }
        buttonJsonArray.add((JsonElement)buttonJson);
    }

    private void article2Json(JsonArray articleJsonArray, MpnewsArticle article) {
        JsonObject articleJson = new JsonObject();
        articleJson.addProperty("title", article.getTitle());
        articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
        articleJson.addProperty("author", article.getAuthor());
        articleJson.addProperty("content_source_url", article.getContentSourceUrl());
        articleJson.addProperty("content", article.getContent());
        articleJson.addProperty("digest", article.getDigest());
        articleJson.addProperty("show_cover_pic", article.getShowCoverPic());
        articleJsonArray.add((JsonElement)articleJson);
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getToParty() {
        return this.toParty;
    }

    public String getToTag() {
        return this.toTag;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMusicUrl() {
        return this.musicUrl;
    }

    public String getHqMusicUrl() {
        return this.hqMusicUrl;
    }

    public String getSafe() {
        return this.safe;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBtnTxt() {
        return this.btnTxt;
    }

    public List<NewArticle> getArticles() {
        return this.articles;
    }

    public List<MpnewsArticle> getMpnewsArticles() {
        return this.mpnewsArticles;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getEmphasisFirstItem() {
        return this.emphasisFirstItem;
    }

    public Map<String, String> getContentItems() {
        return this.contentItems;
    }

    public Boolean getEnableIdTrans() {
        return this.enableIdTrans;
    }

    public Boolean getEnableDuplicateCheck() {
        return this.enableDuplicateCheck;
    }

    public Integer getDuplicateCheckInterval() {
        return this.duplicateCheckInterval;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public List<TaskCardButton> getTaskButtons() {
        return this.taskButtons;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public void setToParty(String toParty) {
        this.toParty = toParty;
    }

    public void setToTag(String toTag) {
        this.toTag = toTag;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMusicUrl(String musicUrl) {
        this.musicUrl = musicUrl;
    }

    public void setHqMusicUrl(String hqMusicUrl) {
        this.hqMusicUrl = hqMusicUrl;
    }

    public void setSafe(String safe) {
        this.safe = safe;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBtnTxt(String btnTxt) {
        this.btnTxt = btnTxt;
    }

    public void setArticles(List<NewArticle> articles) {
        this.articles = articles;
    }

    public void setMpnewsArticles(List<MpnewsArticle> mpnewsArticles) {
        this.mpnewsArticles = mpnewsArticles;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setEmphasisFirstItem(Boolean emphasisFirstItem) {
        this.emphasisFirstItem = emphasisFirstItem;
    }

    public void setContentItems(Map<String, String> contentItems) {
        this.contentItems = contentItems;
    }

    public void setEnableIdTrans(Boolean enableIdTrans) {
        this.enableIdTrans = enableIdTrans;
    }

    public void setEnableDuplicateCheck(Boolean enableDuplicateCheck) {
        this.enableDuplicateCheck = enableDuplicateCheck;
    }

    public void setDuplicateCheckInterval(Integer duplicateCheckInterval) {
        this.duplicateCheckInterval = duplicateCheckInterval;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskButtons(List<TaskCardButton> taskButtons) {
        this.taskButtons = taskButtons;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpMessage)) {
            return false;
        }
        WxCpMessage other = (WxCpMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$toUser = this.getToUser();
        String other$toUser = other.getToUser();
        if (this$toUser == null ? other$toUser != null : !this$toUser.equals(other$toUser)) {
            return false;
        }
        String this$toParty = this.getToParty();
        String other$toParty = other.getToParty();
        if (this$toParty == null ? other$toParty != null : !this$toParty.equals(other$toParty)) {
            return false;
        }
        String this$toTag = this.getToTag();
        String other$toTag = other.getToTag();
        if (this$toTag == null ? other$toTag != null : !this$toTag.equals(other$toTag)) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$thumbMediaId = this.getThumbMediaId();
        String other$thumbMediaId = other.getThumbMediaId();
        if (this$thumbMediaId == null ? other$thumbMediaId != null : !this$thumbMediaId.equals(other$thumbMediaId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$musicUrl = this.getMusicUrl();
        String other$musicUrl = other.getMusicUrl();
        if (this$musicUrl == null ? other$musicUrl != null : !this$musicUrl.equals(other$musicUrl)) {
            return false;
        }
        String this$hqMusicUrl = this.getHqMusicUrl();
        String other$hqMusicUrl = other.getHqMusicUrl();
        if (this$hqMusicUrl == null ? other$hqMusicUrl != null : !this$hqMusicUrl.equals(other$hqMusicUrl)) {
            return false;
        }
        String this$safe = this.getSafe();
        String other$safe = other.getSafe();
        if (this$safe == null ? other$safe != null : !this$safe.equals(other$safe)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$btnTxt = this.getBtnTxt();
        String other$btnTxt = other.getBtnTxt();
        if (this$btnTxt == null ? other$btnTxt != null : !this$btnTxt.equals(other$btnTxt)) {
            return false;
        }
        List<NewArticle> this$articles = this.getArticles();
        List<NewArticle> other$articles = other.getArticles();
        if (this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles)) {
            return false;
        }
        List<MpnewsArticle> this$mpnewsArticles = this.getMpnewsArticles();
        List<MpnewsArticle> other$mpnewsArticles = other.getMpnewsArticles();
        if (this$mpnewsArticles == null ? other$mpnewsArticles != null : !((Object)this$mpnewsArticles).equals(other$mpnewsArticles)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        Boolean this$emphasisFirstItem = this.getEmphasisFirstItem();
        Boolean other$emphasisFirstItem = other.getEmphasisFirstItem();
        if (this$emphasisFirstItem == null ? other$emphasisFirstItem != null : !((Object)this$emphasisFirstItem).equals(other$emphasisFirstItem)) {
            return false;
        }
        Map<String, String> this$contentItems = this.getContentItems();
        Map<String, String> other$contentItems = other.getContentItems();
        if (this$contentItems == null ? other$contentItems != null : !((Object)this$contentItems).equals(other$contentItems)) {
            return false;
        }
        Boolean this$enableIdTrans = this.getEnableIdTrans();
        Boolean other$enableIdTrans = other.getEnableIdTrans();
        if (this$enableIdTrans == null ? other$enableIdTrans != null : !((Object)this$enableIdTrans).equals(other$enableIdTrans)) {
            return false;
        }
        Boolean this$enableDuplicateCheck = this.getEnableDuplicateCheck();
        Boolean other$enableDuplicateCheck = other.getEnableDuplicateCheck();
        if (this$enableDuplicateCheck == null ? other$enableDuplicateCheck != null : !((Object)this$enableDuplicateCheck).equals(other$enableDuplicateCheck)) {
            return false;
        }
        Integer this$duplicateCheckInterval = this.getDuplicateCheckInterval();
        Integer other$duplicateCheckInterval = other.getDuplicateCheckInterval();
        if (this$duplicateCheckInterval == null ? other$duplicateCheckInterval != null : !((Object)this$duplicateCheckInterval).equals(other$duplicateCheckInterval)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        List<TaskCardButton> this$taskButtons = this.getTaskButtons();
        List<TaskCardButton> other$taskButtons = other.getTaskButtons();
        return !(this$taskButtons == null ? other$taskButtons != null : !((Object)this$taskButtons).equals(other$taskButtons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $toUser = this.getToUser();
        result = result * 59 + ($toUser == null ? 43 : $toUser.hashCode());
        String $toParty = this.getToParty();
        result = result * 59 + ($toParty == null ? 43 : $toParty.hashCode());
        String $toTag = this.getToTag();
        result = result * 59 + ($toTag == null ? 43 : $toTag.hashCode());
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $thumbMediaId = this.getThumbMediaId();
        result = result * 59 + ($thumbMediaId == null ? 43 : $thumbMediaId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $musicUrl = this.getMusicUrl();
        result = result * 59 + ($musicUrl == null ? 43 : $musicUrl.hashCode());
        String $hqMusicUrl = this.getHqMusicUrl();
        result = result * 59 + ($hqMusicUrl == null ? 43 : $hqMusicUrl.hashCode());
        String $safe = this.getSafe();
        result = result * 59 + ($safe == null ? 43 : $safe.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $btnTxt = this.getBtnTxt();
        result = result * 59 + ($btnTxt == null ? 43 : $btnTxt.hashCode());
        List<NewArticle> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        List<MpnewsArticle> $mpnewsArticles = this.getMpnewsArticles();
        result = result * 59 + ($mpnewsArticles == null ? 43 : ((Object)$mpnewsArticles).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        Boolean $emphasisFirstItem = this.getEmphasisFirstItem();
        result = result * 59 + ($emphasisFirstItem == null ? 43 : ((Object)$emphasisFirstItem).hashCode());
        Map<String, String> $contentItems = this.getContentItems();
        result = result * 59 + ($contentItems == null ? 43 : ((Object)$contentItems).hashCode());
        Boolean $enableIdTrans = this.getEnableIdTrans();
        result = result * 59 + ($enableIdTrans == null ? 43 : ((Object)$enableIdTrans).hashCode());
        Boolean $enableDuplicateCheck = this.getEnableDuplicateCheck();
        result = result * 59 + ($enableDuplicateCheck == null ? 43 : ((Object)$enableDuplicateCheck).hashCode());
        Integer $duplicateCheckInterval = this.getDuplicateCheckInterval();
        result = result * 59 + ($duplicateCheckInterval == null ? 43 : ((Object)$duplicateCheckInterval).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        List<TaskCardButton> $taskButtons = this.getTaskButtons();
        result = result * 59 + ($taskButtons == null ? 43 : ((Object)$taskButtons).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpMessage(toUser=" + this.getToUser() + ", toParty=" + this.getToParty() + ", toTag=" + this.getToTag() + ", agentId=" + this.getAgentId() + ", msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", mediaId=" + this.getMediaId() + ", thumbMediaId=" + this.getThumbMediaId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", musicUrl=" + this.getMusicUrl() + ", hqMusicUrl=" + this.getHqMusicUrl() + ", safe=" + this.getSafe() + ", url=" + this.getUrl() + ", btnTxt=" + this.getBtnTxt() + ", articles=" + this.getArticles() + ", mpnewsArticles=" + this.getMpnewsArticles() + ", appId=" + this.getAppId() + ", page=" + this.getPage() + ", emphasisFirstItem=" + this.getEmphasisFirstItem() + ", contentItems=" + this.getContentItems() + ", enableIdTrans=" + this.getEnableIdTrans() + ", enableDuplicateCheck=" + this.getEnableDuplicateCheck() + ", duplicateCheckInterval=" + this.getDuplicateCheckInterval() + ", taskId=" + this.getTaskId() + ", taskButtons=" + this.getTaskButtons() + ")";
    }
}

