/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.WxCpProviderToken;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpServiceApacheHttpClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpTpServiceImpl
extends WxCpTpServiceApacheHttpClientImpl {
    private static final Logger log = LoggerFactory.getLogger(WxCpTpServiceImpl.class);

    @Override
    public WxAccessToken getSuiteAccessTokenEntity() throws WxErrorException {
        return this.getSuiteAccessTokenEntity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxAccessToken getSuiteAccessTokenEntity(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isSuiteAccessTokenExpired() && !forceRefresh) {
            return this.configStorage.getSuiteAccessTokenEntity();
        }
        Lock lock = this.configStorage.getSuiteAccessTokenLock();
        lock.lock();
        try {
            if (!this.configStorage.isSuiteAccessTokenExpired() && !forceRefresh) {
                WxAccessToken wxAccessToken = this.configStorage.getSuiteAccessTokenEntity();
                return wxAccessToken;
            }
            super.getSuiteAccessToken(forceRefresh);
            WxAccessToken wxAccessToken = this.configStorage.getSuiteAccessTokenEntity();
            return wxAccessToken;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getSuiteAccessToken(boolean forceRefresh) throws WxErrorException {
        WxAccessToken suiteToken = this.getSuiteAccessTokenEntity(forceRefresh);
        return suiteToken.getAccessToken();
    }

    @Override
    public WxCpProviderToken getWxCpProviderTokenEntity() throws WxErrorException {
        return this.getWxCpProviderTokenEntity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxCpProviderToken getWxCpProviderTokenEntity(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isProviderTokenExpired() && !forceRefresh) {
            return this.configStorage.getProviderTokenEntity();
        }
        Lock lock = this.configStorage.getProviderAccessTokenLock();
        lock.lock();
        try {
            if (!this.configStorage.isProviderTokenExpired() && !forceRefresh) {
                WxCpProviderToken wxCpProviderToken = this.configStorage.getProviderTokenEntity();
                return wxCpProviderToken;
            }
            WxCpProviderToken wxCpProviderToken = super.getWxCpProviderTokenEntity(forceRefresh);
            return wxCpProviderToken;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public WxAccessToken getCorpToken(String authCorpId, String permanentCode) throws WxErrorException {
        return this.getCorpToken(authCorpId, permanentCode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxAccessToken getCorpToken(String authCorpId, String permanentCode, boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isAccessTokenExpired(authCorpId) && !forceRefresh) {
            return this.configStorage.getAccessTokenEntity(authCorpId);
        }
        Lock lock = this.configStorage.getAccessTokenLock(authCorpId);
        lock.lock();
        try {
            if (!this.configStorage.isAccessTokenExpired(authCorpId) && !forceRefresh) {
                WxAccessToken wxAccessToken = this.configStorage.getAccessTokenEntity(authCorpId);
                return wxAccessToken;
            }
            WxAccessToken accessToken = super.getCorpToken(authCorpId, permanentCode);
            this.configStorage.updateAccessToken(authCorpId, accessToken.getAccessToken(), accessToken.getExpiresIn());
            WxAccessToken wxAccessToken = accessToken;
            return wxAccessToken;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getAuthCorpJsApiTicket(String authCorpId) throws WxErrorException {
        return this.getAuthCorpJsApiTicket(authCorpId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAuthCorpJsApiTicket(String authCorpId, boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isAuthCorpJsApiTicketExpired(authCorpId) && !forceRefresh) {
            return this.configStorage.getAuthCorpJsApiTicket(authCorpId);
        }
        Lock lock = this.configStorage.getAuthCorpJsapiTicketLock(authCorpId);
        lock.lock();
        try {
            if (!this.configStorage.isAuthCorpJsApiTicketExpired(authCorpId) && !forceRefresh) {
                String string = this.configStorage.getAuthCorpJsApiTicket(authCorpId);
                return string;
            }
            if (forceRefresh) {
                this.configStorage.expireAuthCorpJsApiTicket(authCorpId);
            }
            String string = super.getAuthCorpJsApiTicket(authCorpId);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getSuiteJsApiTicket(String authCorpId) throws WxErrorException {
        return this.getSuiteJsApiTicket(authCorpId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSuiteJsApiTicket(String authCorpId, boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isAuthSuiteJsApiTicketExpired(authCorpId) && !forceRefresh) {
            return this.configStorage.getAuthSuiteJsApiTicket(authCorpId);
        }
        Lock lock = this.configStorage.getSuiteJsapiTicketLock(authCorpId);
        lock.lock();
        try {
            if (!this.configStorage.isAuthSuiteJsApiTicketExpired(authCorpId) && !forceRefresh) {
                String string = this.configStorage.getAuthSuiteJsApiTicket(authCorpId);
                return string;
            }
            if (forceRefresh) {
                this.configStorage.expireAuthSuiteJsApiTicket(authCorpId);
            }
            String string = super.getSuiteJsApiTicket(authCorpId);
            return string;
        }
        finally {
            lock.unlock();
        }
    }
}

