/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.cp.bean.article.MpnewsArticle;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.messagebuilder.FileBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MarkdownMsgBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MiniProgramNoticeMsgBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MpnewsBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TaskCardBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TemplateCardBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextCardBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.VideoBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.VoiceBuilder;
import me.chanjar.weixin.cp.bean.taskcard.TaskCardButton;
import me.chanjar.weixin.cp.bean.templatecard.CheckboxOption;
import me.chanjar.weixin.cp.bean.templatecard.HorizontalContent;
import me.chanjar.weixin.cp.bean.templatecard.MultipleSelect;
import me.chanjar.weixin.cp.bean.templatecard.QuoteArea;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardButton;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardJump;
import me.chanjar.weixin.cp.bean.templatecard.VerticalContent;
import org.apache.commons.lang3.StringUtils;

public class WxCpMessage
implements Serializable {
    private static final long serialVersionUID = -2082278303476631708L;
    private String toUser;
    private String toParty;
    private String toTag;
    private Integer agentId;
    private String msgType;
    private String content;
    private String mediaId;
    private String thumbMediaId;
    private String title;
    private String description;
    private String musicUrl;
    private String hqMusicUrl;
    private String safe;
    private String url;
    private String btnTxt;
    private List<NewArticle> articles = new ArrayList<NewArticle>();
    private List<MpnewsArticle> mpnewsArticles = new ArrayList<MpnewsArticle>();
    private String appId;
    private String page;
    private Boolean emphasisFirstItem;
    private Map<String, String> contentItems;
    private Boolean enableIdTrans = false;
    private Boolean enableDuplicateCheck = false;
    private Integer duplicateCheckInterval;
    private String taskId;
    private List<TaskCardButton> taskButtons = new ArrayList<TaskCardButton>();
    private String cardType;
    private String sourceIconUrl;
    private String sourceDesc;
    private String mainTitleTitle;
    private String mainTitleDesc;
    private String cardImageUrl;
    private Float cardImageAspectRatio;
    private String emphasisContentTitle;
    private String emphasisContentDesc;
    private String subTitleText;
    private List<VerticalContent> verticalContents;
    private List<HorizontalContent> horizontalContents;
    private List<TemplateCardJump> jumps;
    private Integer cardActionType;
    private String cardActionUrl;
    private String cardActionAppid;
    private String cardActionPagepath;
    private List<TemplateCardButton> buttons;
    private String checkboxQuestionKey;
    private Integer checkboxMode;
    private List<CheckboxOption> options;
    private String submitButtonText;
    private String submitButtonKey;
    private List<MultipleSelect> selects;
    private QuoteArea quoteArea;

    public static TextBuilder TEXT() {
        return new TextBuilder();
    }

    public static TextCardBuilder TEXTCARD() {
        return new TextCardBuilder();
    }

    public static ImageBuilder IMAGE() {
        return new ImageBuilder();
    }

    public static VoiceBuilder VOICE() {
        return new VoiceBuilder();
    }

    public static VideoBuilder VIDEO() {
        return new VideoBuilder();
    }

    public static NewsBuilder NEWS() {
        return new NewsBuilder();
    }

    public static MpnewsBuilder MPNEWS() {
        return new MpnewsBuilder();
    }

    public static MarkdownMsgBuilder MARKDOWN() {
        return new MarkdownMsgBuilder();
    }

    public static FileBuilder FILE() {
        return new FileBuilder();
    }

    public static TaskCardBuilder TASKCARD() {
        return new TaskCardBuilder();
    }

    public static TemplateCardBuilder TEMPLATECARD() {
        return new TemplateCardBuilder();
    }

    public static MiniProgramNoticeMsgBuilder newMiniProgramNoticeBuilder() {
        return new MiniProgramNoticeMsgBuilder();
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String toJson() {
        JsonObject messageJson = new JsonObject();
        if (this.getAgentId() != null) {
            messageJson.addProperty("agentid", (Number)this.getAgentId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getToUser())) {
            messageJson.addProperty("touser", this.getToUser());
        }
        messageJson.addProperty("msgtype", this.getMsgType());
        if (StringUtils.isNotBlank((CharSequence)this.getToParty())) {
            messageJson.addProperty("toparty", this.getToParty());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getToTag())) {
            messageJson.addProperty("totag", this.getToTag());
        }
        if (this.getEnableIdTrans().booleanValue()) {
            messageJson.addProperty("enable_id_trans", (Number)1);
        }
        if (this.getEnableDuplicateCheck().booleanValue()) {
            messageJson.addProperty("enable_duplicate_check", (Number)1);
        }
        if (this.getDuplicateCheckInterval() != null) {
            messageJson.addProperty("duplicate_check_interval", (Number)this.getDuplicateCheckInterval());
        }
        this.handleMsgType(messageJson);
        if (StringUtils.isNotBlank((CharSequence)this.getSafe())) {
            messageJson.addProperty("safe", this.getSafe());
        }
        return messageJson.toString();
    }

    private void handleMsgType(JsonObject messageJson) {
        switch (this.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "markdown": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("markdown", (JsonElement)text);
                break;
            }
            case "textcard": {
                JsonObject text = new JsonObject();
                text.addProperty("title", this.getTitle());
                text.addProperty("description", this.getDescription());
                text.addProperty("url", this.getUrl());
                text.addProperty("btntxt", this.getBtnTxt());
                messageJson.add("textcard", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("image", (JsonElement)image);
                break;
            }
            case "file": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("file", (JsonElement)image);
                break;
            }
            case "voice": {
                JsonObject voice = new JsonObject();
                voice.addProperty("media_id", this.getMediaId());
                messageJson.add("voice", (JsonElement)voice);
                break;
            }
            case "video": {
                JsonObject video = new JsonObject();
                video.addProperty("media_id", this.getMediaId());
                video.addProperty("thumb_media_id", this.getThumbMediaId());
                video.addProperty("title", this.getTitle());
                video.addProperty("description", this.getDescription());
                messageJson.add("video", (JsonElement)video);
                break;
            }
            case "news": {
                JsonObject newsJsonObject = new JsonObject();
                JsonArray articleJsonArray = new JsonArray();
                for (NewArticle article : this.getArticles()) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("title", article.getTitle());
                    jsonObject.addProperty("description", article.getDescription());
                    jsonObject.addProperty("url", article.getUrl());
                    jsonObject.addProperty("picurl", article.getPicUrl());
                    jsonObject.addProperty("appid", article.getAppid());
                    jsonObject.addProperty("pagepath", article.getPagepath());
                    articleJsonArray.add((JsonElement)jsonObject);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("news", (JsonElement)newsJsonObject);
                break;
            }
            case "mpnews": {
                JsonObject newsJsonObject = new JsonObject();
                if (this.getMediaId() != null) {
                    newsJsonObject.addProperty("media_id", this.getMediaId());
                } else {
                    JsonArray articleJsonArray = new JsonArray();
                    for (MpnewsArticle article : this.getMpnewsArticles()) {
                        this.article2Json(articleJsonArray, article);
                    }
                    newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                }
                messageJson.add("mpnews", (JsonElement)newsJsonObject);
                break;
            }
            case "taskcard": {
                JsonObject text = new JsonObject();
                text.addProperty("title", this.getTitle());
                text.addProperty("description", this.getDescription());
                if (StringUtils.isNotBlank((CharSequence)this.getUrl())) {
                    text.addProperty("url", this.getUrl());
                }
                text.addProperty("task_id", this.getTaskId());
                JsonArray buttonJsonArray = new JsonArray();
                for (TaskCardButton button : this.getTaskButtons()) {
                    this.btn2Json(buttonJsonArray, button);
                }
                text.add("btn", (JsonElement)buttonJsonArray);
                messageJson.add("taskcard", (JsonElement)text);
                break;
            }
            case "miniprogram_notice": {
                JsonObject notice = new JsonObject();
                notice.addProperty("appid", this.getAppId());
                notice.addProperty("page", this.getPage());
                notice.addProperty("description", this.getDescription());
                notice.addProperty("title", this.getTitle());
                notice.addProperty("emphasis_first_item", this.getEmphasisFirstItem());
                JsonArray content = new JsonArray();
                for (Map.Entry<String, String> item : this.getContentItems().entrySet()) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("key", item.getKey());
                    jsonObject.addProperty("value", item.getValue());
                    content.add((JsonElement)jsonObject);
                }
                notice.add("content_item", (JsonElement)content);
                messageJson.add("miniprogram_notice", (JsonElement)notice);
                break;
            }
            case "template_card": {
                QuoteArea quoteArea;
                List<MultipleSelect> list;
                JsonObject tempObject;
                List<TemplateCardButton> list2;
                List<TemplateCardJump> jumps;
                List<HorizontalContent> horizontalContents;
                List<VerticalContent> verticalContents;
                JsonObject template = new JsonObject();
                template.addProperty("card_type", this.getCardType());
                if (StringUtils.isNotBlank((CharSequence)this.getSourceIconUrl()) || StringUtils.isNotBlank((CharSequence)this.getSourceDesc())) {
                    JsonObject source = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getSourceIconUrl())) {
                        source.addProperty("icon_url", this.getSourceIconUrl());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getSourceDesc())) {
                        source.addProperty("desc", this.getSourceDesc());
                    }
                    template.add("source", (JsonElement)source);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getMainTitleTitle()) || StringUtils.isNotBlank((CharSequence)this.getMainTitleDesc())) {
                    JsonObject mainTitle = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getMainTitleTitle())) {
                        mainTitle.addProperty("title", this.getMainTitleTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getMainTitleDesc())) {
                        mainTitle.addProperty("desc", this.getMainTitleDesc());
                    }
                    template.add("main_title", (JsonElement)mainTitle);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getCardImageUrl()) || this.getCardImageAspectRatio() != null) {
                    JsonObject cardImage = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getCardImageUrl())) {
                        cardImage.addProperty("url", this.getCardImageUrl());
                    }
                    if (null != this.getCardImageAspectRatio()) {
                        cardImage.addProperty("aspect_ratio", (Number)this.getCardImageAspectRatio());
                    }
                    template.add("card_image", (JsonElement)cardImage);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getEmphasisContentTitle()) || StringUtils.isNotBlank((CharSequence)this.getEmphasisContentDesc())) {
                    JsonObject emphasisContent = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getEmphasisContentTitle())) {
                        emphasisContent.addProperty("title", this.getEmphasisContentTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getEmphasisContentDesc())) {
                        emphasisContent.addProperty("desc", this.getEmphasisContentDesc());
                    }
                    template.add("emphasis_content", (JsonElement)emphasisContent);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getSubTitleText())) {
                    template.addProperty("sub_title_text", this.getSubTitleText());
                }
                if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
                    template.addProperty("task_id", this.getTaskId());
                }
                if (null != (verticalContents = this.getVerticalContents()) && !verticalContents.isEmpty()) {
                    JsonArray vContentJsonArray = new JsonArray();
                    for (VerticalContent verticalContent : this.getVerticalContents()) {
                        JsonObject jsonObject = verticalContent.toJson();
                        vContentJsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("vertical_content_list", (JsonElement)vContentJsonArray);
                }
                if (null != (horizontalContents = this.getHorizontalContents()) && !horizontalContents.isEmpty()) {
                    JsonArray hContentJsonArray = new JsonArray();
                    for (HorizontalContent horizontalContent : this.getHorizontalContents()) {
                        JsonObject jsonObject = horizontalContent.toJson();
                        hContentJsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("horizontal_content_list", (JsonElement)hContentJsonArray);
                }
                if (null != (jumps = this.getJumps()) && !jumps.isEmpty()) {
                    JsonArray jsonArray = new JsonArray();
                    for (TemplateCardJump templateCardJump : this.getJumps()) {
                        JsonObject jsonObject = templateCardJump.toJson();
                        jsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("jump_list", (JsonElement)jsonArray);
                }
                if (null != this.getCardActionType()) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("type", (Number)this.getCardActionType());
                    if (StringUtils.isNotBlank((CharSequence)this.getCardActionUrl())) {
                        jsonObject.addProperty("url", this.getCardActionUrl());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getCardActionAppid())) {
                        jsonObject.addProperty("appid", this.getCardActionAppid());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getCardActionPagepath())) {
                        jsonObject.addProperty("pagepath", this.getCardActionPagepath());
                    }
                    template.add("card_action", (JsonElement)jsonObject);
                }
                if (null != (list2 = this.getButtons()) && !list2.isEmpty()) {
                    JsonArray jsonArray = new JsonArray();
                    for (TemplateCardButton templateCardButton : this.getButtons()) {
                        JsonObject tempObject5 = templateCardButton.toJson();
                        jsonArray.add((JsonElement)tempObject5);
                    }
                    template.add("button_list", (JsonElement)jsonArray);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getCheckboxQuestionKey())) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("question_key", this.getCheckboxQuestionKey());
                    if (null != this.getCheckboxMode()) {
                        jsonObject.addProperty("mode", (Number)this.getCheckboxMode());
                    }
                    JsonArray jsonArray = new JsonArray();
                    for (CheckboxOption option : this.getOptions()) {
                        tempObject = option.toJson();
                        jsonArray.add((JsonElement)tempObject);
                    }
                    jsonObject.add("option_list", (JsonElement)jsonArray);
                    template.add("checkbox", (JsonElement)jsonObject);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getSubmitButtonText()) || StringUtils.isNotBlank((CharSequence)this.getSubmitButtonKey())) {
                    JsonObject jsonObject = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getSubmitButtonText())) {
                        jsonObject.addProperty("text", this.getSubmitButtonText());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getSubmitButtonKey())) {
                        jsonObject.addProperty("key", this.getSubmitButtonKey());
                    }
                    template.add("submit_button", (JsonElement)jsonObject);
                }
                if (null != (list = this.getSelects()) && !list.isEmpty()) {
                    JsonArray jsonArray = new JsonArray();
                    for (MultipleSelect select : this.getSelects()) {
                        tempObject = select.toJson();
                        jsonArray.add((JsonElement)tempObject);
                    }
                    template.add("select_list", (JsonElement)jsonArray);
                }
                if (null != (quoteArea = this.getQuoteArea())) {
                    JsonObject jsonObject = quoteArea.toJson();
                    template.add("quote_area", (JsonElement)jsonObject);
                }
                messageJson.add("template_card", (JsonElement)template);
                break;
            }
        }
    }

    private void btn2Json(JsonArray buttonJsonArray, TaskCardButton button) {
        JsonObject buttonJson = new JsonObject();
        buttonJson.addProperty("key", button.getKey());
        buttonJson.addProperty("name", button.getName());
        if (StringUtils.isNotBlank((CharSequence)button.getReplaceName())) {
            buttonJson.addProperty("replace_name", button.getReplaceName());
        }
        if (StringUtils.isNotBlank((CharSequence)button.getColor())) {
            buttonJson.addProperty("color", button.getColor());
        }
        if (button.getBold() != null) {
            buttonJson.addProperty("is_bold", button.getBold());
        }
        buttonJsonArray.add((JsonElement)buttonJson);
    }

    private void article2Json(JsonArray articleJsonArray, MpnewsArticle article) {
        JsonObject articleJson = new JsonObject();
        articleJson.addProperty("title", article.getTitle());
        articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
        articleJson.addProperty("author", article.getAuthor());
        articleJson.addProperty("content_source_url", article.getContentSourceUrl());
        articleJson.addProperty("content", article.getContent());
        articleJson.addProperty("digest", article.getDigest());
        articleJson.addProperty("show_cover_pic", article.getShowCoverPic());
        articleJsonArray.add((JsonElement)articleJson);
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getToParty() {
        return this.toParty;
    }

    public String getToTag() {
        return this.toTag;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMusicUrl() {
        return this.musicUrl;
    }

    public String getHqMusicUrl() {
        return this.hqMusicUrl;
    }

    public String getSafe() {
        return this.safe;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBtnTxt() {
        return this.btnTxt;
    }

    public List<NewArticle> getArticles() {
        return this.articles;
    }

    public List<MpnewsArticle> getMpnewsArticles() {
        return this.mpnewsArticles;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getEmphasisFirstItem() {
        return this.emphasisFirstItem;
    }

    public Map<String, String> getContentItems() {
        return this.contentItems;
    }

    public Boolean getEnableIdTrans() {
        return this.enableIdTrans;
    }

    public Boolean getEnableDuplicateCheck() {
        return this.enableDuplicateCheck;
    }

    public Integer getDuplicateCheckInterval() {
        return this.duplicateCheckInterval;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public List<TaskCardButton> getTaskButtons() {
        return this.taskButtons;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getSourceIconUrl() {
        return this.sourceIconUrl;
    }

    public String getSourceDesc() {
        return this.sourceDesc;
    }

    public String getMainTitleTitle() {
        return this.mainTitleTitle;
    }

    public String getMainTitleDesc() {
        return this.mainTitleDesc;
    }

    public String getCardImageUrl() {
        return this.cardImageUrl;
    }

    public Float getCardImageAspectRatio() {
        return this.cardImageAspectRatio;
    }

    public String getEmphasisContentTitle() {
        return this.emphasisContentTitle;
    }

    public String getEmphasisContentDesc() {
        return this.emphasisContentDesc;
    }

    public String getSubTitleText() {
        return this.subTitleText;
    }

    public List<VerticalContent> getVerticalContents() {
        return this.verticalContents;
    }

    public List<HorizontalContent> getHorizontalContents() {
        return this.horizontalContents;
    }

    public List<TemplateCardJump> getJumps() {
        return this.jumps;
    }

    public Integer getCardActionType() {
        return this.cardActionType;
    }

    public String getCardActionUrl() {
        return this.cardActionUrl;
    }

    public String getCardActionAppid() {
        return this.cardActionAppid;
    }

    public String getCardActionPagepath() {
        return this.cardActionPagepath;
    }

    public List<TemplateCardButton> getButtons() {
        return this.buttons;
    }

    public String getCheckboxQuestionKey() {
        return this.checkboxQuestionKey;
    }

    public Integer getCheckboxMode() {
        return this.checkboxMode;
    }

    public List<CheckboxOption> getOptions() {
        return this.options;
    }

    public String getSubmitButtonText() {
        return this.submitButtonText;
    }

    public String getSubmitButtonKey() {
        return this.submitButtonKey;
    }

    public List<MultipleSelect> getSelects() {
        return this.selects;
    }

    public QuoteArea getQuoteArea() {
        return this.quoteArea;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public void setToParty(String toParty) {
        this.toParty = toParty;
    }

    public void setToTag(String toTag) {
        this.toTag = toTag;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMusicUrl(String musicUrl) {
        this.musicUrl = musicUrl;
    }

    public void setHqMusicUrl(String hqMusicUrl) {
        this.hqMusicUrl = hqMusicUrl;
    }

    public void setSafe(String safe) {
        this.safe = safe;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBtnTxt(String btnTxt) {
        this.btnTxt = btnTxt;
    }

    public void setArticles(List<NewArticle> articles) {
        this.articles = articles;
    }

    public void setMpnewsArticles(List<MpnewsArticle> mpnewsArticles) {
        this.mpnewsArticles = mpnewsArticles;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setEmphasisFirstItem(Boolean emphasisFirstItem) {
        this.emphasisFirstItem = emphasisFirstItem;
    }

    public void setContentItems(Map<String, String> contentItems) {
        this.contentItems = contentItems;
    }

    public void setEnableIdTrans(Boolean enableIdTrans) {
        this.enableIdTrans = enableIdTrans;
    }

    public void setEnableDuplicateCheck(Boolean enableDuplicateCheck) {
        this.enableDuplicateCheck = enableDuplicateCheck;
    }

    public void setDuplicateCheckInterval(Integer duplicateCheckInterval) {
        this.duplicateCheckInterval = duplicateCheckInterval;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskButtons(List<TaskCardButton> taskButtons) {
        this.taskButtons = taskButtons;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public void setSourceIconUrl(String sourceIconUrl) {
        this.sourceIconUrl = sourceIconUrl;
    }

    public void setSourceDesc(String sourceDesc) {
        this.sourceDesc = sourceDesc;
    }

    public void setMainTitleTitle(String mainTitleTitle) {
        this.mainTitleTitle = mainTitleTitle;
    }

    public void setMainTitleDesc(String mainTitleDesc) {
        this.mainTitleDesc = mainTitleDesc;
    }

    public void setCardImageUrl(String cardImageUrl) {
        this.cardImageUrl = cardImageUrl;
    }

    public void setCardImageAspectRatio(Float cardImageAspectRatio) {
        this.cardImageAspectRatio = cardImageAspectRatio;
    }

    public void setEmphasisContentTitle(String emphasisContentTitle) {
        this.emphasisContentTitle = emphasisContentTitle;
    }

    public void setEmphasisContentDesc(String emphasisContentDesc) {
        this.emphasisContentDesc = emphasisContentDesc;
    }

    public void setSubTitleText(String subTitleText) {
        this.subTitleText = subTitleText;
    }

    public void setVerticalContents(List<VerticalContent> verticalContents) {
        this.verticalContents = verticalContents;
    }

    public void setHorizontalContents(List<HorizontalContent> horizontalContents) {
        this.horizontalContents = horizontalContents;
    }

    public void setJumps(List<TemplateCardJump> jumps) {
        this.jumps = jumps;
    }

    public void setCardActionType(Integer cardActionType) {
        this.cardActionType = cardActionType;
    }

    public void setCardActionUrl(String cardActionUrl) {
        this.cardActionUrl = cardActionUrl;
    }

    public void setCardActionAppid(String cardActionAppid) {
        this.cardActionAppid = cardActionAppid;
    }

    public void setCardActionPagepath(String cardActionPagepath) {
        this.cardActionPagepath = cardActionPagepath;
    }

    public void setButtons(List<TemplateCardButton> buttons) {
        this.buttons = buttons;
    }

    public void setCheckboxQuestionKey(String checkboxQuestionKey) {
        this.checkboxQuestionKey = checkboxQuestionKey;
    }

    public void setCheckboxMode(Integer checkboxMode) {
        this.checkboxMode = checkboxMode;
    }

    public void setOptions(List<CheckboxOption> options) {
        this.options = options;
    }

    public void setSubmitButtonText(String submitButtonText) {
        this.submitButtonText = submitButtonText;
    }

    public void setSubmitButtonKey(String submitButtonKey) {
        this.submitButtonKey = submitButtonKey;
    }

    public void setSelects(List<MultipleSelect> selects) {
        this.selects = selects;
    }

    public void setQuoteArea(QuoteArea quoteArea) {
        this.quoteArea = quoteArea;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpMessage)) {
            return false;
        }
        WxCpMessage other = (WxCpMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$toUser = this.getToUser();
        String other$toUser = other.getToUser();
        if (this$toUser == null ? other$toUser != null : !this$toUser.equals(other$toUser)) {
            return false;
        }
        String this$toParty = this.getToParty();
        String other$toParty = other.getToParty();
        if (this$toParty == null ? other$toParty != null : !this$toParty.equals(other$toParty)) {
            return false;
        }
        String this$toTag = this.getToTag();
        String other$toTag = other.getToTag();
        if (this$toTag == null ? other$toTag != null : !this$toTag.equals(other$toTag)) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$thumbMediaId = this.getThumbMediaId();
        String other$thumbMediaId = other.getThumbMediaId();
        if (this$thumbMediaId == null ? other$thumbMediaId != null : !this$thumbMediaId.equals(other$thumbMediaId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$musicUrl = this.getMusicUrl();
        String other$musicUrl = other.getMusicUrl();
        if (this$musicUrl == null ? other$musicUrl != null : !this$musicUrl.equals(other$musicUrl)) {
            return false;
        }
        String this$hqMusicUrl = this.getHqMusicUrl();
        String other$hqMusicUrl = other.getHqMusicUrl();
        if (this$hqMusicUrl == null ? other$hqMusicUrl != null : !this$hqMusicUrl.equals(other$hqMusicUrl)) {
            return false;
        }
        String this$safe = this.getSafe();
        String other$safe = other.getSafe();
        if (this$safe == null ? other$safe != null : !this$safe.equals(other$safe)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$btnTxt = this.getBtnTxt();
        String other$btnTxt = other.getBtnTxt();
        if (this$btnTxt == null ? other$btnTxt != null : !this$btnTxt.equals(other$btnTxt)) {
            return false;
        }
        List<NewArticle> this$articles = this.getArticles();
        List<NewArticle> other$articles = other.getArticles();
        if (this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles)) {
            return false;
        }
        List<MpnewsArticle> this$mpnewsArticles = this.getMpnewsArticles();
        List<MpnewsArticle> other$mpnewsArticles = other.getMpnewsArticles();
        if (this$mpnewsArticles == null ? other$mpnewsArticles != null : !((Object)this$mpnewsArticles).equals(other$mpnewsArticles)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        Boolean this$emphasisFirstItem = this.getEmphasisFirstItem();
        Boolean other$emphasisFirstItem = other.getEmphasisFirstItem();
        if (this$emphasisFirstItem == null ? other$emphasisFirstItem != null : !((Object)this$emphasisFirstItem).equals(other$emphasisFirstItem)) {
            return false;
        }
        Map<String, String> this$contentItems = this.getContentItems();
        Map<String, String> other$contentItems = other.getContentItems();
        if (this$contentItems == null ? other$contentItems != null : !((Object)this$contentItems).equals(other$contentItems)) {
            return false;
        }
        Boolean this$enableIdTrans = this.getEnableIdTrans();
        Boolean other$enableIdTrans = other.getEnableIdTrans();
        if (this$enableIdTrans == null ? other$enableIdTrans != null : !((Object)this$enableIdTrans).equals(other$enableIdTrans)) {
            return false;
        }
        Boolean this$enableDuplicateCheck = this.getEnableDuplicateCheck();
        Boolean other$enableDuplicateCheck = other.getEnableDuplicateCheck();
        if (this$enableDuplicateCheck == null ? other$enableDuplicateCheck != null : !((Object)this$enableDuplicateCheck).equals(other$enableDuplicateCheck)) {
            return false;
        }
        Integer this$duplicateCheckInterval = this.getDuplicateCheckInterval();
        Integer other$duplicateCheckInterval = other.getDuplicateCheckInterval();
        if (this$duplicateCheckInterval == null ? other$duplicateCheckInterval != null : !((Object)this$duplicateCheckInterval).equals(other$duplicateCheckInterval)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        List<TaskCardButton> this$taskButtons = this.getTaskButtons();
        List<TaskCardButton> other$taskButtons = other.getTaskButtons();
        if (this$taskButtons == null ? other$taskButtons != null : !((Object)this$taskButtons).equals(other$taskButtons)) {
            return false;
        }
        String this$cardType = this.getCardType();
        String other$cardType = other.getCardType();
        if (this$cardType == null ? other$cardType != null : !this$cardType.equals(other$cardType)) {
            return false;
        }
        String this$sourceIconUrl = this.getSourceIconUrl();
        String other$sourceIconUrl = other.getSourceIconUrl();
        if (this$sourceIconUrl == null ? other$sourceIconUrl != null : !this$sourceIconUrl.equals(other$sourceIconUrl)) {
            return false;
        }
        String this$sourceDesc = this.getSourceDesc();
        String other$sourceDesc = other.getSourceDesc();
        if (this$sourceDesc == null ? other$sourceDesc != null : !this$sourceDesc.equals(other$sourceDesc)) {
            return false;
        }
        String this$mainTitleTitle = this.getMainTitleTitle();
        String other$mainTitleTitle = other.getMainTitleTitle();
        if (this$mainTitleTitle == null ? other$mainTitleTitle != null : !this$mainTitleTitle.equals(other$mainTitleTitle)) {
            return false;
        }
        String this$mainTitleDesc = this.getMainTitleDesc();
        String other$mainTitleDesc = other.getMainTitleDesc();
        if (this$mainTitleDesc == null ? other$mainTitleDesc != null : !this$mainTitleDesc.equals(other$mainTitleDesc)) {
            return false;
        }
        String this$cardImageUrl = this.getCardImageUrl();
        String other$cardImageUrl = other.getCardImageUrl();
        if (this$cardImageUrl == null ? other$cardImageUrl != null : !this$cardImageUrl.equals(other$cardImageUrl)) {
            return false;
        }
        Float this$cardImageAspectRatio = this.getCardImageAspectRatio();
        Float other$cardImageAspectRatio = other.getCardImageAspectRatio();
        if (this$cardImageAspectRatio == null ? other$cardImageAspectRatio != null : !((Object)this$cardImageAspectRatio).equals(other$cardImageAspectRatio)) {
            return false;
        }
        String this$emphasisContentTitle = this.getEmphasisContentTitle();
        String other$emphasisContentTitle = other.getEmphasisContentTitle();
        if (this$emphasisContentTitle == null ? other$emphasisContentTitle != null : !this$emphasisContentTitle.equals(other$emphasisContentTitle)) {
            return false;
        }
        String this$emphasisContentDesc = this.getEmphasisContentDesc();
        String other$emphasisContentDesc = other.getEmphasisContentDesc();
        if (this$emphasisContentDesc == null ? other$emphasisContentDesc != null : !this$emphasisContentDesc.equals(other$emphasisContentDesc)) {
            return false;
        }
        String this$subTitleText = this.getSubTitleText();
        String other$subTitleText = other.getSubTitleText();
        if (this$subTitleText == null ? other$subTitleText != null : !this$subTitleText.equals(other$subTitleText)) {
            return false;
        }
        List<VerticalContent> this$verticalContents = this.getVerticalContents();
        List<VerticalContent> other$verticalContents = other.getVerticalContents();
        if (this$verticalContents == null ? other$verticalContents != null : !((Object)this$verticalContents).equals(other$verticalContents)) {
            return false;
        }
        List<HorizontalContent> this$horizontalContents = this.getHorizontalContents();
        List<HorizontalContent> other$horizontalContents = other.getHorizontalContents();
        if (this$horizontalContents == null ? other$horizontalContents != null : !((Object)this$horizontalContents).equals(other$horizontalContents)) {
            return false;
        }
        List<TemplateCardJump> this$jumps = this.getJumps();
        List<TemplateCardJump> other$jumps = other.getJumps();
        if (this$jumps == null ? other$jumps != null : !((Object)this$jumps).equals(other$jumps)) {
            return false;
        }
        Integer this$cardActionType = this.getCardActionType();
        Integer other$cardActionType = other.getCardActionType();
        if (this$cardActionType == null ? other$cardActionType != null : !((Object)this$cardActionType).equals(other$cardActionType)) {
            return false;
        }
        String this$cardActionUrl = this.getCardActionUrl();
        String other$cardActionUrl = other.getCardActionUrl();
        if (this$cardActionUrl == null ? other$cardActionUrl != null : !this$cardActionUrl.equals(other$cardActionUrl)) {
            return false;
        }
        String this$cardActionAppid = this.getCardActionAppid();
        String other$cardActionAppid = other.getCardActionAppid();
        if (this$cardActionAppid == null ? other$cardActionAppid != null : !this$cardActionAppid.equals(other$cardActionAppid)) {
            return false;
        }
        String this$cardActionPagepath = this.getCardActionPagepath();
        String other$cardActionPagepath = other.getCardActionPagepath();
        if (this$cardActionPagepath == null ? other$cardActionPagepath != null : !this$cardActionPagepath.equals(other$cardActionPagepath)) {
            return false;
        }
        List<TemplateCardButton> this$buttons = this.getButtons();
        List<TemplateCardButton> other$buttons = other.getButtons();
        if (this$buttons == null ? other$buttons != null : !((Object)this$buttons).equals(other$buttons)) {
            return false;
        }
        String this$checkboxQuestionKey = this.getCheckboxQuestionKey();
        String other$checkboxQuestionKey = other.getCheckboxQuestionKey();
        if (this$checkboxQuestionKey == null ? other$checkboxQuestionKey != null : !this$checkboxQuestionKey.equals(other$checkboxQuestionKey)) {
            return false;
        }
        Integer this$checkboxMode = this.getCheckboxMode();
        Integer other$checkboxMode = other.getCheckboxMode();
        if (this$checkboxMode == null ? other$checkboxMode != null : !((Object)this$checkboxMode).equals(other$checkboxMode)) {
            return false;
        }
        List<CheckboxOption> this$options = this.getOptions();
        List<CheckboxOption> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$submitButtonText = this.getSubmitButtonText();
        String other$submitButtonText = other.getSubmitButtonText();
        if (this$submitButtonText == null ? other$submitButtonText != null : !this$submitButtonText.equals(other$submitButtonText)) {
            return false;
        }
        String this$submitButtonKey = this.getSubmitButtonKey();
        String other$submitButtonKey = other.getSubmitButtonKey();
        if (this$submitButtonKey == null ? other$submitButtonKey != null : !this$submitButtonKey.equals(other$submitButtonKey)) {
            return false;
        }
        List<MultipleSelect> this$selects = this.getSelects();
        List<MultipleSelect> other$selects = other.getSelects();
        if (this$selects == null ? other$selects != null : !((Object)this$selects).equals(other$selects)) {
            return false;
        }
        QuoteArea this$quoteArea = this.getQuoteArea();
        QuoteArea other$quoteArea = other.getQuoteArea();
        return !(this$quoteArea == null ? other$quoteArea != null : !((Object)this$quoteArea).equals(other$quoteArea));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $toUser = this.getToUser();
        result = result * 59 + ($toUser == null ? 43 : $toUser.hashCode());
        String $toParty = this.getToParty();
        result = result * 59 + ($toParty == null ? 43 : $toParty.hashCode());
        String $toTag = this.getToTag();
        result = result * 59 + ($toTag == null ? 43 : $toTag.hashCode());
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $thumbMediaId = this.getThumbMediaId();
        result = result * 59 + ($thumbMediaId == null ? 43 : $thumbMediaId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $musicUrl = this.getMusicUrl();
        result = result * 59 + ($musicUrl == null ? 43 : $musicUrl.hashCode());
        String $hqMusicUrl = this.getHqMusicUrl();
        result = result * 59 + ($hqMusicUrl == null ? 43 : $hqMusicUrl.hashCode());
        String $safe = this.getSafe();
        result = result * 59 + ($safe == null ? 43 : $safe.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $btnTxt = this.getBtnTxt();
        result = result * 59 + ($btnTxt == null ? 43 : $btnTxt.hashCode());
        List<NewArticle> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        List<MpnewsArticle> $mpnewsArticles = this.getMpnewsArticles();
        result = result * 59 + ($mpnewsArticles == null ? 43 : ((Object)$mpnewsArticles).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        Boolean $emphasisFirstItem = this.getEmphasisFirstItem();
        result = result * 59 + ($emphasisFirstItem == null ? 43 : ((Object)$emphasisFirstItem).hashCode());
        Map<String, String> $contentItems = this.getContentItems();
        result = result * 59 + ($contentItems == null ? 43 : ((Object)$contentItems).hashCode());
        Boolean $enableIdTrans = this.getEnableIdTrans();
        result = result * 59 + ($enableIdTrans == null ? 43 : ((Object)$enableIdTrans).hashCode());
        Boolean $enableDuplicateCheck = this.getEnableDuplicateCheck();
        result = result * 59 + ($enableDuplicateCheck == null ? 43 : ((Object)$enableDuplicateCheck).hashCode());
        Integer $duplicateCheckInterval = this.getDuplicateCheckInterval();
        result = result * 59 + ($duplicateCheckInterval == null ? 43 : ((Object)$duplicateCheckInterval).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        List<TaskCardButton> $taskButtons = this.getTaskButtons();
        result = result * 59 + ($taskButtons == null ? 43 : ((Object)$taskButtons).hashCode());
        String $cardType = this.getCardType();
        result = result * 59 + ($cardType == null ? 43 : $cardType.hashCode());
        String $sourceIconUrl = this.getSourceIconUrl();
        result = result * 59 + ($sourceIconUrl == null ? 43 : $sourceIconUrl.hashCode());
        String $sourceDesc = this.getSourceDesc();
        result = result * 59 + ($sourceDesc == null ? 43 : $sourceDesc.hashCode());
        String $mainTitleTitle = this.getMainTitleTitle();
        result = result * 59 + ($mainTitleTitle == null ? 43 : $mainTitleTitle.hashCode());
        String $mainTitleDesc = this.getMainTitleDesc();
        result = result * 59 + ($mainTitleDesc == null ? 43 : $mainTitleDesc.hashCode());
        String $cardImageUrl = this.getCardImageUrl();
        result = result * 59 + ($cardImageUrl == null ? 43 : $cardImageUrl.hashCode());
        Float $cardImageAspectRatio = this.getCardImageAspectRatio();
        result = result * 59 + ($cardImageAspectRatio == null ? 43 : ((Object)$cardImageAspectRatio).hashCode());
        String $emphasisContentTitle = this.getEmphasisContentTitle();
        result = result * 59 + ($emphasisContentTitle == null ? 43 : $emphasisContentTitle.hashCode());
        String $emphasisContentDesc = this.getEmphasisContentDesc();
        result = result * 59 + ($emphasisContentDesc == null ? 43 : $emphasisContentDesc.hashCode());
        String $subTitleText = this.getSubTitleText();
        result = result * 59 + ($subTitleText == null ? 43 : $subTitleText.hashCode());
        List<VerticalContent> $verticalContents = this.getVerticalContents();
        result = result * 59 + ($verticalContents == null ? 43 : ((Object)$verticalContents).hashCode());
        List<HorizontalContent> $horizontalContents = this.getHorizontalContents();
        result = result * 59 + ($horizontalContents == null ? 43 : ((Object)$horizontalContents).hashCode());
        List<TemplateCardJump> $jumps = this.getJumps();
        result = result * 59 + ($jumps == null ? 43 : ((Object)$jumps).hashCode());
        Integer $cardActionType = this.getCardActionType();
        result = result * 59 + ($cardActionType == null ? 43 : ((Object)$cardActionType).hashCode());
        String $cardActionUrl = this.getCardActionUrl();
        result = result * 59 + ($cardActionUrl == null ? 43 : $cardActionUrl.hashCode());
        String $cardActionAppid = this.getCardActionAppid();
        result = result * 59 + ($cardActionAppid == null ? 43 : $cardActionAppid.hashCode());
        String $cardActionPagepath = this.getCardActionPagepath();
        result = result * 59 + ($cardActionPagepath == null ? 43 : $cardActionPagepath.hashCode());
        List<TemplateCardButton> $buttons = this.getButtons();
        result = result * 59 + ($buttons == null ? 43 : ((Object)$buttons).hashCode());
        String $checkboxQuestionKey = this.getCheckboxQuestionKey();
        result = result * 59 + ($checkboxQuestionKey == null ? 43 : $checkboxQuestionKey.hashCode());
        Integer $checkboxMode = this.getCheckboxMode();
        result = result * 59 + ($checkboxMode == null ? 43 : ((Object)$checkboxMode).hashCode());
        List<CheckboxOption> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $submitButtonText = this.getSubmitButtonText();
        result = result * 59 + ($submitButtonText == null ? 43 : $submitButtonText.hashCode());
        String $submitButtonKey = this.getSubmitButtonKey();
        result = result * 59 + ($submitButtonKey == null ? 43 : $submitButtonKey.hashCode());
        List<MultipleSelect> $selects = this.getSelects();
        result = result * 59 + ($selects == null ? 43 : ((Object)$selects).hashCode());
        QuoteArea $quoteArea = this.getQuoteArea();
        result = result * 59 + ($quoteArea == null ? 43 : ((Object)$quoteArea).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpMessage(toUser=" + this.getToUser() + ", toParty=" + this.getToParty() + ", toTag=" + this.getToTag() + ", agentId=" + this.getAgentId() + ", msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", mediaId=" + this.getMediaId() + ", thumbMediaId=" + this.getThumbMediaId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", musicUrl=" + this.getMusicUrl() + ", hqMusicUrl=" + this.getHqMusicUrl() + ", safe=" + this.getSafe() + ", url=" + this.getUrl() + ", btnTxt=" + this.getBtnTxt() + ", articles=" + this.getArticles() + ", mpnewsArticles=" + this.getMpnewsArticles() + ", appId=" + this.getAppId() + ", page=" + this.getPage() + ", emphasisFirstItem=" + this.getEmphasisFirstItem() + ", contentItems=" + this.getContentItems() + ", enableIdTrans=" + this.getEnableIdTrans() + ", enableDuplicateCheck=" + this.getEnableDuplicateCheck() + ", duplicateCheckInterval=" + this.getDuplicateCheckInterval() + ", taskId=" + this.getTaskId() + ", taskButtons=" + this.getTaskButtons() + ", cardType=" + this.getCardType() + ", sourceIconUrl=" + this.getSourceIconUrl() + ", sourceDesc=" + this.getSourceDesc() + ", mainTitleTitle=" + this.getMainTitleTitle() + ", mainTitleDesc=" + this.getMainTitleDesc() + ", cardImageUrl=" + this.getCardImageUrl() + ", cardImageAspectRatio=" + this.getCardImageAspectRatio() + ", emphasisContentTitle=" + this.getEmphasisContentTitle() + ", emphasisContentDesc=" + this.getEmphasisContentDesc() + ", subTitleText=" + this.getSubTitleText() + ", verticalContents=" + this.getVerticalContents() + ", horizontalContents=" + this.getHorizontalContents() + ", jumps=" + this.getJumps() + ", cardActionType=" + this.getCardActionType() + ", cardActionUrl=" + this.getCardActionUrl() + ", cardActionAppid=" + this.getCardActionAppid() + ", cardActionPagepath=" + this.getCardActionPagepath() + ", buttons=" + this.getButtons() + ", checkboxQuestionKey=" + this.getCheckboxQuestionKey() + ", checkboxMode=" + this.getCheckboxMode() + ", options=" + this.getOptions() + ", submitButtonText=" + this.getSubmitButtonText() + ", submitButtonKey=" + this.getSubmitButtonKey() + ", selects=" + this.getSelects() + ", quoteArea=" + this.getQuoteArea() + ")";
    }
}

