/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxCpErrorMsgEnum;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.BeanUtils;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpExternalContactService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.external.WxCpAddMomentResult;
import me.chanjar.weixin.cp.bean.external.WxCpAddMomentTask;
import me.chanjar.weixin.cp.bean.external.WxCpContactWayInfo;
import me.chanjar.weixin.cp.bean.external.WxCpContactWayResult;
import me.chanjar.weixin.cp.bean.external.WxCpExternalUserIdList;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentComments;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentCustomerList;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentList;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentSendResult;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentTask;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentTaskResult;
import me.chanjar.weixin.cp.bean.external.WxCpGroupJoinWayInfo;
import me.chanjar.weixin.cp.bean.external.WxCpGroupJoinWayResult;
import me.chanjar.weixin.cp.bean.external.WxCpGroupWelcomeTemplateResult;
import me.chanjar.weixin.cp.bean.external.WxCpInterceptRuleResp;
import me.chanjar.weixin.cp.bean.external.WxCpInterceptRuleResultResp;
import me.chanjar.weixin.cp.bean.external.WxCpMsgTemplate;
import me.chanjar.weixin.cp.bean.external.WxCpMsgTemplateAddResult;
import me.chanjar.weixin.cp.bean.external.WxCpNewExternalUserIdList;
import me.chanjar.weixin.cp.bean.external.WxCpProductAlbumInfo;
import me.chanjar.weixin.cp.bean.external.WxCpProductAlbumListResult;
import me.chanjar.weixin.cp.bean.external.WxCpProductAlbumResult;
import me.chanjar.weixin.cp.bean.external.WxCpUpdateRemarkRequest;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalContactList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatInfo;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatStatistic;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatTransferResp;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalTagGroupInfo;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalTagGroupList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalUnassignList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalUserBehaviorStatistic;
import me.chanjar.weixin.cp.bean.external.WxCpUserTransferCustomerReq;
import me.chanjar.weixin.cp.bean.external.WxCpUserTransferCustomerResp;
import me.chanjar.weixin.cp.bean.external.WxCpUserTransferResultResp;
import me.chanjar.weixin.cp.bean.external.WxCpUserWithExternalPermission;
import me.chanjar.weixin.cp.bean.external.WxCpWelcomeMsg;
import me.chanjar.weixin.cp.bean.external.contact.WxCpExternalContactBatchInfo;
import me.chanjar.weixin.cp.bean.external.contact.WxCpExternalContactInfo;
import me.chanjar.weixin.cp.bean.external.contact.WxCpGroupMsgListResult;
import me.chanjar.weixin.cp.bean.external.contact.WxCpGroupMsgResult;
import me.chanjar.weixin.cp.bean.external.contact.WxCpGroupMsgSendResult;
import me.chanjar.weixin.cp.bean.external.contact.WxCpGroupMsgTaskResult;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WxCpExternalContactServiceImpl
implements WxCpExternalContactService {
    private final WxCpService mainService;

    @Override
    public WxCpContactWayResult addContactWay(@NonNull WxCpContactWayInfo info) throws WxErrorException {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (info.getContactWay().getUsers() != null && info.getContactWay().getUsers().size() > 100) {
            throw new WxRuntimeException("\u300c\u8054\u7cfb\u6211\u300d\u4f7f\u7528\u4eba\u6570\u9ed8\u8ba4\u9650\u5236\u4e0d\u8d85\u8fc7100\u4eba(\u5305\u62ec\u90e8\u95e8\u5c55\u5f00\u540e\u7684\u4eba\u6570)");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_contact_way");
        String responseContent = this.mainService.post(url, info.getContactWay().toJson());
        return WxCpContactWayResult.fromJson(responseContent);
    }

    @Override
    public WxCpContactWayInfo getContactWay(@NonNull String configId) throws WxErrorException {
        if (configId == null) {
            throw new NullPointerException("configId is marked non-null but is null");
        }
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_contact_way");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpContactWayInfo.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updateContactWay(@NonNull WxCpContactWayInfo info) throws WxErrorException {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)info.getContactWay().getConfigId())) {
            throw new WxRuntimeException("\u66f4\u65b0\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u9700\u8981\u6307\u5b9aconfigId");
        }
        if (info.getContactWay().getUsers() != null && info.getContactWay().getUsers().size() > 100) {
            throw new WxRuntimeException("\u300c\u8054\u7cfb\u6211\u300d\u4f7f\u7528\u4eba\u6570\u9ed8\u8ba4\u9650\u5236\u4e0d\u8d85\u8fc7100\u4eba(\u5305\u62ec\u90e8\u95e8\u5c55\u5f00\u540e\u7684\u4eba\u6570)");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/update_contact_way");
        String responseContent = this.mainService.post(url, info.getContactWay().toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp deleteContactWay(@NonNull String configId) throws WxErrorException {
        if (configId == null) {
            throw new NullPointerException("configId is marked non-null but is null");
        }
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/del_contact_way");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp closeTempChat(@NonNull String userId, @NonNull String externalUserId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (externalUserId == null) {
            throw new NullPointerException("externalUserId is marked non-null but is null");
        }
        JsonObject json = new JsonObject();
        json.addProperty("userid", userId);
        json.addProperty("external_userid", externalUserId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/close_temp_chat");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpExternalContactInfo getExternalContact(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/crm/get_external_contact?external_userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public WxCpExternalContactInfo getContactDetail(String userId, String cursor) throws WxErrorException {
        String params = userId;
        if (StringUtils.isNotEmpty((CharSequence)cursor)) {
            params = params + "&cursor=" + cursor;
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get?external_userid=" + params);
        String responseContent = this.mainService.get(url, null);
        return WxCpExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public String convertToOpenid(@NotNull String externalUserId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/convert_to_openid");
        String responseContent = this.mainService.post(url, json.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("openid").getAsString();
    }

    @Override
    public String unionidToExternalUserid(@NotNull String unionid, String openid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("unionid", unionid);
        if (StringUtils.isNotEmpty((CharSequence)openid)) {
            json.addProperty("openid", openid);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/unionid_to_external_userid");
        String responseContent = this.mainService.post(url, json.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("external_userid").getAsString();
    }

    @Override
    public String toServiceExternalUserid(@NotNull String externalUserid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/to_service_external_userid");
        String responseContent = this.mainService.post(url, json.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("external_userid").getAsString();
    }

    @Override
    public WxCpExternalUserIdList unionidToExternalUserid3rd(@NotNull String unionid, @NotNull String openid, String corpid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("unionid", unionid);
        json.addProperty("openid", openid);
        if (StringUtils.isNotEmpty((CharSequence)corpid)) {
            json.addProperty("corpid", corpid);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/service/externalcontact/unionid_to_external_userid_3rd");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpExternalUserIdList.fromJson(responseContent);
    }

    @Override
    public WxCpNewExternalUserIdList getNewExternalUserId(String[] externalUserIdList) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])externalUserIdList)) {
            json.add("external_userid_list", (JsonElement)new Gson().toJsonTree((Object)externalUserIdList).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/service/externalcontact/get_new_external_userid");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpNewExternalUserIdList.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp finishExternalUserIdMigration(@NotNull String corpid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("corpid", corpid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/finish_external_userid_migration");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public String opengidToChatid(@NotNull String opengid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("opengid", opengid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/opengid_to_chatid");
        String responseContent = this.mainService.post(url, json.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("chat_id").getAsString();
    }

    @Override
    public WxCpExternalContactBatchInfo getContactDetailBatch(String[] userIdList, String cursor, Integer limit) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/batch/get_by_user?");
        JsonObject json = new JsonObject();
        json.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIdList).getAsJsonArray());
        if (StringUtils.isNotBlank((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpExternalContactBatchInfo.fromJson(responseContent);
    }

    @Override
    public void updateRemark(WxCpUpdateRemarkRequest request) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/remark");
        this.mainService.post(url, request.toJson());
    }

    @Override
    public List<String> listExternalContacts(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/list?userid=" + userId);
        try {
            String responseContent = this.mainService.get(url, null);
            return WxCpUserExternalContactList.fromJson(responseContent).getExternalUserId();
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == WxCpErrorMsgEnum.CODE_84061.getCode()) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<String> listFollowers() throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_follow_user_list");
        String responseContent = this.mainService.get(url, null);
        return WxCpUserWithExternalPermission.fromJson(responseContent).getFollowers();
    }

    @Override
    public WxCpUserExternalUnassignList listUnassignedList(Integer pageIndex, String cursor, Integer pageSize) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (pageIndex != null) {
            json.addProperty("page_id", (Number)pageIndex);
        }
        json.addProperty("cursor", StringUtils.isEmpty((CharSequence)cursor) ? "" : cursor);
        json.addProperty("page_size", (Number)(pageSize == null ? 1000 : pageSize));
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_unassigned_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalUnassignList.fromJson(result);
    }

    @Override
    public WxCpBaseResp transferExternalContact(String externalUserid, String handOverUserid, String takeOverUserid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserid);
        json.addProperty("handover_userid", handOverUserid);
        json.addProperty("takeover_userid", takeOverUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/transfer");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpUserTransferCustomerResp transferCustomer(WxCpUserTransferCustomerReq req) throws WxErrorException {
        BeanUtils.checkRequiredFields((Object)req);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/transfer_customer");
        String result = this.mainService.post(url, req.toJson());
        return WxCpUserTransferCustomerResp.fromJson(result);
    }

    @Override
    public WxCpUserTransferResultResp transferResult(@NotNull String handOverUserid, @NotNull String takeOverUserid, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("cursor", cursor);
        json.addProperty("handover_userid", handOverUserid);
        json.addProperty("takeover_userid", takeOverUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/transfer_result");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserTransferResultResp.fromJson(result);
    }

    @Override
    public WxCpUserTransferCustomerResp resignedTransferCustomer(WxCpUserTransferCustomerReq req) throws WxErrorException {
        BeanUtils.checkRequiredFields((Object)req);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/resigned/transfer_customer");
        String result = this.mainService.post(url, req.toJson());
        return WxCpUserTransferCustomerResp.fromJson(result);
    }

    @Override
    public WxCpUserTransferResultResp resignedTransferResult(@NotNull String handOverUserid, @NotNull String takeOverUserid, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("cursor", cursor);
        json.addProperty("handover_userid", handOverUserid);
        json.addProperty("takeover_userid", takeOverUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/resigned/transfer_result");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserTransferResultResp.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatList listGroupChat(Integer pageIndex, Integer pageSize, int status, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("offset", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("limit", (Number)(pageSize == null ? 100 : pageSize));
        json.addProperty("status_filter", (Number)status);
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                ownerFilter.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                ownerFilter.add("partyid_list", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatList.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatList listGroupChat(Integer limit, String cursor, int status, String[] userIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("cursor", cursor == null ? "" : cursor);
        json.addProperty("limit", (Number)(limit == null ? 100 : limit));
        json.addProperty("status_filter", (Number)status);
        if (ArrayUtils.isNotEmpty((Object[])userIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                ownerFilter.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatList.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatInfo getGroupChat(String chatId, Integer needName) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("chat_id", chatId);
        json.addProperty("need_name", (Number)needName);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/get");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatInfo.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatTransferResp transferGroupChat(String[] chatIds, String newOwner) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])chatIds)) {
            json.add("chat_id_list", (JsonElement)new Gson().toJsonTree((Object)chatIds).getAsJsonArray());
        }
        json.addProperty("new_owner", newOwner);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/transfer");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatTransferResp.fromJson(result);
    }

    @Override
    public WxCpUserExternalUserBehaviorStatistic getUserBehaviorStatistic(Date startTime, Date endTime, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("start_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("end_time", (Number)(endTime.getTime() / 1000L));
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                json.add("userid", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                json.add("partyid", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_user_behavior_data");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalUserBehaviorStatistic.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatStatistic getGroupChatStatistic(Date startTime, Integer orderBy, Integer orderAsc, Integer pageIndex, Integer pageSize, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("day_begin_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("order_by", (Number)(orderBy == null ? 1 : orderBy));
        json.addProperty("order_asc", (Number)(orderAsc == null ? 0 : orderAsc));
        json.addProperty("offset", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("limit", (Number)(pageSize == null ? 500 : pageSize));
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                ownerFilter.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                ownerFilter.add("partyid_list", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/statistic");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatStatistic.fromJson(result);
    }

    @Override
    public WxCpMsgTemplateAddResult addMsgTemplate(WxCpMsgTemplate wxCpMsgTemplate) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_msg_template");
        String result = this.mainService.post(url, wxCpMsgTemplate.toJson());
        return WxCpMsgTemplateAddResult.fromJson(result);
    }

    @Override
    public void sendWelcomeMsg(WxCpWelcomeMsg msg) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/send_welcome_msg");
        this.mainService.post(url, msg.toJson());
    }

    @Override
    public WxCpUserExternalTagGroupList getCorpTagList(String[] tagId) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])tagId)) {
            json.add("tag_id", (JsonElement)new Gson().toJsonTree((Object)tagId).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_corp_tag_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalTagGroupList.fromJson(result);
    }

    @Override
    public WxCpUserExternalTagGroupList getCorpTagList(String[] tagId, String[] groupId) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])tagId)) {
            json.add("tag_id", (JsonElement)new Gson().toJsonTree((Object)tagId).getAsJsonArray());
        }
        if (ArrayUtils.isNotEmpty((Object[])groupId)) {
            json.add("group_id", (JsonElement)new Gson().toJsonTree((Object)groupId).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_corp_tag_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalTagGroupList.fromJson(result);
    }

    @Override
    public WxCpUserExternalTagGroupInfo addCorpTag(WxCpUserExternalTagGroupInfo tagGroup) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_corp_tag");
        String result = this.mainService.post(url, tagGroup.getTagGroup().toJson());
        return WxCpUserExternalTagGroupInfo.fromJson(result);
    }

    @Override
    public WxCpBaseResp editCorpTag(String id, String name, Integer order) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json.addProperty("name", name);
        json.addProperty("order", (Number)order);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/edit_corp_tag");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpBaseResp delCorpTag(String[] tagId, String[] groupId) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])tagId)) {
            json.add("tag_id", (JsonElement)new Gson().toJsonTree((Object)tagId).getAsJsonArray());
        }
        if (ArrayUtils.isNotEmpty((Object[])groupId)) {
            json.add("group_id", (JsonElement)new Gson().toJsonTree((Object)groupId).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/del_corp_tag");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpBaseResp markTag(String userid, String externalUserid, String[] addTag, String[] removeTag) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("userid", userid);
        json.addProperty("external_userid", externalUserid);
        if (ArrayUtils.isNotEmpty((Object[])addTag)) {
            json.add("add_tag", (JsonElement)new Gson().toJsonTree((Object)addTag).getAsJsonArray());
        }
        if (ArrayUtils.isNotEmpty((Object[])removeTag)) {
            json.add("remove_tag", (JsonElement)new Gson().toJsonTree((Object)removeTag).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/mark_tag");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpAddMomentResult addMomentTask(WxCpAddMomentTask task) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_moment_task");
        String result = this.mainService.post(url, task.toJson());
        return WxCpAddMomentResult.fromJson(result);
    }

    @Override
    public WxCpGetMomentTaskResult getMomentTaskResult(String jobId) throws WxErrorException {
        String params = "&jobid=" + jobId;
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_task_result");
        String result = this.mainService.get(url, params);
        return WxCpGetMomentTaskResult.fromJson(result);
    }

    @Override
    public WxCpGetMomentList getMomentList(Long startTime, Long endTime, String creator, Integer filterType, String cursor, Integer limit) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("start_time", (Number)startTime);
        json.addProperty("end_time", (Number)endTime);
        if (!StringUtils.isEmpty((CharSequence)creator)) {
            json.addProperty("creator", creator);
        }
        if (filterType != null) {
            json.addProperty("filter_type", (Number)filterType);
        }
        if (!StringUtils.isEmpty((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpGetMomentList.fromJson(result);
    }

    @Override
    public WxCpGetMomentTask getMomentTask(String momentId, String cursor, Integer limit) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("moment_id", momentId);
        if (!StringUtils.isEmpty((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_task");
        String result = this.mainService.post(url, json.toString());
        return WxCpGetMomentTask.fromJson(result);
    }

    @Override
    public WxCpGetMomentCustomerList getMomentCustomerList(String momentId, String userId, String cursor, Integer limit) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("moment_id", momentId);
        json.addProperty("userid", userId);
        if (!StringUtils.isEmpty((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_customer_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpGetMomentCustomerList.fromJson(result);
    }

    @Override
    public WxCpGetMomentSendResult getMomentSendResult(String momentId, String userId, String cursor, Integer limit) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("moment_id", momentId);
        json.addProperty("userid", userId);
        if (!StringUtils.isEmpty((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_send_result");
        String result = this.mainService.post(url, json.toString());
        return WxCpGetMomentSendResult.fromJson(result);
    }

    @Override
    public WxCpGetMomentComments getMomentComments(String momentId, String userId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("moment_id", momentId);
        json.addProperty("userid", userId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_comments");
        String result = this.mainService.post(url, json.toString());
        return WxCpGetMomentComments.fromJson(result);
    }

    @Override
    public WxCpGroupMsgListResult getGroupMsgListV2(String chatType, @NonNull Date startTime, @NonNull Date endTime, String creator, Integer filterType, Integer limit, String cursor) throws WxErrorException {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        JsonObject json = new JsonObject();
        json.addProperty("chat_type", chatType);
        json.addProperty("start_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("end_time", (Number)(endTime.getTime() / 1000L));
        json.addProperty("creator", creator);
        json.addProperty("filter_type", (Number)filterType);
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_groupmsg_list_v2");
        String result = this.mainService.post(url, json.toString());
        return WxCpGroupMsgListResult.fromJson(result);
    }

    @Override
    public WxCpGroupMsgSendResult getGroupMsgSendResult(String msgid, String userid, Integer limit, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("msgid", msgid);
        json.addProperty("userid", userid);
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_groupmsg_send_result");
        String result = this.mainService.post(url, json.toString());
        return WxCpGroupMsgSendResult.fromJson(result);
    }

    @Override
    public WxCpGroupMsgResult getGroupMsgResult(String msgid, Integer limit, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("msgid", msgid);
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_group_msg_result");
        String result = this.mainService.post(url, json.toString());
        return WxCpGroupMsgResult.fromJson(result);
    }

    @Override
    public WxCpGroupMsgTaskResult getGroupMsgTask(String msgid, Integer limit, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("msgid", msgid);
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_groupmsg_task");
        String result = this.mainService.post(url, json.toString());
        return WxCpGroupMsgTaskResult.fromJson(result);
    }

    @Override
    public String addGroupWelcomeTemplate(WxCpGroupWelcomeTemplateResult template) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/group_welcome_template/add");
        String responseContent = this.mainService.post(url, template.toJson());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("template_id").getAsString();
    }

    @Override
    public WxCpBaseResp editGroupWelcomeTemplate(WxCpGroupWelcomeTemplateResult template) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/group_welcome_template/edit");
        String result = this.mainService.post(url, template.toJson());
        return WxCpGroupWelcomeTemplateResult.fromJson(result);
    }

    @Override
    public WxCpGroupWelcomeTemplateResult getGroupWelcomeTemplate(@NotNull String templateId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("template_id", templateId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/group_welcome_template/get");
        String result = this.mainService.post(url, json.toString());
        return WxCpGroupWelcomeTemplateResult.fromJson(result);
    }

    @Override
    public WxCpBaseResp delGroupWelcomeTemplate(@NotNull String templateId, String agentId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("template_id", templateId);
        if (!StringUtils.isEmpty((CharSequence)agentId)) {
            json.addProperty("agentid", agentId);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/group_welcome_template/del");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpProductAlbumListResult getProductAlbumList(Integer limit, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_product_album_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpProductAlbumListResult.fromJson(result);
    }

    @Override
    public WxCpProductAlbumResult getProductAlbum(String productId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("product_id", productId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_product_album");
        String result = this.mainService.post(url, json.toString());
        return WxCpProductAlbumResult.fromJson(result);
    }

    @Override
    public WxMediaUploadResult uploadAttachment(String mediaType, String fileType, Integer attachmentType, InputStream inputStream) throws WxErrorException, IOException {
        return this.uploadAttachment(mediaType, attachmentType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    @Override
    public WxMediaUploadResult uploadAttachment(String mediaType, Integer attachmentType, File file) throws WxErrorException {
        String params = "?media_type=" + mediaType + "&attachment_type=" + attachmentType;
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/upload_attachment" + params);
        return (WxMediaUploadResult)this.mainService.execute(MediaUploadRequestExecutor.create(this.mainService.getRequestHttp()), url, file);
    }

    @Override
    public WxCpInterceptRuleResultResp addInterceptRule(WxCpInterceptRuleResp ruleResp) throws WxErrorException {
        return WxCpInterceptRuleResultResp.fromJson(this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_intercept_rule"), ruleResp.toJson()));
    }

    @Override
    public WxCpInterceptRuleResultResp updateInterceptRule(WxCpInterceptRuleResp ruleResp) throws WxErrorException {
        return WxCpInterceptRuleResultResp.fromJson(this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/update_intercept_rule"), ruleResp.toJson()));
    }

    @Override
    public WxCpBaseResp delInterceptRule(String rule_id) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("rule_id", rule_id);
        return WxCpBaseResp.fromJson(this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/del_intercept_rule"), jsonObject));
    }

    @Override
    public String addProductAlbum(WxCpProductAlbumInfo wxCpProductAlbumInfo) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_product_album");
        String responseContent = this.mainService.post(url, wxCpProductAlbumInfo.toJson());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("product_id").getAsString();
    }

    @Override
    public void updateProductAlbum(WxCpProductAlbumInfo wxCpProductAlbumInfo) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/update_product_album");
        this.mainService.post(url, wxCpProductAlbumInfo.toJson());
    }

    @Override
    public void deleteProductAlbum(String productId) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("product_id", productId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/delete_product_album");
        this.mainService.post(url, o.toString());
    }

    @Override
    public WxCpGroupJoinWayResult addJoinWay(@NonNull WxCpGroupJoinWayInfo wxCpGroupJoinWayInfo) throws WxErrorException {
        if (wxCpGroupJoinWayInfo == null) {
            throw new NullPointerException("wxCpGroupJoinWayInfo is marked non-null but is null");
        }
        if (wxCpGroupJoinWayInfo.getJoinWay().getChatIdList() != null && wxCpGroupJoinWayInfo.getJoinWay().getChatIdList().size() > 5) {
            throw new WxRuntimeException("\u4f7f\u7528\u8be5\u914d\u7f6e\u7684\u5ba2\u6237\u7fa4ID\u5217\u8868\uff0c\u652f\u63015\u4e2a");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/add_join_way");
        String responseContent = this.mainService.post(url, wxCpGroupJoinWayInfo.getJoinWay().toJson());
        return WxCpGroupJoinWayResult.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updateJoinWay(@NonNull WxCpGroupJoinWayInfo wxCpGroupJoinWayInfo) throws WxErrorException {
        if (wxCpGroupJoinWayInfo == null) {
            throw new NullPointerException("wxCpGroupJoinWayInfo is marked non-null but is null");
        }
        if (wxCpGroupJoinWayInfo.getJoinWay().getChatIdList() != null && wxCpGroupJoinWayInfo.getJoinWay().getChatIdList().size() > 5) {
            throw new WxRuntimeException("\u4f7f\u7528\u8be5\u914d\u7f6e\u7684\u5ba2\u6237\u7fa4ID\u5217\u8868\uff0c\u652f\u63015\u4e2a");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/update_join_way");
        String responseContent = this.mainService.post(url, wxCpGroupJoinWayInfo.getJoinWay().toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpGroupJoinWayInfo getJoinWay(String configId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/get_join_way");
        String responseContent = this.mainService.post(url, json);
        return WxCpGroupJoinWayInfo.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp delJoinWay(@NonNull String configId) throws WxErrorException {
        if (configId == null) {
            throw new NullPointerException("configId is marked non-null but is null");
        }
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/del_join_way");
        String responseContent = this.mainService.post(url, json);
        return WxCpBaseResp.fromJson(responseContent);
    }

    public WxCpExternalContactServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

