/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpSchoolService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.school.WxCpCustomizeHealthInfo;
import me.chanjar.weixin.cp.bean.school.WxCpResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpSchoolServiceImpl
implements WxCpSchoolService {
    private static final Logger log = LoggerFactory.getLogger(WxCpSchoolServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpCustomizeHealthInfo getTeacherCustomizeHealthInfo(@NotNull String date, String nextKey, Integer limit) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/get_teacher_customize_health_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("date", date);
        jsonObject.addProperty("limit", (Number)Optional.ofNullable(limit).orElse(100));
        if (nextKey != null) {
            jsonObject.addProperty("next_key", nextKey);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpCustomizeHealthInfo.fromJson(responseContent);
    }

    @Override
    public WxCpCustomizeHealthInfo getStudentCustomizeHealthInfo(@NotNull String date, String nextKey, Integer limit) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/get_student_customize_health_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("date", date);
        jsonObject.addProperty("limit", (Number)Optional.ofNullable(limit).orElse(100));
        if (nextKey != null) {
            jsonObject.addProperty("next_key", nextKey);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpCustomizeHealthInfo.fromJson(responseContent);
    }

    @Override
    public WxCpResultList getHealthQrCode(@NotNull List<String> userIds, @NotNull Integer type) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/get_health_qrcode");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", (Number)type);
        jsonObject.addProperty("userids", userIds.toString());
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpResultList.fromJson(responseContent);
    }

    public WxCpSchoolServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

