/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.bean.ToJson;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSession;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpAgentService;
import me.chanjar.weixin.cp.api.WxCpAgentWorkBenchService;
import me.chanjar.weixin.cp.api.WxCpChatService;
import me.chanjar.weixin.cp.api.WxCpDepartmentService;
import me.chanjar.weixin.cp.api.WxCpExportService;
import me.chanjar.weixin.cp.api.WxCpExternalContactService;
import me.chanjar.weixin.cp.api.WxCpGroupRobotService;
import me.chanjar.weixin.cp.api.WxCpKfService;
import me.chanjar.weixin.cp.api.WxCpLivingService;
import me.chanjar.weixin.cp.api.WxCpMediaService;
import me.chanjar.weixin.cp.api.WxCpMenuService;
import me.chanjar.weixin.cp.api.WxCpMessageService;
import me.chanjar.weixin.cp.api.WxCpMsgAuditService;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpOaAgentService;
import me.chanjar.weixin.cp.api.WxCpOaCalendarService;
import me.chanjar.weixin.cp.api.WxCpOaScheduleService;
import me.chanjar.weixin.cp.api.WxCpOaService;
import me.chanjar.weixin.cp.api.WxCpOaWeDriveService;
import me.chanjar.weixin.cp.api.WxCpSchoolHealthService;
import me.chanjar.weixin.cp.api.WxCpSchoolService;
import me.chanjar.weixin.cp.api.WxCpSchoolUserService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.WxCpTagService;
import me.chanjar.weixin.cp.api.WxCpTaskCardService;
import me.chanjar.weixin.cp.api.WxCpUserService;
import me.chanjar.weixin.cp.api.impl.WxCpAgentServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpAgentWorkBenchServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpChatServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpDepartmentServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpExportServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpExternalContactServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpGroupRobotServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpKfServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpLivingServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMediaServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMenuServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMessageServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMsgAuditServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOAuth2ServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOaAgentServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOaCalendarServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOaOaScheduleServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOaServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOaWeDriveServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpSchoolHealthServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpSchoolServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpSchoolUserServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpTagServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpTaskCardServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpUserServiceImpl;
import me.chanjar.weixin.cp.bean.WxCpAgentJsapiSignature;
import me.chanjar.weixin.cp.bean.WxCpMaJsCode2SessionResult;
import me.chanjar.weixin.cp.bean.WxCpProviderToken;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxCpServiceImpl<H, P>
implements WxCpService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxCpServiceImpl.class);
    private WxCpUserService userService = new WxCpUserServiceImpl(this);
    private WxCpChatService chatService = new WxCpChatServiceImpl(this);
    private WxCpDepartmentService departmentService = new WxCpDepartmentServiceImpl(this);
    private WxCpMediaService mediaService = new WxCpMediaServiceImpl(this);
    private WxCpMenuService menuService = new WxCpMenuServiceImpl(this);
    private WxCpOAuth2Service oauth2Service = new WxCpOAuth2ServiceImpl(this);
    private WxCpTagService tagService = new WxCpTagServiceImpl(this);
    private WxCpAgentService agentService = new WxCpAgentServiceImpl(this);
    private WxCpOaService oaService = new WxCpOaServiceImpl(this);
    private WxCpSchoolService schoolService = new WxCpSchoolServiceImpl(this);
    private WxCpSchoolUserService schoolUserService = new WxCpSchoolUserServiceImpl(this);
    private WxCpSchoolHealthService schoolHealthService = new WxCpSchoolHealthServiceImpl(this);
    private WxCpLivingService livingService = new WxCpLivingServiceImpl(this);
    private WxCpOaAgentService oaAgentService = new WxCpOaAgentServiceImpl(this);
    private WxCpOaWeDriveService oaWeDriveService = new WxCpOaWeDriveServiceImpl(this);
    private WxCpMsgAuditService msgAuditService = new WxCpMsgAuditServiceImpl(this);
    private WxCpTaskCardService taskCardService = new WxCpTaskCardServiceImpl(this);
    private WxCpExternalContactService externalContactService = new WxCpExternalContactServiceImpl(this);
    private WxCpGroupRobotService groupRobotService = new WxCpGroupRobotServiceImpl(this);
    private WxCpMessageService messageService = new WxCpMessageServiceImpl(this);
    private WxCpOaCalendarService oaCalendarService = new WxCpOaCalendarServiceImpl(this);
    private WxCpOaScheduleService oaScheduleService = new WxCpOaOaScheduleServiceImpl(this);
    private WxCpAgentWorkBenchService workBenchService = new WxCpAgentWorkBenchServiceImpl(this);
    private WxCpKfService kfService = new WxCpKfServiceImpl(this);
    private WxCpExportService exportService = new WxCpExportServiceImpl(this);
    protected final Object globalAccessTokenRefreshLock = new Object();
    protected final Object globalJsapiTicketRefreshLock = new Object();
    protected final Object globalAgentJsapiTicketRefreshLock = new Object();
    protected WxCpConfigStorage configStorage;
    private WxSessionManager sessionManager = new StandardSessionManager();
    private File tmpDirFile;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String msgSignature, String timestamp, String nonce, String data) {
        try {
            return SHA1.gen((String[])new String[]{this.configStorage.getToken(), timestamp, nonce, data}).equals(msgSignature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String getAgentJsapiTicket() throws WxErrorException {
        return this.getAgentJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAgentJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireAgentJsapiTicket();
        }
        if (this.configStorage.isAgentJsapiTicketExpired()) {
            Object object = this.globalAgentJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.configStorage.isAgentJsapiTicketExpired()) {
                    String responseContent = this.get(this.configStorage.getApiUrl("/cgi-bin/ticket/get?&type=agent_config"), null);
                    JsonObject jsonObject = GsonParser.parse((String)responseContent);
                    this.configStorage.updateAgentJsapiTicket(jsonObject.get("ticket").getAsString(), jsonObject.get("expires_in").getAsInt());
                }
            }
        }
        return this.configStorage.getAgentJsapiTicket();
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireJsapiTicket();
        }
        if (this.configStorage.isJsapiTicketExpired()) {
            Object object = this.globalJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.configStorage.isJsapiTicketExpired()) {
                    String responseContent = this.get(this.configStorage.getApiUrl("/cgi-bin/get_jsapi_ticket"), null);
                    JsonObject tmpJsonObject = GsonParser.parse((String)responseContent);
                    this.configStorage.updateJsapiTicket(tmpJsonObject.get("ticket").getAsString(), tmpJsonObject.get("expires_in").getAsInt());
                }
            }
        }
        return this.configStorage.getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        jsapiSignature.setAppId(this.configStorage.getCorpId());
        return jsapiSignature;
    }

    @Override
    public WxCpAgentJsapiSignature createAgentJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getAgentJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxCpAgentJsapiSignature jsapiSignature = new WxCpAgentJsapiSignature();
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        jsapiSignature.setCorpid(this.configStorage.getCorpId());
        jsapiSignature.setAgentid(this.configStorage.getAgentId());
        return jsapiSignature;
    }

    @Override
    public WxCpMaJsCode2SessionResult jsCode2Session(String jsCode) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        String url = this.configStorage.getApiUrl("/cgi-bin/miniprogram/jscode2session");
        return WxCpMaJsCode2SessionResult.fromJson(this.get(url, Joiner.on((String)"&").withKeyValueSeparator("=").join(params)));
    }

    @Override
    public String[] getCallbackIp() throws WxErrorException {
        String responseContent = this.get(this.configStorage.getApiUrl("/cgi-bin/getcallbackip"), null);
        JsonObject tmpJsonObject = GsonParser.parse((String)responseContent);
        JsonArray jsonArray = tmpJsonObject.get("ip_list").getAsJsonArray();
        String[] ips = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            ips[i] = jsonArray.get(i).getAsString();
        }
        return ips;
    }

    @Override
    public WxCpProviderToken getProviderToken(String corpId, String providerSecret) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("corpid", corpId);
        jsonObject.addProperty("provider_secret", providerSecret);
        return WxCpProviderToken.fromJson(this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_provider_token"), jsonObject.toString()));
    }

    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    public String post(String url, JsonObject jsonObject) throws WxErrorException {
        return this.post(url, jsonObject.toString());
    }

    public String post(String url, ToJson obj) throws WxErrorException {
        return this.post(url, obj.toJson());
    }

    public String post(String url, Object obj) throws WxErrorException {
        return this.post(url, obj.toString());
    }

    @Override
    public String postWithoutToken(String url, String postData) throws WxErrorException {
        return (String)this.executeNormal(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data, false);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data, boolean doNotAutoRefresh) throws WxErrorException {
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data, WxType.CP);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (WxConsts.ACCESS_TOKEN_ERROR_CODES.contains(error.getErrorCode())) {
                this.configStorage.expireAccessToken();
                if (this.getWxCpConfigStorage().autoRefreshToken() && !doNotAutoRefresh) {
                    log.warn("\u5373\u5c06\u91cd\u65b0\u83b7\u53d6\u65b0\u7684access_token\uff0c\u9519\u8bef\u4ee3\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)error.getErrorCode(), (Object)error.getErrorMsg());
                    return this.executeInternal(executor, uri, data, true);
                }
            }
            if (error.getErrorCode() != 0) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new WxRuntimeException((Throwable)e);
        }
    }

    private <T, E> T executeNormal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        try {
            Object result = executor.execute(uri, data, WxType.CP);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uri, data, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() != 0) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uri, data, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uri, data, e.getMessage()});
            throw new WxErrorException((Throwable)e);
        }
    }

    @Override
    public void setWxCpConfigStorage(WxCpConfigStorage wxConfigProvider) {
        this.configStorage = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxSession getSession(String id) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id);
    }

    @Override
    public WxSession getSession(String id, boolean create) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id, create);
    }

    @Override
    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public WxSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public String replaceParty(String mediaId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post(this.configStorage.getApiUrl("/cgi-bin/batch/replaceparty"), jsonObject.toString());
    }

    @Override
    public String syncUser(String mediaId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        String responseContent = this.post(this.configStorage.getApiUrl("/cgi-bin/batch/syncuser"), jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("jobid").getAsString();
    }

    @Override
    public String replaceUser(String mediaId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post(this.configStorage.getApiUrl("/cgi-bin/batch/replaceuser"), jsonObject.toString());
    }

    @Override
    public String getTaskResult(String jobId) throws WxErrorException {
        String url = this.configStorage.getApiUrl("/cgi-bin/batch/getresult?jobid=" + jobId);
        return this.get(url, null);
    }

    @Override
    public String buildQrConnectUrl(String redirectUri, String state) {
        return String.format("https://open.work.weixin.qq.com/wwopen/sso/qrConnect?appid=%s&agentid=%s&redirect_uri=%s&state=%s", this.configStorage.getCorpId(), this.configStorage.getAgentId(), URIUtil.encodeURIComponent((String)redirectUri), StringUtils.trimToEmpty((String)state));
    }

    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    @Override
    public WxCpDepartmentService getDepartmentService() {
        return this.departmentService;
    }

    @Override
    public WxCpMediaService getMediaService() {
        return this.mediaService;
    }

    @Override
    public WxCpMenuService getMenuService() {
        return this.menuService;
    }

    @Override
    public WxCpOAuth2Service getOauth2Service() {
        return this.oauth2Service;
    }

    @Override
    public WxCpTagService getTagService() {
        return this.tagService;
    }

    @Override
    public WxCpUserService getUserService() {
        return this.userService;
    }

    @Override
    public WxCpExternalContactService getExternalContactService() {
        return this.externalContactService;
    }

    @Override
    public WxCpChatService getChatService() {
        return this.chatService;
    }

    @Override
    public WxCpOaService getOaService() {
        return this.oaService;
    }

    @Override
    public WxCpSchoolService getSchoolService() {
        return this.schoolService;
    }

    @Override
    public WxCpSchoolUserService getSchoolUserService() {
        return this.schoolUserService;
    }

    @Override
    public WxCpSchoolHealthService getSchoolHealthService() {
        return this.schoolHealthService;
    }

    @Override
    public WxCpLivingService getLivingService() {
        return this.livingService;
    }

    @Override
    public WxCpOaAgentService getOaAgentService() {
        return this.oaAgentService;
    }

    @Override
    public WxCpOaWeDriveService getOaWeDriveService() {
        return this.oaWeDriveService;
    }

    @Override
    public WxCpMsgAuditService getMsgAuditService() {
        return this.msgAuditService;
    }

    @Override
    public WxCpOaCalendarService getOaCalendarService() {
        return this.oaCalendarService;
    }

    @Override
    public WxCpGroupRobotService getGroupRobotService() {
        return this.groupRobotService;
    }

    @Override
    public WxCpAgentWorkBenchService getWorkBenchService() {
        return this.workBenchService;
    }

    @Override
    public WxCpTaskCardService getTaskCardService() {
        return this.taskCardService;
    }

    @Override
    public RequestHttp<?, ?> getRequestHttp() {
        return this;
    }

    @Override
    public void setUserService(WxCpUserService userService) {
        this.userService = userService;
    }

    @Override
    public void setDepartmentService(WxCpDepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @Override
    public void setMediaService(WxCpMediaService mediaService) {
        this.mediaService = mediaService;
    }

    @Override
    public void setMenuService(WxCpMenuService menuService) {
        this.menuService = menuService;
    }

    @Override
    public void setOauth2Service(WxCpOAuth2Service oauth2Service) {
        this.oauth2Service = oauth2Service;
    }

    @Override
    public void setTagService(WxCpTagService tagService) {
        this.tagService = tagService;
    }

    @Override
    public WxCpAgentService getAgentService() {
        return this.agentService;
    }

    @Override
    public WxCpMessageService getMessageService() {
        return this.messageService;
    }

    public void setAgentService(WxCpAgentService agentService) {
        this.agentService = agentService;
    }

    @Override
    public WxCpOaScheduleService getOaScheduleService() {
        return this.oaScheduleService;
    }

    @Override
    public WxCpKfService getKfService() {
        return this.kfService;
    }

    @Override
    public void setKfService(WxCpKfService kfService) {
        this.kfService = kfService;
    }

    @Override
    public WxCpExportService getExportService() {
        return this.exportService;
    }

    @Override
    public void setExportService(WxCpExportService exportService) {
        this.exportService = exportService;
    }
}

