/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpSchoolUserService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.school.user.WxCpCreateParentRequest;
import me.chanjar.weixin.cp.bean.school.user.WxCpUpdateParentRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpSchoolUserServiceImpl
implements WxCpSchoolUserService {
    private static final Logger log = LoggerFactory.getLogger(WxCpSchoolUserServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpBaseResp createStudent(@NonNull String studentUserId, @NonNull String name, @NonNull List<Integer> departments) throws WxErrorException {
        if (studentUserId == null) {
            throw new NullPointerException("studentUserId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (departments == null) {
            throw new NullPointerException("departments is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/create_student");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("student_userid", studentUserId);
        jsonObject.addProperty("name", name);
        JsonArray jsonArray = new JsonArray();
        for (Integer depart : departments) {
            jsonArray.add((JsonElement)new JsonPrimitive((Number)depart));
        }
        jsonObject.add("department", (JsonElement)jsonArray);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp deleteStudent(@NonNull String studentUserId) throws WxErrorException {
        if (studentUserId == null) {
            throw new NullPointerException("studentUserId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/delete_student?userid=") + studentUserId;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updateStudent(@NonNull String studentUserId, String newStudentUserId, String name, List<Integer> departments) throws WxErrorException {
        if (studentUserId == null) {
            throw new NullPointerException("studentUserId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/update_student");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("student_userid", studentUserId);
        if (StringUtils.isNotEmpty((CharSequence)newStudentUserId)) {
            jsonObject.addProperty("new_student_userid", newStudentUserId);
        }
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            jsonObject.addProperty("name", name);
        }
        if (departments != null && departments.size() > 0) {
            JsonArray jsonArray = new JsonArray();
            for (Integer depart : departments) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)depart));
            }
            jsonObject.add("department", (JsonElement)jsonArray);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp createParent(@NonNull WxCpCreateParentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/create_parent");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updateParent(@NonNull WxCpUpdateParentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/update_parent");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp deleteParent(@NonNull String userId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/delete_parent?userid=") + userId;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp setArchSyncMode(@NonNull Integer archSyncMode) throws WxErrorException {
        if (archSyncMode == null) {
            throw new NullPointerException("archSyncMode is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/set_arch_sync_mode");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("arch_sync_mode", (Number)archSyncMode);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    public WxCpSchoolUserServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

