/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import java.util.Optional;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpSchoolHealthService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.school.health.WxCpGetHealthReportStat;
import me.chanjar.weixin.cp.bean.school.health.WxCpGetReportAnswer;
import me.chanjar.weixin.cp.bean.school.health.WxCpGetReportJobIds;
import me.chanjar.weixin.cp.bean.school.health.WxCpGetReportJobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpSchoolHealthServiceImpl
implements WxCpSchoolHealthService {
    private static final Logger log = LoggerFactory.getLogger(WxCpSchoolHealthServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpGetHealthReportStat getHealthReportStat(@NonNull String date) throws WxErrorException {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/health/get_health_report_stat");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("date", date);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpGetHealthReportStat.fromJson(responseContent);
    }

    @Override
    public WxCpGetReportJobIds getReportJobIds(Integer offset, Integer limit) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/health/get_report_jobids");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)Optional.ofNullable(offset).orElse(0));
        jsonObject.addProperty("limit", (Number)Optional.ofNullable(limit).orElse(100));
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpGetReportJobIds.fromJson(responseContent);
    }

    @Override
    public WxCpGetReportJobInfo getReportJobInfo(@NonNull String jobId, @NonNull String date) throws WxErrorException {
        if (jobId == null) {
            throw new NullPointerException("jobId is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/health/get_report_job_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("jobid", jobId);
        jsonObject.addProperty("date", date);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpGetReportJobInfo.fromJson(responseContent);
    }

    @Override
    public WxCpGetReportAnswer getReportAnswer(@NonNull String jobId, @NonNull String date, Integer offset, Integer limit) throws WxErrorException {
        if (jobId == null) {
            throw new NullPointerException("jobId is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/health/get_report_answer");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("jobid", jobId);
        jsonObject.addProperty("date", date);
        if (offset != null) {
            jsonObject.addProperty("offset", (Number)offset);
        }
        if (limit != null) {
            jsonObject.addProperty("limit", (Number)limit);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpGetReportAnswer.fromJson(responseContent);
    }

    public WxCpSchoolHealthServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

