/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.JsonObject;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.WxCpTpUnionidToExternalUseridResult;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import me.chanjar.weixin.cp.tp.service.WxCpTpIdConvertService;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;

public class WxCpTpIdConvertServiceImpl
implements WxCpTpIdConvertService {
    private final WxCpTpService mainService;

    @Override
    public WxCpTpUnionidToExternalUseridResult unionidToExternalUserid(String cropId, String unionid, String openid, Integer subjectType) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("unionid", unionid);
        json.addProperty("openid", openid);
        if (subjectType != null) {
            json.addProperty("subject_type", (Number)subjectType);
        }
        WxCpTpConfigStorage wxCpTpConfigStorage = this.mainService.getWxCpTpConfigStorage();
        String accessToken = wxCpTpConfigStorage.getAccessToken(cropId);
        String url = wxCpTpConfigStorage.getApiUrl("/cgi-bin/idconvert/unionid_to_external_userid");
        url = url + "?access_token=" + accessToken;
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpTpUnionidToExternalUseridResult.fromJson(responseContent);
    }

    public WxCpTpIdConvertServiceImpl(WxCpTpService mainService) {
        this.mainService = mainService;
    }
}

