/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxCpErrorMsgEnum;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.cp.bean.WxCpMaJsCode2SessionResult;
import me.chanjar.weixin.cp.bean.WxCpProviderToken;
import me.chanjar.weixin.cp.bean.WxCpTpAdmin;
import me.chanjar.weixin.cp.bean.WxCpTpAppQrcode;
import me.chanjar.weixin.cp.bean.WxCpTpAuthInfo;
import me.chanjar.weixin.cp.bean.WxCpTpCorp;
import me.chanjar.weixin.cp.bean.WxCpTpCorpId2OpenCorpId;
import me.chanjar.weixin.cp.bean.WxCpTpPermanentCodeInfo;
import me.chanjar.weixin.cp.bean.WxCpTpPreauthCode;
import me.chanjar.weixin.cp.bean.WxCpTpUserDetail;
import me.chanjar.weixin.cp.bean.WxCpTpUserInfo;
import me.chanjar.weixin.cp.bean.WxTpCustomizedAuthUrl;
import me.chanjar.weixin.cp.bean.WxTpLoginInfo;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import me.chanjar.weixin.cp.tp.service.WxCpTpContactService;
import me.chanjar.weixin.cp.tp.service.WxCpTpDepartmentService;
import me.chanjar.weixin.cp.tp.service.WxCpTpEditionService;
import me.chanjar.weixin.cp.tp.service.WxCpTpIdConvertService;
import me.chanjar.weixin.cp.tp.service.WxCpTpLicenseService;
import me.chanjar.weixin.cp.tp.service.WxCpTpMediaService;
import me.chanjar.weixin.cp.tp.service.WxCpTpOAService;
import me.chanjar.weixin.cp.tp.service.WxCpTpOrderService;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;
import me.chanjar.weixin.cp.tp.service.WxCpTpUserService;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpContactServiceImpl;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpDepartmentServiceImpl;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpEditionServiceImpl;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpIdConvertServiceImpl;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpLicenseServiceImpl;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpMediaServiceImpl;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpOAServiceImpl;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpOrderServiceImpl;
import me.chanjar.weixin.cp.tp.service.impl.WxCpTpUserServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxCpTpServiceImpl<H, P>
implements WxCpTpService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxCpTpServiceImpl.class);
    private WxCpTpContactService wxCpTpContactService = new WxCpTpContactServiceImpl(this);
    private WxCpTpDepartmentService wxCpTpDepartmentService = new WxCpTpDepartmentServiceImpl(this);
    private WxCpTpMediaService wxCpTpMediaService = new WxCpTpMediaServiceImpl(this);
    private WxCpTpOAService wxCpTpOAService = new WxCpTpOAServiceImpl(this);
    private WxCpTpUserService wxCpTpUserService = new WxCpTpUserServiceImpl(this);
    private WxCpTpOrderService wxCpTpOrderService = new WxCpTpOrderServiceImpl(this);
    private WxCpTpEditionService wxCpTpEditionService = new WxCpTpEditionServiceImpl(this);
    private WxCpTpLicenseService wxCpTpLicenseService = new WxCpTpLicenseServiceImpl(this);
    private WxCpTpIdConvertService wxCpTpIdConvertService = new WxCpTpIdConvertServiceImpl(this);
    protected final Object globalSuiteAccessTokenRefreshLock = new Object();
    protected final Object globalSuiteTicketRefreshLock = new Object();
    protected final Object globalJsApiTicketRefreshLock = new Object();
    protected final Object globalAuthCorpJsApiTicketRefreshLock = new Object();
    protected final Object globalProviderTokenRefreshLock = new Object();
    protected WxCpTpConfigStorage configStorage;
    private final WxSessionManager sessionManager = new StandardSessionManager();
    private File tmpDirFile;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String msgSignature, String timestamp, String nonce, String data) {
        try {
            return SHA1.gen((String[])new String[]{this.configStorage.getToken(), timestamp, nonce, data}).equals(msgSignature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getSuiteAccessToken() throws WxErrorException {
        return this.getSuiteAccessToken(false);
    }

    @Override
    public WxAccessToken getSuiteAccessTokenEntity() throws WxErrorException {
        return this.getSuiteAccessTokenEntity(false);
    }

    @Override
    public WxAccessToken getSuiteAccessTokenEntity(boolean forceRefresh) throws WxErrorException {
        this.getSuiteAccessToken(forceRefresh);
        return this.configStorage.getSuiteAccessTokenEntity();
    }

    @Override
    public String getSuiteTicket() throws WxErrorException {
        if (this.configStorage.isSuiteTicketExpired()) {
            WxError wxError = WxError.fromJson((String)"{\"errcode\":40085, \"errmsg\":\"invaild suite ticket\"}", (WxType)WxType.CP);
            throw new WxErrorException(wxError);
        }
        return this.configStorage.getSuiteTicket();
    }

    @Override
    public String getSuiteTicket(boolean forceRefresh) throws WxErrorException {
        return this.getSuiteTicket();
    }

    @Override
    public void setSuiteTicket(String suiteTicket) {
        this.setSuiteTicket(suiteTicket, 1680);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSuiteTicket(String suiteTicket, int expiresInSeconds) {
        Object object = this.globalSuiteTicketRefreshLock;
        synchronized (object) {
            this.configStorage.updateSuiteTicket(suiteTicket, expiresInSeconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSuiteJsApiTicket(String authCorpId) throws WxErrorException {
        if (this.configStorage.isAuthSuiteJsApiTicketExpired(authCorpId)) {
            String resp = this.get(this.configStorage.getApiUrl("/cgi-bin/ticket/get"), "type=agent_config&access_token=" + this.configStorage.getAccessToken(authCorpId), true);
            JsonObject jsonObject = GsonParser.parse((String)resp);
            if (jsonObject.get("errcode").getAsInt() == 0) {
                String jsApiTicket = jsonObject.get("ticket").getAsString();
                int expiredInSeconds = jsonObject.get("expires_in").getAsInt();
                Object object = this.globalJsApiTicketRefreshLock;
                synchronized (object) {
                    this.configStorage.updateAuthSuiteJsApiTicket(authCorpId, jsApiTicket, expiredInSeconds);
                }
            } else {
                throw new WxErrorException(WxError.fromJson((String)resp));
            }
        }
        return this.configStorage.getAuthSuiteJsApiTicket(authCorpId);
    }

    @Override
    public String getSuiteJsApiTicket(String authCorpId, boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireAuthSuiteJsApiTicket(authCorpId);
        }
        return this.getSuiteJsApiTicket(authCorpId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAuthCorpJsApiTicket(String authCorpId) throws WxErrorException {
        if (this.configStorage.isAuthCorpJsApiTicketExpired(authCorpId)) {
            String resp = this.get(this.configStorage.getApiUrl("/cgi-bin/get_jsapi_ticket"), "access_token=" + this.configStorage.getAccessToken(authCorpId), true);
            JsonObject jsonObject = GsonParser.parse((String)resp);
            if (jsonObject.get("errcode").getAsInt() == 0) {
                String jsApiTicket = jsonObject.get("ticket").getAsString();
                int expiredInSeconds = jsonObject.get("expires_in").getAsInt();
                Object object = this.globalAuthCorpJsApiTicketRefreshLock;
                synchronized (object) {
                    this.configStorage.updateAuthCorpJsApiTicket(authCorpId, jsApiTicket, expiredInSeconds);
                }
            } else {
                throw new WxErrorException(WxError.fromJson((String)resp));
            }
        }
        return this.configStorage.getAuthCorpJsApiTicket(authCorpId);
    }

    @Override
    public String getAuthCorpJsApiTicket(String authCorpId, boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireAuthCorpJsApiTicket(authCorpId);
        }
        return this.getAuthCorpJsApiTicket(authCorpId);
    }

    @Override
    public WxCpMaJsCode2SessionResult jsCode2Session(String jsCode) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        String url = this.configStorage.getApiUrl("/cgi-bin/service/miniprogram/jscode2session");
        return WxCpMaJsCode2SessionResult.fromJson(this.get(url, Joiner.on((String)"&").withKeyValueSeparator("=").join(params)));
    }

    @Override
    public WxAccessToken getCorpToken(String authCorpId, String permanentCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auth_corpid", authCorpId);
        jsonObject.addProperty("permanent_code", permanentCode);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_corp_token"), jsonObject.toString());
        return WxAccessToken.fromJson((String)result);
    }

    @Override
    public WxAccessToken getCorpToken(String authCorpId, String permanentCode, boolean forceRefresh) throws WxErrorException {
        if (this.configStorage.isAccessTokenExpired(authCorpId) || forceRefresh) {
            WxAccessToken corpToken = this.getCorpToken(authCorpId, permanentCode);
            this.configStorage.updateAccessToken(authCorpId, corpToken.getAccessToken(), corpToken.getExpiresIn());
        }
        return this.configStorage.getAccessTokenEntity(authCorpId);
    }

    @Override
    public WxCpTpCorp getPermanentCode(String authCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auth_code", authCode);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_permanent_code"), jsonObject.toString());
        jsonObject = GsonParser.parse((String)result);
        WxCpTpCorp wxCpTpCorp = WxCpTpCorp.fromJson(jsonObject.get("auth_corp_info").getAsJsonObject().toString());
        wxCpTpCorp.setPermanentCode(jsonObject.get("permanent_code").getAsString());
        return wxCpTpCorp;
    }

    @Override
    public WxCpTpPermanentCodeInfo getPermanentCodeInfo(String authCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auth_code", authCode);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_permanent_code"), jsonObject.toString());
        return WxCpTpPermanentCodeInfo.fromJson(result);
    }

    @Override
    public String getPreAuthUrl(String redirectUri, String state) throws WxErrorException {
        String result = this.get(this.configStorage.getApiUrl("/cgi-bin/service/get_pre_auth_code"), null);
        WxCpTpPreauthCode preAuthCode = WxCpTpPreauthCode.fromJson(result);
        String preAuthUrl = "https://open.work.weixin.qq.com/3rdapp/install?suite_id=" + this.configStorage.getSuiteId() + "&pre_auth_code=" + preAuthCode.getPreAuthCode() + "&redirect_uri=" + URLEncoder.encode(redirectUri, "utf-8");
        if (StringUtils.isNotBlank((CharSequence)state)) {
            preAuthUrl = preAuthUrl + "&state=" + state;
        }
        return preAuthUrl;
    }

    @Override
    public String getPreAuthUrl(String redirectUri, String state, int authType) throws WxErrorException {
        String result = this.get(this.configStorage.getApiUrl("/cgi-bin/service/get_pre_auth_code"), null);
        WxCpTpPreauthCode preAuthCode = WxCpTpPreauthCode.fromJson(result);
        String setSessionUrl = "https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info";
        HashMap<String, Integer> sessionInfo = new HashMap<String, Integer>(1);
        sessionInfo.put("auth_type", authType);
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("pre_auth_code", preAuthCode.getPreAuthCode());
        param.put("session_info", sessionInfo);
        String postData = new Gson().toJson(param);
        this.post(setSessionUrl, postData);
        String preAuthUrl = "https://open.work.weixin.qq.com/3rdapp/install?suite_id=" + this.configStorage.getSuiteId() + "&pre_auth_code=" + preAuthCode.getPreAuthCode() + "&redirect_uri=" + URLEncoder.encode(redirectUri, "utf-8");
        if (StringUtils.isNotBlank((CharSequence)state)) {
            preAuthUrl = preAuthUrl + "&state=" + state;
        }
        return preAuthUrl;
    }

    @Override
    public WxCpTpAuthInfo getAuthInfo(String authCorpId, String permanentCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auth_corpid", authCorpId);
        jsonObject.addProperty("permanent_code", permanentCode);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_auth_info"), jsonObject.toString());
        return WxCpTpAuthInfo.fromJson(result);
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String get(String url, String queryParam, boolean withoutSuiteAccessToken) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam, withoutSuiteAccessToken);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData, false);
    }

    public String post(String url, String postData, boolean withoutSuiteAccessToken) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData, withoutSuiteAccessToken);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        return this.execute(executor, uri, data, false);
    }

    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data, boolean withoutSuiteAccessToken) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data, withoutSuiteAccessToken);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        return this.executeInternal(executor, uri, data, false);
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data, boolean withoutSuiteAccessToken) throws WxErrorException {
        String uriWithAccessToken;
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("suite_access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709suite_access_token: " + uri);
        }
        if (!withoutSuiteAccessToken) {
            String suiteAccessToken = this.getSuiteAccessToken(false);
            uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "suite_access_token=" + suiteAccessToken;
        } else {
            uriWithAccessToken = uri;
        }
        try {
            Object result = executor.execute(uriWithAccessToken, data, WxType.CP);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == WxCpErrorMsgEnum.CODE_42009.getCode()) {
                this.configStorage.expireSuiteAccessToken();
                if (this.getWxCpTpConfigStorage().autoRefreshToken()) {
                    log.warn("\u5373\u5c06\u91cd\u65b0\u83b7\u53d6\u65b0\u7684access_token\uff0c\u9519\u8bef\u4ee3\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)error.getErrorCode(), (Object)error.getErrorMsg());
                    return this.execute(executor, uri, data);
                }
            }
            if (error.getErrorCode() != 0) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new WxRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setWxCpTpConfigStorage(WxCpTpConfigStorage wxConfigProvider) {
        this.configStorage = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    @Override
    public RequestHttp<?, ?> getRequestHttp() {
        return this;
    }

    @Override
    public WxSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public WxCpTpUserInfo getUserInfo3rd(String code) throws WxErrorException {
        String url = this.configStorage.getApiUrl("/cgi-bin/service/getuserinfo3rd");
        String result = this.get(url + "?code=" + code, null);
        return WxCpTpUserInfo.fromJson(result);
    }

    @Override
    public WxCpTpUserDetail getUserDetail3rd(String userTicket) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("user_ticket", userTicket);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/getuserdetail3rd"), jsonObject.toString());
        return WxCpTpUserDetail.fromJson(result);
    }

    @Override
    public WxTpLoginInfo getLoginInfo(String authCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auth_code", authCode);
        String access_token = this.getWxCpProviderToken();
        String responseText = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_login_info") + "?access_token=" + access_token, jsonObject.toString(), true);
        return WxTpLoginInfo.fromJson(responseText);
    }

    @Override
    public WxTpCustomizedAuthUrl getCustomizedAuthUrl(String state, List<String> templateIdList) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("state", state);
        jsonObject.add("templateid_list", (JsonElement)WxGsonBuilder.create().toJsonTree(templateIdList).getAsJsonArray());
        String responseText = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_customized_auth_url") + "?provider_access_token=" + this.getWxCpProviderToken(), jsonObject.toString(), true);
        return WxTpCustomizedAuthUrl.fromJson(responseText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWxCpProviderToken() throws WxErrorException {
        if (this.configStorage.isProviderTokenExpired()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("corpid", this.configStorage.getCorpId());
            jsonObject.addProperty("provider_secret", this.configStorage.getProviderSecret());
            WxCpProviderToken wxCpProviderToken = WxCpProviderToken.fromJson(this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_provider_token"), jsonObject.toString(), true));
            String providerAccessToken = wxCpProviderToken.getProviderAccessToken();
            Integer expiresIn = wxCpProviderToken.getExpiresIn();
            Object object = this.globalProviderTokenRefreshLock;
            synchronized (object) {
                this.configStorage.updateProviderToken(providerAccessToken, expiresIn - 200);
            }
        }
        return this.configStorage.getProviderToken();
    }

    @Override
    public WxCpProviderToken getWxCpProviderTokenEntity() throws WxErrorException {
        return this.getWxCpProviderTokenEntity(false);
    }

    @Override
    public WxCpProviderToken getWxCpProviderTokenEntity(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireProviderToken();
        }
        this.getWxCpProviderToken();
        return this.configStorage.getProviderTokenEntity();
    }

    @Override
    public WxCpTpContactService getWxCpTpContactService() {
        return this.wxCpTpContactService;
    }

    @Override
    public WxCpTpDepartmentService getWxCpTpDepartmentService() {
        return this.wxCpTpDepartmentService;
    }

    @Override
    public WxCpTpMediaService getWxCpTpMediaService() {
        return this.wxCpTpMediaService;
    }

    @Override
    public WxCpTpOAService getWxCpTpOAService() {
        return this.wxCpTpOAService;
    }

    @Override
    public WxCpTpUserService getWxCpTpUserService() {
        return this.wxCpTpUserService;
    }

    @Override
    public void setWxCpTpContactService(WxCpTpContactService wxCpTpContactService) {
        this.wxCpTpContactService = wxCpTpContactService;
    }

    @Override
    public void setWxCpTpDepartmentService(WxCpTpDepartmentService wxCpTpDepartmentService) {
        this.wxCpTpDepartmentService = wxCpTpDepartmentService;
    }

    @Override
    public void setWxCpTpMediaService(WxCpTpMediaService wxCpTpMediaService) {
        this.wxCpTpMediaService = wxCpTpMediaService;
    }

    @Override
    public void setWxCpTpOAService(WxCpTpOAService wxCpTpOAService) {
        this.wxCpTpOAService = wxCpTpOAService;
    }

    @Override
    public WxCpTpLicenseService getWxCpTpLicenseService() {
        return this.wxCpTpLicenseService;
    }

    @Override
    public void setWxCpTpLicenseService(WxCpTpLicenseService wxCpTpLicenseService) {
        this.wxCpTpLicenseService = wxCpTpLicenseService;
    }

    @Override
    public void setWxCpTpUserService(WxCpTpUserService wxCpTpUserService) {
        this.wxCpTpUserService = wxCpTpUserService;
    }

    @Override
    public WxCpTpAdmin getAdminList(String authCorpId, Integer agentId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auth_corpid", authCorpId);
        jsonObject.addProperty("agentid", (Number)agentId);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_admin_list"), jsonObject.toString());
        return WxCpTpAdmin.fromJson(result);
    }

    @Override
    public WxCpTpAppQrcode getAppQrcode(String suiteId, String appId, String state, Integer style, Integer resultType) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("suite_id", suiteId);
        jsonObject.addProperty("appid", appId);
        jsonObject.addProperty("state", state);
        jsonObject.addProperty("style", (Number)style);
        jsonObject.addProperty("result_type", (Number)resultType);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/get_app_qrcode"), jsonObject.toString());
        return WxCpTpAppQrcode.fromJson(result);
    }

    @Override
    public WxCpTpCorpId2OpenCorpId corpId2OpenCorpId(String corpId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("corpid", corpId);
        String result = this.post(this.configStorage.getApiUrl("/cgi-bin/service/corpid_to_opencorpid") + "?provider_access_token=" + this.getWxCpProviderToken(), jsonObject.toString());
        return WxCpTpCorpId2OpenCorpId.fromJson(result);
    }

    @Override
    public WxJsapiSignature createAuthCorpJsApiTicketSignature(String url, String authCorpId) throws WxErrorException {
        return this.doCreateWxJsapiSignature(url, authCorpId, this.getAuthCorpJsApiTicket(authCorpId));
    }

    @Override
    public WxJsapiSignature createSuiteJsApiTicketSignature(String url, String authCorpId) throws WxErrorException {
        return this.doCreateWxJsapiSignature(url, authCorpId, this.getSuiteJsApiTicket(authCorpId));
    }

    @Override
    public void expireSuiteAccessToken() {
        this.configStorage.expireSuiteAccessToken();
    }

    @Override
    public void expireAccessToken(String authCorpId) {
        this.configStorage.expireAccessToken(authCorpId);
    }

    @Override
    public void expireAuthCorpJsApiTicket(String authCorpId) {
        this.configStorage.expireAuthCorpJsApiTicket(authCorpId);
    }

    @Override
    public void expireAuthSuiteJsApiTicket(String authCorpId) {
        this.configStorage.expireAuthSuiteJsApiTicket(authCorpId);
    }

    @Override
    public void expireProviderToken() {
        this.configStorage.expireProviderToken();
    }

    @Override
    public WxCpTpOrderService getWxCpTpOrderService() {
        return this.wxCpTpOrderService;
    }

    @Override
    public void setWxCpTpOrderService(WxCpTpOrderService wxCpTpOrderService) {
        this.wxCpTpOrderService = wxCpTpOrderService;
    }

    @Override
    public WxCpTpEditionService getWxCpTpEditionService() {
        return this.wxCpTpEditionService;
    }

    @Override
    public void setWxCpTpOrderService(WxCpTpEditionService wxCpTpEditionService) {
        this.wxCpTpEditionService = wxCpTpEditionService;
    }

    private WxJsapiSignature doCreateWxJsapiSignature(String url, String authCorpId, String jsapiTicket) {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        jsapiSignature.setAppId(authCorpId);
        return jsapiSignature;
    }

    @Override
    public WxCpTpIdConvertService getWxCpTpIdConverService() {
        return this.wxCpTpIdConvertService;
    }

    @Override
    public void setWxCpTpIdConverService(WxCpTpIdConvertService wxCpTpIdConvertService) {
        this.wxCpTpIdConvertService = wxCpTpIdConvertService;
    }
}

