/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.tencent.wework.Finance;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpMsgAuditService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.msgaudit.WxCpAgreeInfo;
import me.chanjar.weixin.cp.bean.msgaudit.WxCpChatDatas;
import me.chanjar.weixin.cp.bean.msgaudit.WxCpChatModel;
import me.chanjar.weixin.cp.bean.msgaudit.WxCpCheckAgreeRequest;
import me.chanjar.weixin.cp.bean.msgaudit.WxCpGroupChat;
import me.chanjar.weixin.cp.util.crypto.WxCpCryptUtil;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpMsgAuditServiceImpl
implements WxCpMsgAuditService {
    private static final Logger log = LoggerFactory.getLogger(WxCpMsgAuditServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpChatDatas getChatDatas(long seq, @NonNull long limit, String proxy, String passwd, @NonNull long timeout) throws Exception {
        long ret;
        String configPath = this.cpService.getWxCpConfigStorage().getMsgAuditLibPath();
        if (StringUtils.isEmpty((CharSequence)configPath)) {
            throw new WxErrorException("\u8bf7\u914d\u7f6e\u4f1a\u8bdd\u5b58\u6863sdk\u6587\u4ef6\u7684\u8def\u5f84\uff0c\u4e0d\u8981\u914d\u9519\u4e86\uff01\uff01");
        }
        String replacePath = configPath.replace("\\", "/");
        int lastIndex = replacePath.lastIndexOf("/") + 1;
        String prefixPath = replacePath.substring(0, lastIndex);
        String suffixFiles = replacePath.substring(lastIndex);
        String[] libFiles = suffixFiles.split(",");
        if (libFiles.length <= 0) {
            throw new WxErrorException("\u8bf7\u4ed4\u7ec6\u914d\u7f6e\u4f1a\u8bdd\u5b58\u6863\u6587\u4ef6\u8def\u5f84\uff01\uff01");
        }
        List<String> libList = Arrays.asList(libFiles);
        LinkedList<String> osLib = new LinkedList<String>();
        ArrayList fileLib = new ArrayList();
        libList.stream().forEach(s -> {
            if (s.contains("lib")) {
                osLib.add((String)s);
            } else {
                fileLib.add(s);
            }
        });
        osLib.addAll(fileLib);
        Finance.loadingLibraries(osLib, prefixPath);
        long sdk = Finance.NewSdk();
        String msgAuditSecret = this.cpService.getWxCpConfigStorage().getMsgAuditSecret();
        if (StringUtils.isEmpty((CharSequence)msgAuditSecret)) {
            msgAuditSecret = this.cpService.getWxCpConfigStorage().getCorpSecret();
        }
        if ((ret = (long)Finance.Init(sdk, this.cpService.getWxCpConfigStorage().getCorpId(), msgAuditSecret)) != 0L) {
            Finance.DestroySdk(sdk);
            throw new WxErrorException("init sdk err ret " + ret);
        }
        long slice = Finance.NewSlice();
        ret = Finance.GetChatData(sdk, seq, limit, proxy, passwd, timeout, slice);
        if (ret != 0L) {
            Finance.FreeSlice(slice);
            Finance.DestroySdk(sdk);
            throw new WxErrorException("getchatdata err ret " + ret);
        }
        String content = Finance.GetContentFromSlice(slice);
        Finance.FreeSlice(slice);
        WxCpChatDatas chatDatas = WxCpChatDatas.fromJson(content);
        if (chatDatas.getErrCode() != 0) {
            Finance.DestroySdk(sdk);
            throw new WxErrorException(chatDatas.toJson());
        }
        chatDatas.setSdk(sdk);
        return chatDatas;
    }

    @Override
    public WxCpChatModel getDecryptData(@NonNull long sdk, @NonNull WxCpChatDatas.WxCpChatData chatData, @NonNull Integer pkcs1) throws Exception {
        if (chatData == null) {
            throw new NullPointerException("chatData is marked non-null but is null");
        }
        if (pkcs1 == null) {
            throw new NullPointerException("pkcs1 is marked non-null but is null");
        }
        String plainText = this.decryptChatData(sdk, chatData, pkcs1);
        return WxCpChatModel.fromJson(plainText);
    }

    public String decryptChatData(long sdk, WxCpChatDatas.WxCpChatData chatData, Integer pkcs1) throws Exception {
        String priKey = this.cpService.getWxCpConfigStorage().getMsgAuditPriKey();
        if (StringUtils.isEmpty((CharSequence)priKey)) {
            throw new WxErrorException("\u8bf7\u914d\u7f6e\u4f1a\u8bdd\u5b58\u6863\u79c1\u94a5\u3010msgAuditPriKey\u3011");
        }
        String decryptByPriKey = WxCpCryptUtil.decryptPriKey(chatData.getEncryptRandomKey(), priKey, pkcs1);
        long msg = Finance.NewSlice();
        int ret = Finance.DecryptData(sdk, decryptByPriKey, chatData.getEncryptChatMsg(), msg);
        if (ret != 0) {
            Finance.FreeSlice(msg);
            Finance.DestroySdk(sdk);
            throw new WxErrorException("msg err ret " + ret);
        }
        String plainText = Finance.GetContentFromSlice(msg);
        Finance.FreeSlice(msg);
        return plainText;
    }

    @Override
    public String getChatPlainText(@NonNull long sdk, @NonNull WxCpChatDatas.WxCpChatData chatData, @NonNull Integer pkcs1) throws Exception {
        if (chatData == null) {
            throw new NullPointerException("chatData is marked non-null but is null");
        }
        if (pkcs1 == null) {
            throw new NullPointerException("pkcs1 is marked non-null but is null");
        }
        return this.decryptChatData(sdk, chatData, pkcs1);
    }

    @Override
    public void getMediaFile(@NonNull long sdk, @NonNull String sdkfileid, String proxy, String passwd, @NonNull long timeout, @NonNull String targetFilePath) throws WxErrorException {
        if (sdkfileid == null) {
            throw new NullPointerException("sdkfileid is marked non-null but is null");
        }
        if (targetFilePath == null) {
            throw new NullPointerException("targetFilePath is marked non-null but is null");
        }
        File targetFile = new File(targetFilePath);
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        this.getMediaFile(sdk, sdkfileid, proxy, passwd, timeout, (byte[] i) -> {
            try {
                FileOutputStream outputStream = new FileOutputStream(targetFile, true);
                outputStream.write((byte[])i);
                outputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void getMediaFile(@NonNull long sdk, @NonNull String sdkfileid, String proxy, String passwd, @NonNull long timeout, @NonNull Consumer<byte[]> action) throws WxErrorException {
        long mediaData;
        if (sdkfileid == null) {
            throw new NullPointerException("sdkfileid is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        String indexbuf = "";
        int data_len = 0;
        log.debug("\u6b63\u5728\u5206\u7247\u62c9\u53d6\u5a92\u4f53\u6587\u4ef6 sdkFileId\u4e3a{}", (Object)sdkfileid);
        while (true) {
            int ret;
            if ((ret = Finance.GetMediaData(sdk, indexbuf, sdkfileid, proxy, passwd, timeout, mediaData = Finance.NewMediaData())) != 0) {
                Finance.FreeMediaData(mediaData);
                Finance.DestroySdk(sdk);
                throw new WxErrorException("getmediadata err ret " + ret);
            }
            log.info("\u6b63\u5728\u5206\u7247\u62c9\u53d6\u5a92\u4f53\u6587\u4ef6 len:{}, data_len:{}, is_finis:{} \n", new Object[]{Finance.GetIndexLen(mediaData), data_len += Finance.GetDataLen(mediaData), Finance.IsMediaDataFinish(mediaData)});
            try {
                action.accept(Finance.GetData(mediaData));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (Finance.IsMediaDataFinish(mediaData) == 1) break;
            indexbuf = Finance.GetOutIndexBuf(mediaData);
            Finance.FreeMediaData(mediaData);
        }
        Finance.FreeMediaData(mediaData);
    }

    @Override
    public List<String> getPermitUserList(Integer type) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/msgaudit/get_permit_user_list");
        JsonObject jsonObject = new JsonObject();
        if (type != null) {
            jsonObject.addProperty("type", (Number)type);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return (List)WxCpGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)responseContent).getAsJsonArray("ids"), new TypeToken<List<String>>(){}.getType());
    }

    @Override
    public WxCpGroupChat getGroupChat(@NonNull String roomid) throws WxErrorException {
        if (roomid == null) {
            throw new NullPointerException("roomid is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/msgaudit/groupchat/get");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("roomid", roomid);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpGroupChat.fromJson(responseContent);
    }

    @Override
    public WxCpAgreeInfo checkSingleAgree(@NonNull WxCpCheckAgreeRequest checkAgreeRequest) throws WxErrorException {
        if (checkAgreeRequest == null) {
            throw new NullPointerException("checkAgreeRequest is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/msgaudit/check_single_agree");
        String responseContent = this.cpService.post(apiUrl, checkAgreeRequest.toJson());
        return WxCpAgreeInfo.fromJson(responseContent);
    }

    public WxCpMsgAuditServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

