/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpSchoolService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.living.WxCpLivingResult;
import me.chanjar.weixin.cp.bean.school.WxCpCustomizeHealthInfo;
import me.chanjar.weixin.cp.bean.school.WxCpPaymentResult;
import me.chanjar.weixin.cp.bean.school.WxCpResultList;
import me.chanjar.weixin.cp.bean.school.WxCpSchoolLivingInfo;
import me.chanjar.weixin.cp.bean.school.WxCpSchoolUnwatchStat;
import me.chanjar.weixin.cp.bean.school.WxCpSchoolWatchStat;
import me.chanjar.weixin.cp.bean.school.WxCpTrade;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpSchoolServiceImpl
implements WxCpSchoolService {
    private static final Logger log = LoggerFactory.getLogger(WxCpSchoolServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpCustomizeHealthInfo getTeacherCustomizeHealthInfo(String date, String nextKey, Integer limit) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/get_teacher_customize_health_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("date", date);
        jsonObject.addProperty("limit", (Number)Optional.ofNullable(limit).orElse(100));
        if (nextKey != null) {
            jsonObject.addProperty("next_key", nextKey);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpCustomizeHealthInfo.fromJson(responseContent);
    }

    @Override
    public WxCpCustomizeHealthInfo getStudentCustomizeHealthInfo(String date, String nextKey, Integer limit) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/get_student_customize_health_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("date", date);
        jsonObject.addProperty("limit", (Number)Optional.ofNullable(limit).orElse(100));
        if (nextKey != null) {
            jsonObject.addProperty("next_key", nextKey);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpCustomizeHealthInfo.fromJson(responseContent);
    }

    @Override
    public WxCpResultList getHealthQrCode(List<String> userIds, Integer type) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/get_health_qrcode");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", (Number)type);
        jsonObject.addProperty("userids", userIds.toString());
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpResultList.fromJson(responseContent);
    }

    @Override
    public WxCpPaymentResult getPaymentResult(String paymentId) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/get_payment_result");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("payment_id", paymentId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpPaymentResult.fromJson(responseContent);
    }

    @Override
    public WxCpTrade getTrade(String paymentId, String tradeNo) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/get_trade");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("payment_id", paymentId);
        jsonObject.addProperty("trade_no", tradeNo);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpTrade.fromJson(responseContent);
    }

    @Override
    public WxCpSchoolLivingInfo getLivingInfo(String livingId) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/living/get_living_info?livingid=") + livingId;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpSchoolLivingInfo.fromJson(responseContent);
    }

    @Override
    public WxCpLivingResult.LivingIdResult getUserAllLivingId(String userId, String cursor, Integer limit) throws WxErrorException {
        return this.cpService.getLivingService().getUserAllLivingId(userId, cursor, limit);
    }

    @Override
    public WxCpSchoolWatchStat getWatchStat(String livingId, String nextKey) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/living/get_watch_stat");
        JsonObject jsonObject = new JsonObject();
        if (StringUtils.isNotBlank((CharSequence)nextKey)) {
            jsonObject.addProperty("next_key", nextKey);
        }
        jsonObject.addProperty("livingid", livingId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpSchoolWatchStat.fromJson(responseContent);
    }

    @Override
    public WxCpSchoolUnwatchStat getUnwatchStat(String livingId, String nextKey) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/living/get_unwatch_stat");
        JsonObject jsonObject = new JsonObject();
        if (StringUtils.isNotBlank((CharSequence)nextKey)) {
            jsonObject.addProperty("next_key", nextKey);
        }
        jsonObject.addProperty("livingid", livingId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpSchoolUnwatchStat.fromJson(responseContent);
    }

    @Override
    public WxCpLivingResult deleteReplayData(String livingId) throws WxErrorException {
        return this.cpService.getLivingService().deleteReplayData(livingId);
    }

    public WxCpSchoolServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

