/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpOaMeetingRoomService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoom;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomBookByMeetingRequest;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomBookByScheduleRequest;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomBookRequest;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomBookResult;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomBookingInfoByBookingIdRequest;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomBookingInfoByBookingIdResult;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomBookingInfoRequest;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomBookingInfoResult;
import me.chanjar.weixin.cp.bean.oa.meetingroom.WxCpOaMeetingRoomCancelBookRequest;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpOaMeetingRoomServiceImpl
implements WxCpOaMeetingRoomService {
    private final WxCpService wxCpService;

    @Override
    public String addMeetingRoom(WxCpOaMeetingRoom meetingRoom) throws WxErrorException {
        return this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/add"), meetingRoom);
    }

    @Override
    public List<WxCpOaMeetingRoom> listMeetingRoom(WxCpOaMeetingRoom meetingRoomRequest) throws WxErrorException {
        String response = this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/list"), meetingRoomRequest);
        return (List)WxCpGsonBuilder.create().fromJson(GsonParser.parse((String)response).get("meetingroom_list").getAsJsonArray().toString(), new TypeToken<List<WxCpOaMeetingRoom>>(){}.getType());
    }

    @Override
    public void editMeetingRoom(WxCpOaMeetingRoom meetingRoom) throws WxErrorException {
        this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/edit"), meetingRoom);
    }

    @Override
    public void deleteMeetingRoom(Integer meetingRoomId) throws WxErrorException {
        this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/del"), GsonHelper.buildJsonObject((Object[])new Object[]{"meetingroom_id", meetingRoomId}));
    }

    @Override
    public WxCpOaMeetingRoomBookingInfoResult getMeetingRoomBookingInfo(WxCpOaMeetingRoomBookingInfoRequest wxCpOaMeetingRoomBookingInfoRequest) throws WxErrorException {
        String response = this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/get_booking_info"), wxCpOaMeetingRoomBookingInfoRequest);
        return WxCpOaMeetingRoomBookingInfoResult.fromJson(response);
    }

    @Override
    public WxCpOaMeetingRoomBookResult bookingMeetingRoom(WxCpOaMeetingRoomBookRequest wxCpOaMeetingRoomBookRequest) throws WxErrorException {
        String response = this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/book"), wxCpOaMeetingRoomBookRequest);
        return WxCpOaMeetingRoomBookResult.fromJson(response);
    }

    @Override
    public WxCpOaMeetingRoomBookResult bookingMeetingRoomBySchedule(WxCpOaMeetingRoomBookByScheduleRequest wxCpOaMeetingRoomBookByScheduleRequest) throws WxErrorException {
        String response = this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/book_by_schedule"), wxCpOaMeetingRoomBookByScheduleRequest);
        return WxCpOaMeetingRoomBookResult.fromJson(response);
    }

    @Override
    public WxCpOaMeetingRoomBookResult bookingMeetingRoomByMeeting(WxCpOaMeetingRoomBookByMeetingRequest wxCpOaMeetingRoomBookByMeetingRequest) throws WxErrorException {
        String response = this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom//book_by_meeting"), wxCpOaMeetingRoomBookByMeetingRequest);
        return WxCpOaMeetingRoomBookResult.fromJson(response);
    }

    @Override
    public void cancelBookMeetingRoom(WxCpOaMeetingRoomCancelBookRequest wxCpOaMeetingRoomCancelBookRequest) throws WxErrorException {
        this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/cancel_book"), wxCpOaMeetingRoomCancelBookRequest);
    }

    @Override
    public WxCpOaMeetingRoomBookingInfoByBookingIdResult getBookingInfoByBookingId(WxCpOaMeetingRoomBookingInfoByBookingIdRequest wxCpOaMeetingRoomBookingInfoByBookingIdRequest) throws WxErrorException {
        String response = this.wxCpService.post(this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/meetingroom/bookinfo/get"), wxCpOaMeetingRoomBookingInfoByBookingIdRequest);
        return WxCpOaMeetingRoomBookingInfoByBookingIdResult.fromJson(response);
    }

    public WxCpOaMeetingRoomServiceImpl(WxCpService wxCpService) {
        this.wxCpService = wxCpService;
    }
}

