/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.common.util.http.hc5.ApacheBasicResponseHandler;
import me.chanjar.weixin.common.util.http.hc5.DefaultApacheHttpClientBuilder;
import me.chanjar.weixin.cp.api.impl.BaseWxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class WxCpServiceApacheHttpClient5Impl
extends BaseWxCpServiceImpl<CloseableHttpClient, HttpHost> {
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.APACHE_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isAccessTokenExpired() && !forceRefresh) {
            return this.configStorage.getAccessToken();
        }
        Object object = this.globalAccessTokenRefreshLock;
        synchronized (object) {
            String url = String.format(this.configStorage.getApiUrl("/cgi-bin/gettoken?corpid=%s&corpsecret=%s"), this.configStorage.getCorpId(), this.configStorage.getCorpSecret());
            try {
                String resultContent;
                WxError error;
                HttpGet httpGet = new HttpGet(url);
                if (this.httpProxy != null) {
                    RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
                    httpGet.setConfig(config);
                }
                if ((error = WxError.fromJson((String)(resultContent = (String)this.getRequestHttpClient().execute((ClassicHttpRequest)httpGet, (HttpClientResponseHandler)ApacheBasicResponseHandler.INSTANCE)), (WxType)WxType.CP)).getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                this.configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
            catch (IOException e) {
                throw new WxRuntimeException((Throwable)e);
            }
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public void initHttp() {
        DefaultApacheHttpClientBuilder apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        apacheHttpClientBuilder.httpProxyHost(this.configStorage.getHttpProxyHost()).httpProxyPort(this.configStorage.getHttpProxyPort()).httpProxyUsername(this.configStorage.getHttpProxyUsername()).httpProxyPassword(this.configStorage.getHttpProxyPassword().toCharArray());
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    @Override
    public WxCpConfigStorage getWxCpConfigStorage() {
        return this.configStorage;
    }
}

