/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.config.impl;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.cp.bean.WxCpProviderToken;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.apache.commons.lang3.StringUtils;

public class WxCpTpRedissonConfigImpl
implements WxCpTpConfigStorage,
Serializable {
    private static final long serialVersionUID = -5385639031981770319L;
    protected static final String LOCK_KEY = "wechat_tp_lock:";
    protected static final String LOCKER_PROVIDER_ACCESS_TOKEN = "providerAccessTokenLock";
    protected static final String LOCKER_SUITE_ACCESS_TOKEN = "suiteAccessTokenLock";
    protected static final String LOCKER_ACCESS_TOKEN = "accessTokenLock";
    protected static final String LOCKER_CORP_JSAPI_TICKET = "corpJsapiTicketLock";
    protected static final String LOCKER_SUITE_JSAPI_TICKET = "suiteJsapiTicketLock";
    @NonNull
    private final WxRedisOps wxRedisOps;
    private final String suiteAccessTokenKey = ":suiteAccessTokenKey:";
    private final String suiteTicketKey = ":suiteTicketKey:";
    private final String accessTokenKey = ":accessTokenKey:";
    private final String authCorpJsApiTicketKey = ":authCorpJsApiTicketKey:";
    private final String authSuiteJsApiTicketKey = ":authSuiteJsApiTicketKey:";
    private final String providerTokenKey = ":providerTokenKey:";
    private String keyPrefix = "";
    private volatile String baseApiUrl;
    private volatile String httpProxyHost;
    private volatile int httpProxyPort;
    private volatile String httpProxyUsername;
    private volatile String httpProxyPassword;
    private volatile ApacheHttpClientBuilder apacheHttpClientBuilder;
    private volatile File tmpDirFile;
    private volatile String suiteId;
    private volatile String suiteSecret;
    private volatile String token;
    private volatile String aesKey;
    private volatile String corpId;
    private volatile String corpSecret;
    private volatile String providerSecret;

    @Override
    public void setBaseApiUrl(String baseUrl) {
        this.baseApiUrl = baseUrl;
    }

    @Override
    public String getApiUrl(String path) {
        if (this.baseApiUrl == null) {
            this.baseApiUrl = "https://qyapi.weixin.qq.com";
        }
        return this.baseApiUrl + path;
    }

    @Override
    public String getSuiteAccessToken() {
        return this.wxRedisOps.getValue(this.keyWithPrefix(":suiteAccessTokenKey:"));
    }

    @Override
    public WxAccessToken getSuiteAccessTokenEntity() {
        String suiteAccessToken = this.wxRedisOps.getValue(this.keyWithPrefix(":suiteAccessTokenKey:"));
        Long expireIn = this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteAccessTokenKey:"));
        if (StringUtils.isBlank((CharSequence)suiteAccessToken) || expireIn == null || expireIn == 0L || expireIn == -2L) {
            return new WxAccessToken();
        }
        WxAccessToken suiteAccessTokenEntity = new WxAccessToken();
        suiteAccessTokenEntity.setAccessToken(suiteAccessToken);
        suiteAccessTokenEntity.setExpiresIn(Math.max(Math.toIntExact(expireIn), 0));
        return suiteAccessTokenEntity;
    }

    @Override
    public boolean isSuiteAccessTokenExpired() {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteAccessTokenKey:")) == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteAccessTokenKey:")) == -2L;
    }

    @Override
    public void expireSuiteAccessToken() {
        this.wxRedisOps.expire(this.keyWithPrefix(":suiteAccessTokenKey:"), 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateSuiteAccessToken(WxAccessToken suiteAccessToken) {
        this.updateSuiteAccessToken(suiteAccessToken.getAccessToken(), suiteAccessToken.getExpiresIn());
    }

    @Override
    public void updateSuiteAccessToken(String suiteAccessToken, int expiresInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(":suiteAccessTokenKey:"), suiteAccessToken, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getSuiteTicket() {
        return this.wxRedisOps.getValue(this.keyWithPrefix(":suiteTicketKey:"));
    }

    @Override
    public boolean isSuiteTicketExpired() {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteTicketKey:")) == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(":suiteTicketKey:")) == -2L;
    }

    @Override
    public void expireSuiteTicket() {
        this.wxRedisOps.expire(this.keyWithPrefix(":suiteTicketKey:"), 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateSuiteTicket(String suiteTicket, int expiresInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(":suiteTicketKey:"), suiteTicket, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getSuiteId() {
        return this.suiteId;
    }

    @Override
    public String getSuiteSecret() {
        return this.suiteSecret;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getAesKey() {
        return this.aesKey;
    }

    @Override
    public String getCorpId() {
        return this.corpId;
    }

    @Override
    public String getCorpSecret() {
        return this.corpSecret;
    }

    @Override
    public void setProviderSecret(String providerSecret) {
        this.providerSecret = providerSecret;
    }

    @Override
    public String getProviderSecret() {
        return this.providerSecret;
    }

    @Override
    public String getAccessToken(String authCorpId) {
        return this.wxRedisOps.getValue(this.keyWithPrefix(authCorpId) + ":accessTokenKey:");
    }

    @Override
    public WxAccessToken getAccessTokenEntity(String authCorpId) {
        String accessToken = this.wxRedisOps.getValue(this.keyWithPrefix(authCorpId) + ":accessTokenKey:");
        Long expire = this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":accessTokenKey:");
        if (StringUtils.isBlank((CharSequence)accessToken) || expire == null || expire == 0L || expire == -2L) {
            return new WxAccessToken();
        }
        WxAccessToken accessTokenEntity = new WxAccessToken();
        accessTokenEntity.setAccessToken(accessToken);
        accessTokenEntity.setExpiresIn((int)((expire - System.currentTimeMillis()) / 1000L + 200L));
        return accessTokenEntity;
    }

    @Override
    public boolean isAccessTokenExpired(String authCorpId) {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":accessTokenKey:") == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":accessTokenKey:") == -2L;
    }

    @Override
    public void expireAccessToken(String authCorpId) {
        this.wxRedisOps.expire(this.keyWithPrefix(authCorpId) + ":accessTokenKey:", 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateAccessToken(String authCorpId, String accessToken, int expiredInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(authCorpId) + ":accessTokenKey:", accessToken, expiredInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getAuthCorpJsApiTicket(String authCorpId) {
        return this.wxRedisOps.getValue(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:");
    }

    @Override
    public boolean isAuthCorpJsApiTicketExpired(String authCorpId) {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:") == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:") == -2L;
    }

    @Override
    public void expireAuthCorpJsApiTicket(String authCorpId) {
        this.wxRedisOps.expire(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:", 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateAuthCorpJsApiTicket(String authCorpId, String jsApiTicket, int expiredInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(authCorpId) + ":authCorpJsApiTicketKey:", jsApiTicket, expiredInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getAuthSuiteJsApiTicket(String authCorpId) {
        return this.wxRedisOps.getValue(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:");
    }

    @Override
    public boolean isAuthSuiteJsApiTicketExpired(String authCorpId) {
        return this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:") == 0L || this.wxRedisOps.getExpire(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:") == -2L;
    }

    @Override
    public void expireAuthSuiteJsApiTicket(String authCorpId) {
        this.wxRedisOps.expire(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:", 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateAuthSuiteJsApiTicket(String authCorpId, String jsApiTicket, int expiredInSeconds) {
        this.wxRedisOps.setValue(this.keyWithPrefix(authCorpId) + ":authSuiteJsApiTicketKey:", jsApiTicket, expiredInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean isProviderTokenExpired() {
        return this.wxRedisOps.getExpire(this.providerKeyWithPrefix(":providerTokenKey:")) == 0L || this.wxRedisOps.getExpire(this.providerKeyWithPrefix(":providerTokenKey:")) == -2L;
    }

    @Override
    public void updateProviderToken(String providerToken, int expiredInSeconds) {
        this.wxRedisOps.setValue(this.providerKeyWithPrefix(":providerTokenKey:"), providerToken, expiredInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getProviderToken() {
        return this.wxRedisOps.getValue(this.providerKeyWithPrefix(":providerTokenKey:"));
    }

    @Override
    public WxCpProviderToken getProviderTokenEntity() {
        String providerToken = this.wxRedisOps.getValue(this.providerKeyWithPrefix(":providerTokenKey:"));
        Long expire = this.wxRedisOps.getExpire(this.providerKeyWithPrefix(":providerTokenKey:"));
        if (StringUtils.isBlank((CharSequence)providerToken) || expire == null || expire == 0L || expire == -2L) {
            return new WxCpProviderToken();
        }
        WxCpProviderToken wxCpProviderToken = new WxCpProviderToken();
        wxCpProviderToken.setProviderAccessToken(providerToken);
        wxCpProviderToken.setExpiresIn(Math.max(Math.toIntExact(expire), 0));
        return wxCpProviderToken;
    }

    @Override
    public void expireProviderToken() {
        this.wxRedisOps.expire(this.providerKeyWithPrefix(":providerTokenKey:"), 0, TimeUnit.SECONDS);
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Override
    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    @Override
    public Lock getProviderAccessTokenLock() {
        return this.getProviderLockByKey(String.join((CharSequence)":", this.corpId, LOCKER_PROVIDER_ACCESS_TOKEN));
    }

    @Override
    public Lock getSuiteAccessTokenLock() {
        return this.getLockByKey(LOCKER_SUITE_ACCESS_TOKEN);
    }

    @Override
    public Lock getAccessTokenLock(String authCorpId) {
        return this.getLockByKey(String.join((CharSequence)":", authCorpId, LOCKER_ACCESS_TOKEN));
    }

    @Override
    public Lock getAuthCorpJsapiTicketLock(String authCorpId) {
        return this.getLockByKey(String.join((CharSequence)":", authCorpId, LOCKER_CORP_JSAPI_TICKET));
    }

    @Override
    public Lock getSuiteJsapiTicketLock(String authCorpId) {
        return this.getLockByKey(String.join((CharSequence)":", authCorpId, LOCKER_SUITE_JSAPI_TICKET));
    }

    private Lock getLockByKey(String key) {
        return this.wxRedisOps.getLock(String.join((CharSequence)":", this.keyWithPrefix(LOCK_KEY + this.suiteId), key));
    }

    private Lock getProviderLockByKey(String key) {
        return this.wxRedisOps.getLock(String.join((CharSequence)":", this.providerKeyWithPrefix(LOCK_KEY), key));
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    @Override
    public boolean autoRefreshToken() {
        return false;
    }

    public String toString() {
        return WxCpGsonBuilder.create().toJson((Object)this);
    }

    private String keyWithPrefix(String key) {
        return this.keyPrefix + ":" + this.suiteId + ":" + key;
    }

    private String providerKeyWithPrefix(String key) {
        return this.keyPrefix + ":" + this.corpId + ":" + key;
    }

    WxCpTpRedissonConfigImpl(@NonNull WxRedisOps wxRedisOps, String keyPrefix, String baseApiUrl, String httpProxyHost, int httpProxyPort, String httpProxyUsername, String httpProxyPassword, ApacheHttpClientBuilder apacheHttpClientBuilder, File tmpDirFile, String suiteId, String suiteSecret, String token, String aesKey, String corpId, String corpSecret, String providerSecret) {
        if (wxRedisOps == null) {
            throw new NullPointerException("wxRedisOps is marked non-null but is null");
        }
        this.wxRedisOps = wxRedisOps;
        this.keyPrefix = keyPrefix;
        this.baseApiUrl = baseApiUrl;
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.httpProxyUsername = httpProxyUsername;
        this.httpProxyPassword = httpProxyPassword;
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
        this.tmpDirFile = tmpDirFile;
        this.suiteId = suiteId;
        this.suiteSecret = suiteSecret;
        this.token = token;
        this.aesKey = aesKey;
        this.corpId = corpId;
        this.corpSecret = corpSecret;
        this.providerSecret = providerSecret;
    }

    public static WxCpTpRedissonConfigImplBuilder builder() {
        return new WxCpTpRedissonConfigImplBuilder();
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public static class WxCpTpRedissonConfigImplBuilder {
        private WxRedisOps wxRedisOps;
        private String keyPrefix;
        private String baseApiUrl;
        private String httpProxyHost;
        private int httpProxyPort;
        private String httpProxyUsername;
        private String httpProxyPassword;
        private ApacheHttpClientBuilder apacheHttpClientBuilder;
        private File tmpDirFile;
        private String suiteId;
        private String suiteSecret;
        private String token;
        private String aesKey;
        private String corpId;
        private String corpSecret;
        private String providerSecret;

        WxCpTpRedissonConfigImplBuilder() {
        }

        public WxCpTpRedissonConfigImplBuilder wxRedisOps(@NonNull WxRedisOps wxRedisOps) {
            if (wxRedisOps == null) {
                throw new NullPointerException("wxRedisOps is marked non-null but is null");
            }
            this.wxRedisOps = wxRedisOps;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder baseApiUrl(String baseApiUrl) {
            this.baseApiUrl = baseApiUrl;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder httpProxyHost(String httpProxyHost) {
            this.httpProxyHost = httpProxyHost;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder httpProxyPort(int httpProxyPort) {
            this.httpProxyPort = httpProxyPort;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder httpProxyUsername(String httpProxyUsername) {
            this.httpProxyUsername = httpProxyUsername;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder httpProxyPassword(String httpProxyPassword) {
            this.httpProxyPassword = httpProxyPassword;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder apacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
            this.apacheHttpClientBuilder = apacheHttpClientBuilder;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder tmpDirFile(File tmpDirFile) {
            this.tmpDirFile = tmpDirFile;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder suiteId(String suiteId) {
            this.suiteId = suiteId;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder suiteSecret(String suiteSecret) {
            this.suiteSecret = suiteSecret;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder token(String token) {
            this.token = token;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder aesKey(String aesKey) {
            this.aesKey = aesKey;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder corpId(String corpId) {
            this.corpId = corpId;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder corpSecret(String corpSecret) {
            this.corpSecret = corpSecret;
            return this;
        }

        public WxCpTpRedissonConfigImplBuilder providerSecret(String providerSecret) {
            this.providerSecret = providerSecret;
            return this;
        }

        public WxCpTpRedissonConfigImpl build() {
            return new WxCpTpRedissonConfigImpl(this.wxRedisOps, this.keyPrefix, this.baseApiUrl, this.httpProxyHost, this.httpProxyPort, this.httpProxyUsername, this.httpProxyPassword, this.apacheHttpClientBuilder, this.tmpDirFile, this.suiteId, this.suiteSecret, this.token, this.aesKey, this.corpId, this.corpSecret, this.providerSecret);
        }

        public String toString() {
            return "WxCpTpRedissonConfigImpl.WxCpTpRedissonConfigImplBuilder(wxRedisOps=" + this.wxRedisOps + ", keyPrefix=" + this.keyPrefix + ", baseApiUrl=" + this.baseApiUrl + ", httpProxyHost=" + this.httpProxyHost + ", httpProxyPort=" + this.httpProxyPort + ", httpProxyUsername=" + this.httpProxyUsername + ", httpProxyPassword=" + this.httpProxyPassword + ", apacheHttpClientBuilder=" + this.apacheHttpClientBuilder + ", tmpDirFile=" + this.tmpDirFile + ", suiteId=" + this.suiteId + ", suiteSecret=" + this.suiteSecret + ", token=" + this.token + ", aesKey=" + this.aesKey + ", corpId=" + this.corpId + ", corpSecret=" + this.corpSecret + ", providerSecret=" + this.providerSecret + ")";
        }
    }
}

