/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.WxCpTpConvertTmpExternalUserIdResult;
import me.chanjar.weixin.cp.bean.WxCpTpOpenKfIdConvertResult;
import me.chanjar.weixin.cp.bean.WxCpTpTagIdListConvertResult;
import me.chanjar.weixin.cp.bean.WxCpTpUnionidToExternalUseridResult;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import me.chanjar.weixin.cp.tp.service.WxCpTpIdConvertService;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;

public class WxCpTpIdConvertServiceImpl
implements WxCpTpIdConvertService {
    private final WxCpTpService mainService;

    @Override
    public WxCpTpUnionidToExternalUseridResult unionidToExternalUserid(String cropId, String unionid, String openid, Integer subjectType) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("unionid", unionid);
        json.addProperty("openid", openid);
        if (subjectType != null) {
            json.addProperty("subject_type", (Number)subjectType);
        }
        WxCpTpConfigStorage wxCpTpConfigStorage = this.mainService.getWxCpTpConfigStorage();
        String accessToken = wxCpTpConfigStorage.getAccessToken(cropId);
        String url = wxCpTpConfigStorage.getApiUrl("/cgi-bin/idconvert/unionid_to_external_userid");
        url = url + "?access_token=" + accessToken;
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpTpUnionidToExternalUseridResult.fromJson(responseContent);
    }

    @Override
    public WxCpTpTagIdListConvertResult externalTagId(String corpId, String ... externalTagIdList) throws WxErrorException {
        WxCpTpConfigStorage wxCpTpConfigStorage = this.mainService.getWxCpTpConfigStorage();
        String url = wxCpTpConfigStorage.getApiUrl("/cgi-bin/idconvert/external_tagid") + "?access_token=" + this.mainService.getWxCpTpConfigStorage().getAccessToken(corpId);
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (String tagId : externalTagIdList) {
            jsonArray.add((JsonElement)new JsonPrimitive(tagId));
        }
        jsonObject.add("external_tagid_list", (JsonElement)jsonArray);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return WxCpTpTagIdListConvertResult.fromJson(responseContent);
    }

    @Override
    public WxCpTpOpenKfIdConvertResult ConvertOpenKfId(String corpId, String ... openKfIdList) throws WxErrorException {
        WxCpTpConfigStorage wxCpTpConfigStorage = this.mainService.getWxCpTpConfigStorage();
        String url = wxCpTpConfigStorage.getApiUrl("/cgi-bin/idconvert/open_kfid?access_token=" + this.mainService.getWxCpTpConfigStorage().getAccessToken(corpId));
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (String kfId : openKfIdList) {
            jsonArray.add((JsonElement)new JsonPrimitive(kfId));
        }
        jsonObject.add("open_kfid_list", (JsonElement)jsonArray);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return WxCpTpOpenKfIdConvertResult.fromJson(responseContent);
    }

    @Override
    public WxCpTpConvertTmpExternalUserIdResult convertTmpExternalUserId(String corpId, int businessType, int userType, String ... tmpExternalUserIdList) throws WxErrorException {
        WxCpTpConfigStorage wxCpTpConfigStorage = this.mainService.getWxCpTpConfigStorage();
        String url = wxCpTpConfigStorage.getApiUrl("/cgi-bin/idconvert/convert_tmp_external_userid?access_token=" + this.mainService.getWxCpTpConfigStorage().getAccessToken(corpId));
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.addProperty("business_type", (Number)businessType);
        jsonObject.addProperty("user_type", (Number)userType);
        for (String userId : tmpExternalUserIdList) {
            jsonArray.add((JsonElement)new JsonPrimitive(userId));
        }
        jsonObject.add("tmp_external_userid_list", (JsonElement)jsonArray);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return WxCpTpConvertTmpExternalUserIdResult.fromJson(responseContent);
    }

    public WxCpTpIdConvertServiceImpl(WxCpTpService mainService) {
        this.mainService = mainService;
    }
}

