/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpIntelligentRobotService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.intelligentrobot.WxCpIntelligentRobot;
import me.chanjar.weixin.cp.bean.intelligentrobot.WxCpIntelligentRobotChatRequest;
import me.chanjar.weixin.cp.bean.intelligentrobot.WxCpIntelligentRobotChatResponse;
import me.chanjar.weixin.cp.bean.intelligentrobot.WxCpIntelligentRobotCreateRequest;
import me.chanjar.weixin.cp.bean.intelligentrobot.WxCpIntelligentRobotCreateResponse;
import me.chanjar.weixin.cp.bean.intelligentrobot.WxCpIntelligentRobotUpdateRequest;

public class WxCpIntelligentRobotServiceImpl
implements WxCpIntelligentRobotService {
    private final WxCpService cpService;

    @Override
    public WxCpIntelligentRobotCreateResponse createRobot(WxCpIntelligentRobotCreateRequest request) throws WxErrorException {
        String responseText = this.cpService.post("/cgi-bin/intelligent_robot/create", request.toJson());
        return WxCpIntelligentRobotCreateResponse.fromJson(responseText);
    }

    @Override
    public void deleteRobot(String robotId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("robot_id", robotId);
        this.cpService.post("/cgi-bin/intelligent_robot/delete", jsonObject.toString());
    }

    @Override
    public void updateRobot(WxCpIntelligentRobotUpdateRequest request) throws WxErrorException {
        this.cpService.post("/cgi-bin/intelligent_robot/update", request.toJson());
    }

    @Override
    public WxCpIntelligentRobot getRobot(String robotId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("robot_id", robotId);
        String responseText = this.cpService.post("/cgi-bin/intelligent_robot/get", jsonObject.toString());
        return WxCpIntelligentRobot.fromJson(responseText);
    }

    @Override
    public WxCpIntelligentRobotChatResponse chat(WxCpIntelligentRobotChatRequest request) throws WxErrorException {
        String responseText = this.cpService.post("/cgi-bin/intelligent_robot/chat", request.toJson());
        return WxCpIntelligentRobotChatResponse.fromJson(responseText);
    }

    @Override
    public void resetSession(String robotId, String userid, String sessionId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("robot_id", robotId);
        jsonObject.addProperty("userid", userid);
        jsonObject.addProperty("session_id", sessionId);
        this.cpService.post("/cgi-bin/intelligent_robot/reset_session", jsonObject.toString());
    }

    public WxCpIntelligentRobotServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

