/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.JsonObject;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.tp.service.impl.BaseWxCpTpServiceImpl;

public class WxCpTpServiceJoddHttpImpl
extends BaseWxCpTpServiceImpl<HttpConnectionProvider, ProxyInfo> {
    private HttpConnectionProvider httpClient;
    private ProxyInfo httpProxy;

    public HttpConnectionProvider getRequestHttpClient() {
        return this.httpClient;
    }

    public ProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.JODD_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSuiteAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isSuiteAccessTokenExpired() && !forceRefresh) {
            return this.configStorage.getSuiteAccessToken();
        }
        Object object = this.globalSuiteAccessTokenRefreshLock;
        synchronized (object) {
            String url = this.configStorage.getApiUrl("/cgi-bin/service/get_suite_token");
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("suite_id", this.configStorage.getSuiteId());
            jsonObject.addProperty("suite_secret", this.configStorage.getSuiteSecret());
            jsonObject.addProperty("suite_ticket", this.getSuiteTicket());
            String jsonBody = jsonObject.toString();
            if (this.httpProxy != null) {
                this.httpClient.useProxy(this.httpProxy);
            }
            HttpRequest request = (HttpRequest)((HttpRequest)HttpRequest.post((String)url).contentType("application/json")).body(jsonBody);
            request.withConnectionProvider(this.httpClient);
            HttpResponse response = request.send();
            String resultContent = response.bodyText();
            WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            jsonObject = GsonParser.parse((String)resultContent);
            String suiteAccussToken = jsonObject.get("suite_access_token").getAsString();
            int expiresIn = jsonObject.get("expires_in").getAsInt();
            this.configStorage.updateSuiteAccessToken(suiteAccussToken, expiresIn);
        }
        return this.configStorage.getSuiteAccessToken();
    }

    @Override
    public void initHttp() {
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort(), this.configStorage.getHttpProxyUsername(), this.configStorage.getHttpProxyPassword());
        }
        this.httpClient = new SocketHttpConnectionProvider();
    }
}

