/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Date;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.mp.api.WxMpKefuService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.request.WxMpKfAccountRequest;
import me.chanjar.weixin.mp.bean.kefu.request.WxMpKfSessionRequest;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfMsgList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfOnlineList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionGetResult;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionWaitCaseList;

public class WxMpKefuServiceImpl
implements WxMpKefuService {
    private static final String API_URL_PREFIX = "https://api.weixin.qq.com/customservice";
    private WxMpService wxMpService;

    public WxMpKefuServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxMpKfList kfList() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/customservice/getkflist";
        String responseContent = (String)this.wxMpService.execute(new SimpleGetRequestExecutor(), url, null);
        return WxMpKfList.fromJson(responseContent);
    }

    @Override
    public WxMpKfOnlineList kfOnlineList() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/customservice/getonlinekflist";
        String responseContent = (String)this.wxMpService.execute(new SimpleGetRequestExecutor(), url, null);
        return WxMpKfOnlineList.fromJson(responseContent);
    }

    @Override
    public boolean kfAccountAdd(WxMpKfAccountRequest request) throws WxErrorException {
        String url = "https://api.weixin.qq.com/customservice/kfaccount/add";
        this.wxMpService.execute(new SimplePostRequestExecutor(), url, request.toJson());
        return true;
    }

    @Override
    public boolean kfAccountUpdate(WxMpKfAccountRequest request) throws WxErrorException {
        String url = "https://api.weixin.qq.com/customservice/kfaccount/update";
        this.wxMpService.execute(new SimplePostRequestExecutor(), url, request.toJson());
        return true;
    }

    @Override
    public boolean kfAccountInviteWorker(WxMpKfAccountRequest request) throws WxErrorException {
        String url = "https://api.weixin.qq.com/customservice/kfaccount/inviteworker";
        this.wxMpService.execute(new SimplePostRequestExecutor(), url, request.toJson());
        return true;
    }

    @Override
    public boolean kfAccountUploadHeadImg(String kfAccount, File imgFile) throws WxErrorException {
        String url = "https://api.weixin.qq.com/customservice/kfaccount/uploadheadimg?kf_account=" + kfAccount;
        this.wxMpService.execute(new MediaUploadRequestExecutor(), url, imgFile);
        return true;
    }

    @Override
    public boolean kfAccountDel(String kfAccount) throws WxErrorException {
        String url = "https://api.weixin.qq.com/customservice/kfaccount/del?kf_account=" + kfAccount;
        this.wxMpService.execute(new SimpleGetRequestExecutor(), url, null);
        return true;
    }

    @Override
    public boolean kfSessionCreate(String openid, String kfAccount) throws WxErrorException {
        WxMpKfSessionRequest request = new WxMpKfSessionRequest(kfAccount, openid);
        String url = "https://api.weixin.qq.com/customservice/kfsession/create";
        this.wxMpService.execute(new SimplePostRequestExecutor(), url, request.toJson());
        return true;
    }

    @Override
    public boolean kfSessionClose(String openid, String kfAccount) throws WxErrorException {
        WxMpKfSessionRequest request = new WxMpKfSessionRequest(kfAccount, openid);
        String url = "https://api.weixin.qq.com/customservice/kfsession/close";
        this.wxMpService.execute(new SimplePostRequestExecutor(), url, request.toJson());
        return true;
    }

    @Override
    public WxMpKfSessionGetResult kfSessionGet(String openid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/customservice/kfsession/getsession?openid=" + openid;
        String responseContent = (String)this.wxMpService.execute(new SimpleGetRequestExecutor(), url, null);
        return WxMpKfSessionGetResult.fromJson(responseContent);
    }

    @Override
    public WxMpKfSessionList kfSessionList(String kfAccount) throws WxErrorException {
        String url = "https://api.weixin.qq.com/customservice/kfsession/getsessionlist?kf_account=" + kfAccount;
        String responseContent = (String)this.wxMpService.execute(new SimpleGetRequestExecutor(), url, null);
        return WxMpKfSessionList.fromJson(responseContent);
    }

    @Override
    public WxMpKfSessionWaitCaseList kfSessionGetWaitCase() throws WxErrorException {
        String url = "https://api.weixin.qq.com/customservice/kfsession/getwaitcase";
        String responseContent = (String)this.wxMpService.execute(new SimpleGetRequestExecutor(), url, null);
        return WxMpKfSessionWaitCaseList.fromJson(responseContent);
    }

    @Override
    public WxMpKfMsgList kfMsgList(Date startTime, Date endTime, Long msgId, Integer number) throws WxErrorException {
        if (number > 10000) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u975e\u6cd5\u53c2\u6570\u8bf7\u6c42\uff0c\u6bcf\u6b21\u6700\u591a\u67e5\u8be210000\u6761\u8bb0\u5f55\uff01").build());
        }
        if (startTime.after(endTime)) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01").build());
        }
        String url = "https://api.weixin.qq.com/customservice/msgrecord/getmsglist";
        JsonObject param = new JsonObject();
        param.addProperty("starttime", (Number)(startTime.getTime() / 1000L));
        param.addProperty("endtime", (Number)(endTime.getTime() / 1000L));
        param.addProperty("msgid", (Number)msgId);
        param.addProperty("number", (Number)number);
        String responseContent = (String)this.wxMpService.execute(new SimplePostRequestExecutor(), url, param.toString());
        return WxMpKfMsgList.fromJson(responseContent);
    }

    @Override
    public WxMpKfMsgList kfMsgList(Date startTime, Date endTime) throws WxErrorException {
        int number = 10000;
        WxMpKfMsgList result = this.kfMsgList(startTime, endTime, 1L, number);
        if (result != null && result.getNumber() == number) {
            Long msgId = result.getMsgId();
            WxMpKfMsgList followingResult = this.kfMsgList(startTime, endTime, msgId, number);
            while (followingResult != null && followingResult.getRecords().size() > 0) {
                result.getRecords().addAll(followingResult.getRecords());
                result.setNumber(result.getNumber() + followingResult.getNumber());
                result.setMsgId(followingResult.getMsgId());
                followingResult = this.kfMsgList(startTime, endTime, followingResult.getMsgId(), number);
            }
        }
        return result;
    }
}

