/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpUserTagService;
import me.chanjar.weixin.mp.api.impl.WxMpDataCubeServiceImpl;
import me.chanjar.weixin.mp.bean.tag.WxUserTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpUserTagServiceImpl
implements WxMpUserTagService {
    protected final Logger log = LoggerFactory.getLogger(WxMpDataCubeServiceImpl.class);
    private static final String API_URL_PREFIX = "https://api.weixin.qq.com/cgi-bin/tags";
    private WxMpService wxMpService;

    public WxMpUserTagServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxUserTag tagCreate(String name) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/tags/create";
        JsonObject json = new JsonObject();
        JsonObject tagJson = new JsonObject();
        tagJson.addProperty("name", name);
        json.add("tag", (JsonElement)tagJson);
        String responseContent = this.wxMpService.post(url, json.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, json.toString(), responseContent});
        return WxUserTag.fromJson(responseContent);
    }

    @Override
    public List<WxUserTag> tagGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/tags/get";
        String responseContent = this.wxMpService.get(url, null);
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, "[empty]", responseContent});
        return WxUserTag.listFromJson(responseContent);
    }

    @Override
    public Boolean tagUpdate(Integer id, String name) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/tags/update";
        JsonObject json = new JsonObject();
        JsonObject tagJson = new JsonObject();
        tagJson.addProperty("id", (Number)id);
        tagJson.addProperty("name", name);
        json.add("tag", (JsonElement)tagJson);
        String responseContent = this.wxMpService.post(url, json.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, json.toString(), responseContent});
        WxError wxError = WxError.fromJson((String)responseContent);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public Boolean tagDelete(Integer id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/tags/delete";
        JsonObject json = new JsonObject();
        JsonObject tagJson = new JsonObject();
        tagJson.addProperty("id", (Number)id);
        json.add("tag", (JsonElement)tagJson);
        String responseContent = this.wxMpService.post(url, json.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, json.toString(), responseContent});
        WxError wxError = WxError.fromJson((String)responseContent);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }
}

