/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.bean.pay.result;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import io.restassured.path.xml.XmlPath;
import java.util.ArrayList;
import java.util.List;
import me.chanjar.weixin.mp.bean.pay.result.WxPayBaseResult;

@XStreamAlias(value="xml")
public class WxPayRefundQueryResult
extends WxPayBaseResult {
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @XStreamAlias(value="settlement_total_fee")
    private Integer settlementTotalFee;
    @XStreamAlias(value="fee_type")
    private String feeType;
    @XStreamAlias(value="cash_fee")
    private Integer cashFee;
    @XStreamAlias(value="refund_count")
    private Integer refundCount;
    private List<RefundRecord> refundRecords;

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public Integer getSettlementTotalFee() {
        return this.settlementTotalFee;
    }

    public void setSettlementTotalFee(Integer settlementTotalFee) {
        this.settlementTotalFee = settlementTotalFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public Integer getCashFee() {
        return this.cashFee;
    }

    public void setCashFee(Integer cashFee) {
        this.cashFee = cashFee;
    }

    public Integer getRefundCount() {
        return this.refundCount;
    }

    public void setRefundCount(Integer refundCount) {
        this.refundCount = refundCount;
    }

    public List<RefundRecord> getRefundRecords() {
        return this.refundRecords;
    }

    public void setRefundRecords(List<RefundRecord> refundRecords) {
        this.refundRecords = refundRecords;
    }

    public void composeRefundRecords() {
        if (this.refundCount != null && this.refundCount > 0) {
            this.refundRecords = Lists.newArrayList();
            XmlPath xmlPath = new XmlPath(this.getXmlString());
            for (int i = 0; i < this.refundCount; ++i) {
                RefundRecord refundRecord = new RefundRecord();
                this.refundRecords.add(refundRecord);
                refundRecord.setOutRefundNo(this.getXmlValue(xmlPath, "xml.out_refund_no_" + i, String.class));
                refundRecord.setRefundId(this.getXmlValue(xmlPath, "xml.refund_id_" + i, String.class));
                refundRecord.setRefundChannel(this.getXmlValue(xmlPath, "xml.refund_channel_" + i, String.class));
                refundRecord.setRefundFee(this.getXmlValue(xmlPath, "xml.refund_fee_" + i, Integer.class));
                refundRecord.setSettlementRefundFee(this.getXmlValue(xmlPath, "xml.settlement_refund_fee_" + i, Integer.class));
                refundRecord.setCouponType(this.getXmlValue(xmlPath, "xml.coupon_type_" + i, String.class));
                refundRecord.setCouponRefundFee(this.getXmlValue(xmlPath, "xml.coupon_refund_fee_" + i, Integer.class));
                refundRecord.setCouponRefundCount(this.getXmlValue(xmlPath, "xml.coupon_refund_count_" + i, Integer.class));
                refundRecord.setRefundStatus(this.getXmlValue(xmlPath, "xml.refund_status_" + i, String.class));
                refundRecord.setRefundRecvAccout(this.getXmlValue(xmlPath, "xml.refund_recv_accout_" + i, String.class));
                if (refundRecord.getCouponRefundCount() == null || refundRecord.getCouponRefundCount() == 0) continue;
                ArrayList coupons = Lists.newArrayList();
                for (int j = 0; j < refundRecord.getCouponRefundCount(); ++j) {
                    coupons.add(new RefundRecord.RefundCoupon(this.getXmlValue(xmlPath, "xml.coupon_refund_id_" + i + "_" + j, String.class), this.getXmlValue(xmlPath, "xml.coupon_refund_fee_" + i + "_" + j, Integer.class)));
                }
            }
        }
    }

    public static class RefundRecord {
        @XStreamAlias(value="out_refund_no")
        private String outRefundNo;
        @XStreamAlias(value="refund_id")
        private String refundId;
        @XStreamAlias(value="refund_channel")
        private String refundChannel;
        @XStreamAlias(value="refund_fee")
        private Integer refundFee;
        @XStreamAlias(value="settlement_refund_fee")
        private Integer settlementRefundFee;
        @XStreamAlias(value="refund_account")
        private String refundAccount;
        @XStreamAlias(value="coupon_type")
        private String couponType;
        @XStreamAlias(value="coupon_refund_fee")
        private Integer couponRefundFee;
        @XStreamAlias(value="coupon_refund_count")
        private Integer couponRefundCount;
        private List<RefundCoupon> refundCoupons;
        @XStreamAlias(value="refund_status")
        private String refundStatus;
        @XStreamAlias(value="refund_recv_accout")
        private String refundRecvAccout;

        public String getOutRefundNo() {
            return this.outRefundNo;
        }

        public void setOutRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
        }

        public String getRefundId() {
            return this.refundId;
        }

        public void setRefundId(String refundId) {
            this.refundId = refundId;
        }

        public String getRefundChannel() {
            return this.refundChannel;
        }

        public void setRefundChannel(String refundChannel) {
            this.refundChannel = refundChannel;
        }

        public Integer getRefundFee() {
            return this.refundFee;
        }

        public void setRefundFee(Integer refundFee) {
            this.refundFee = refundFee;
        }

        public Integer getSettlementRefundFee() {
            return this.settlementRefundFee;
        }

        public void setSettlementRefundFee(Integer settlementRefundFee) {
            this.settlementRefundFee = settlementRefundFee;
        }

        public String getRefundAccount() {
            return this.refundAccount;
        }

        public void setRefundAccount(String refundAccount) {
            this.refundAccount = refundAccount;
        }

        public String getCouponType() {
            return this.couponType;
        }

        public void setCouponType(String couponType) {
            this.couponType = couponType;
        }

        public Integer getCouponRefundFee() {
            return this.couponRefundFee;
        }

        public void setCouponRefundFee(Integer couponRefundFee) {
            this.couponRefundFee = couponRefundFee;
        }

        public Integer getCouponRefundCount() {
            return this.couponRefundCount;
        }

        public void setCouponRefundCount(Integer couponRefundCount) {
            this.couponRefundCount = couponRefundCount;
        }

        public List<RefundCoupon> getRefundCoupons() {
            return this.refundCoupons;
        }

        public void setRefundCoupons(List<RefundCoupon> refundCoupons) {
            this.refundCoupons = refundCoupons;
        }

        public String getRefundStatus() {
            return this.refundStatus;
        }

        public void setRefundStatus(String refundStatus) {
            this.refundStatus = refundStatus;
        }

        public String getRefundRecvAccout() {
            return this.refundRecvAccout;
        }

        public void setRefundRecvAccout(String refundRecvAccout) {
            this.refundRecvAccout = refundRecvAccout;
        }

        public static class RefundCoupon {
            @XStreamAlias(value="coupon_refund_batch_id")
            private String couponRefundBatchId;
            @XStreamAlias(value="coupon_refund_id")
            private String couponRefundId;
            @XStreamAlias(value="coupon_refund_fee")
            private Integer couponRefundFee;

            public RefundCoupon(String couponRefundId, Integer couponRefundFee) {
                this.couponRefundId = couponRefundId;
                this.couponRefundFee = couponRefundFee;
            }

            @Deprecated
            public RefundCoupon(String couponRefundBatchId, String couponRefundId, Integer couponRefundFee) {
                this.couponRefundBatchId = couponRefundBatchId;
                this.couponRefundId = couponRefundId;
                this.couponRefundFee = couponRefundFee;
            }
        }
    }
}

