/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.okhttp;

import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.util.http.MaterialVoiceAndImageDownloadRequestExecutor;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.io.IOUtils;

public class OkhttpMaterialVoiceAndImageDownloadRequestExecutor
extends MaterialVoiceAndImageDownloadRequestExecutor<ConnectionPool, OkHttpProxyInfo> {
    public OkhttpMaterialVoiceAndImageDownloadRequestExecutor(RequestHttp requestHttp, File tmpDirFile) {
        super(requestHttp, tmpDirFile);
    }

    public InputStream execute(String uri, String materialId) throws WxErrorException, IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool((ConnectionPool)this.requestHttp.getRequestHttpClient());
        if (this.requestHttp.getRequestHttpProxy() != null) {
            clientBuilder.proxy(((OkHttpProxyInfo)this.requestHttp.getRequestHttpProxy()).getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)((OkHttpProxyInfo)OkhttpMaterialVoiceAndImageDownloadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyUsername(), (String)((OkHttpProxyInfo)OkhttpMaterialVoiceAndImageDownloadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        FormBody requestBody = new FormBody.Builder().add("media_id", materialId).build();
        Request request = new Request.Builder().url(uri).get().post((RequestBody)requestBody).build();
        Response response = client.newCall(request).execute();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(response.body().bytes());){
            byte[] responseContent = IOUtils.toByteArray((InputStream)inputStream);
            String responseContentString = new String(responseContent, "UTF-8");
            if (responseContentString.length() < 100) {
                try {
                    WxError wxError = (WxError)WxGsonBuilder.create().fromJson(responseContentString, WxError.class);
                    if (wxError.getErrorCode() != 0) {
                        throw new WxErrorException(wxError);
                    }
                }
                catch (JsonSyntaxException ex) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseContent);
                    if (inputStream != null) {
                        if (var9_9 != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable) {
                                var9_9.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)inputStream).close();
                        }
                    }
                    return byteArrayInputStream;
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseContent);
            return byteArrayInputStream;
        }
    }
}

