/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.impl.AbstractWxMpServiceImpl;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class WxMpServiceOkHttpImpl
extends AbstractWxMpServiceImpl<ConnectionPool, OkHttpProxyInfo> {
    private ConnectionPool httpClient;
    private OkHttpProxyInfo httpProxy;

    public ConnectionPool getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.OK_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        Lock lock = this.getWxMpConfigStorage().getAccessTokenLock();
        try {
            lock.lock();
            if (forceRefresh) {
                this.getWxMpConfigStorage().expireAccessToken();
            }
            if (this.getWxMpConfigStorage().isAccessTokenExpired()) {
                String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret());
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(this.httpClient);
                if (this.httpProxy != null) {
                    clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
                }
                clientBuilder.authenticator(new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        String credential = Credentials.basic((String)WxMpServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxMpServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                        return response.request().newBuilder().header("Authorization", credential).build();
                    }
                });
                OkHttpClient client = clientBuilder.build();
                Request request = new Request.Builder().url(url).get().build();
                Response response = client.newCall(request).execute();
                String resultContent = response.body().string();
                WxError error = WxError.fromJson((String)resultContent);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                this.getWxMpConfigStorage().updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
        return this.getWxMpConfigStorage().getAccessToken();
    }

    @Override
    public void initHttp() {
        WxMpConfigStorage configStorage = this.getWxMpConfigStorage();
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new OkHttpProxyInfo(OkHttpProxyInfo.ProxyType.SOCKS5, configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort(), configStorage.getHttpProxyUsername(), configStorage.getHttpProxyPassword());
        }
        this.httpClient = new ConnectionPool();
    }

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }
}

