/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api;

import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import redis.clients.jedis.Jedis;

public class WxMpInRedisConfigStorage
extends WxMpInMemoryConfigStorage {
    private static final String ACCESS_TOKEN_KEY = "wechat_access_token_";
    private static final String JSAPI_TICKET_KEY = "wechat_jsapi_ticket_";
    private static final String CARDAPI_TICKET_KEY = "wechat_cardapi_ticket_";
    protected Jedis jedis;

    @Override
    public String getAccessToken() {
        return this.jedis.get(ACCESS_TOKEN_KEY.concat(this.appId));
    }

    @Override
    public boolean isAccessTokenExpired() {
        return this.jedis.ttl(ACCESS_TOKEN_KEY.concat(this.appId)) < 2L;
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.jedis.set(ACCESS_TOKEN_KEY.concat(this.appId), accessToken);
        this.jedis.expire(ACCESS_TOKEN_KEY.concat(this.appId), expiresInSeconds - 200);
    }

    @Override
    public void expireAccessToken() {
        this.jedis.expire(ACCESS_TOKEN_KEY.concat(this.appId), 0);
    }

    @Override
    public String getJsapiTicket() {
        return this.jedis.get(JSAPI_TICKET_KEY.concat(this.appId));
    }

    @Override
    public boolean isJsapiTicketExpired() {
        return this.jedis.ttl(JSAPI_TICKET_KEY.concat(this.appId)) < 2L;
    }

    @Override
    public synchronized void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        this.jedis.set(JSAPI_TICKET_KEY.concat(this.appId), jsapiTicket);
        this.jedis.expire(JSAPI_TICKET_KEY.concat(this.appId), expiresInSeconds - 200);
    }

    @Override
    public void expireJsapiTicket() {
        this.jedis.expire(JSAPI_TICKET_KEY.concat(this.appId), 0);
    }

    @Override
    public String getCardApiTicket() {
        return this.jedis.get(CARDAPI_TICKET_KEY.concat(this.appId));
    }

    @Override
    public boolean isCardApiTicketExpired() {
        return this.jedis.ttl(CARDAPI_TICKET_KEY.concat(this.appId)) < 2L;
    }

    @Override
    public synchronized void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        this.jedis.set(CARDAPI_TICKET_KEY.concat(this.appId), cardApiTicket);
        this.jedis.expire(CARDAPI_TICKET_KEY.concat(this.appId), expiresInSeconds - 200);
    }

    @Override
    public void expireCardApiTicket() {
        this.jedis.expire(CARDAPI_TICKET_KEY.concat(this.appId), 0);
    }

    public void setJedis(Jedis jedis) {
        this.jedis = jedis;
    }
}

