/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxCardApiSignature;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.api.WxMpCardService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.card.WxMpCardCodeCheckcodeResult;
import me.chanjar.weixin.mp.bean.card.WxMpCardCodeDepositCountResult;
import me.chanjar.weixin.mp.bean.card.WxMpCardCodeDepositResult;
import me.chanjar.weixin.mp.bean.card.WxMpCardCreateRequest;
import me.chanjar.weixin.mp.bean.card.WxMpCardCreateResult;
import me.chanjar.weixin.mp.bean.card.WxMpCardDeleteResult;
import me.chanjar.weixin.mp.bean.card.WxMpCardLandingPageCreateRequest;
import me.chanjar.weixin.mp.bean.card.WxMpCardLandingPageCreateResult;
import me.chanjar.weixin.mp.bean.card.WxMpCardMpnewsGethtmlResult;
import me.chanjar.weixin.mp.bean.card.WxMpCardQrcodeCreateResult;
import me.chanjar.weixin.mp.bean.card.WxMpCardResult;
import me.chanjar.weixin.mp.enums.TicketType;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpCardServiceImpl
implements WxMpCardService {
    private static final Logger log = LoggerFactory.getLogger(WxMpCardServiceImpl.class);
    private static final Gson GSON = WxMpGsonBuilder.create();
    private final WxMpService wxMpService;

    @Override
    public WxMpService getWxMpService() {
        return this.wxMpService;
    }

    @Override
    public String getCardApiTicket() throws WxErrorException {
        return this.getCardApiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCardApiTicket(boolean forceRefresh) throws WxErrorException {
        TicketType type = TicketType.WX_CARD;
        Lock lock = this.getWxMpService().getWxMpConfigStorage().getTicketLock(type);
        try {
            lock.lock();
            if (forceRefresh) {
                this.getWxMpService().getWxMpConfigStorage().expireTicket(type);
            }
            if (this.getWxMpService().getWxMpConfigStorage().isTicketExpired(type)) {
                String responseContent = (String)this.wxMpService.execute(SimpleGetRequestExecutor.create((RequestHttp)this.getWxMpService().getRequestHttp()), WxMpApiUrl.Card.CARD_GET_TICKET, null);
                JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
                JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                String cardApiTicket = tmpJsonObject.get("ticket").getAsString();
                int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                this.getWxMpService().getWxMpConfigStorage().updateTicket(type, cardApiTicket, expiresInSeconds);
            }
        }
        finally {
            lock.unlock();
        }
        return this.getWxMpService().getWxMpConfigStorage().getTicket(type);
    }

    @Override
    public WxCardApiSignature createCardApiSignature(String ... optionalSignParam) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = RandomUtils.getRandomStr();
        String cardApiTicket = this.getCardApiTicket(false);
        String[] signParams = Arrays.copyOf(optionalSignParam, optionalSignParam.length + 3);
        signParams[optionalSignParam.length] = String.valueOf(timestamp);
        signParams[optionalSignParam.length + 1] = nonceStr;
        signParams[optionalSignParam.length + 2] = cardApiTicket;
        StringBuilder sb = new StringBuilder();
        for (String a : signParams) {
            sb.append(a);
        }
        String signature = DigestUtils.sha1Hex((String)sb.toString());
        WxCardApiSignature cardApiSignature = new WxCardApiSignature();
        cardApiSignature.setTimestamp(Long.valueOf(timestamp));
        cardApiSignature.setNonceStr(nonceStr);
        cardApiSignature.setSignature(signature);
        return cardApiSignature;
    }

    @Override
    public String decryptCardCode(String encryptCode) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("encrypt_code", encryptCode);
        String responseContent = this.wxMpService.post(WxMpApiUrl.Card.CARD_CODE_DECRYPT, param.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
        JsonPrimitive jsonPrimitive = tmpJsonObject.getAsJsonPrimitive("code");
        return jsonPrimitive.getAsString();
    }

    @Override
    public WxMpCardResult queryCardCode(String cardId, String code, boolean checkConsume) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        param.addProperty("code", code);
        param.addProperty("check_consume", Boolean.valueOf(checkConsume));
        String responseContent = this.wxMpService.post(WxMpApiUrl.Card.CARD_CODE_GET, param.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (WxMpCardResult)WxMpGsonBuilder.create().fromJson(tmpJsonElement, new TypeToken<WxMpCardResult>(){}.getType());
    }

    @Override
    public String consumeCardCode(String code) throws WxErrorException {
        return this.consumeCardCode(code, null);
    }

    @Override
    public String consumeCardCode(String code, String cardId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("code", code);
        if (cardId != null && !"".equals(cardId)) {
            param.addProperty("card_id", cardId);
        }
        return this.wxMpService.post(WxMpApiUrl.Card.CARD_CODE_CONSUME, param.toString());
    }

    @Override
    public void markCardCode(String code, String cardId, String openId, boolean isMark) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("code", code);
        param.addProperty("card_id", cardId);
        param.addProperty("openid", openId);
        param.addProperty("is_mark", Boolean.valueOf(isMark));
        String responseContent = this.getWxMpService().post(WxMpApiUrl.Card.CARD_CODE_MARK, param.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        WxMpCardResult cardResult = (WxMpCardResult)WxMpGsonBuilder.create().fromJson(tmpJsonElement, new TypeToken<WxMpCardResult>(){}.getType());
        if (!"0".equals(cardResult.getErrorCode())) {
            log.warn("\u670b\u53cb\u7684\u5238mark\u5931\u8d25\uff1a{}", (Object)cardResult.getErrorMsg());
        }
    }

    @Override
    public String getCardDetail(String cardId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        String responseContent = this.wxMpService.post(WxMpApiUrl.Card.CARD_GET, param.toString());
        JsonObject json = new JsonParser().parse(responseContent).getAsJsonObject();
        String errcode = json.get("errcode").getAsString();
        if (!"0".equals(errcode)) {
            String errmsg = json.get("errmsg").getAsString();
            throw new WxErrorException(WxError.builder().errorCode(Integer.valueOf(errcode).intValue()).errorMsg(errmsg).build());
        }
        return responseContent;
    }

    @Override
    public String addTestWhiteList(String openid) throws WxErrorException {
        JsonArray array = new JsonArray();
        array.add(openid);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("openid", (JsonElement)array);
        return this.wxMpService.post(WxMpApiUrl.Card.CARD_TEST_WHITELIST, GSON.toJson((JsonElement)jsonObject));
    }

    @Override
    public WxMpCardCreateResult createCard(WxMpCardCreateRequest cardCreateMessage) throws WxErrorException {
        String response = this.wxMpService.post(WxMpApiUrl.Card.CARD_CREATE, GSON.toJson((Object)cardCreateMessage));
        return WxMpCardCreateResult.fromJson(response);
    }

    @Override
    public WxMpCardQrcodeCreateResult createQrcodeCard(String cardId, String outerStr) throws WxErrorException {
        return this.createQrcodeCard(cardId, outerStr, 0);
    }

    @Override
    public WxMpCardQrcodeCreateResult createQrcodeCard(String cardId, String outerStr, int expiresIn) throws WxErrorException {
        return this.createQrcodeCard(cardId, outerStr, expiresIn, null, null, false);
    }

    @Override
    public WxMpCardQrcodeCreateResult createQrcodeCard(String cardId, String outerStr, int expiresIn, String openid, String code, boolean isUniqueCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("action_name", "QR_CARD");
        if (expiresIn > 0) {
            jsonObject.addProperty("expire_seconds", (Number)expiresIn);
        }
        JsonObject actionInfoJson = new JsonObject();
        JsonObject cardJson = new JsonObject();
        if (openid != null) {
            cardJson.addProperty("openid", openid);
        }
        if (code != null) {
            cardJson.addProperty("code", code);
        }
        cardJson.addProperty("is_unique_code", Boolean.valueOf(isUniqueCode));
        cardJson.addProperty("card_id", cardId);
        cardJson.addProperty("outer_str", outerStr);
        actionInfoJson.add("card", (JsonElement)cardJson);
        jsonObject.add("action_info", (JsonElement)actionInfoJson);
        return WxMpCardQrcodeCreateResult.fromJson(this.wxMpService.post(WxMpApiUrl.Card.CARD_QRCODE_CREATE, GSON.toJson((JsonElement)jsonObject)));
    }

    @Override
    public WxMpCardLandingPageCreateResult createLandingPage(WxMpCardLandingPageCreateRequest request) throws WxErrorException {
        String response = this.wxMpService.post(WxMpApiUrl.Card.CARD_LANDING_PAGE_CREATE, GSON.toJson((Object)request));
        return WxMpCardLandingPageCreateResult.fromJson(response);
    }

    @Override
    public String unavailableCardCode(String cardId, String code, String reason) throws WxErrorException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{cardId, code, reason})) {
            throw new WxErrorException(WxError.builder().errorCode(41012).errorMsg("\u53c2\u6570\u4e0d\u5b8c\u6574").build());
        }
        JsonObject jsonRequest = new JsonObject();
        jsonRequest.addProperty("card_id", cardId);
        jsonRequest.addProperty("code", code);
        jsonRequest.addProperty("reason", reason);
        return this.wxMpService.post(WxMpApiUrl.Card.CARD_CODE_UNAVAILABLE, GSON.toJson((JsonElement)jsonRequest));
    }

    @Override
    public WxMpCardDeleteResult deleteCard(String cardId) throws WxErrorException {
        this.checkCardId(cardId);
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        String response = this.wxMpService.post(WxMpApiUrl.Card.CARD_DELETE, param.toString());
        return WxMpCardDeleteResult.fromJson(response);
    }

    @Override
    public WxMpCardCodeDepositResult cardCodeDeposit(String cardId, List<String> codeList) throws WxErrorException {
        this.checkCardId(cardId);
        if (codeList.size() == 0 || codeList.size() > 100) {
            throw new WxErrorException(WxError.builder().errorCode(40109).errorMsg("code\u6570\u91cf\u4e3a0\u6216\u8005code\u6570\u91cf\u8d85\u8fc7100\u4e2a").build());
        }
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        param.add("code", (JsonElement)WxGsonBuilder.create().toJsonTree(codeList, new TypeToken<List<String>>(){}.getType()).getAsJsonArray());
        String response = this.wxMpService.post(WxMpApiUrl.Card.CARD_CODE_DEPOSIT, param.toString());
        return WxMpCardCodeDepositResult.fromJson(response);
    }

    @Override
    public WxMpCardCodeDepositCountResult cardCodeDepositCount(String cardId) throws WxErrorException {
        this.checkCardId(cardId);
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        String response = this.wxMpService.post(WxMpApiUrl.Card.CARD_CODE_DEPOSIT_COUNT, param.toString());
        return WxMpCardCodeDepositCountResult.fromJson(response);
    }

    @Override
    public WxMpCardCodeCheckcodeResult cardCodeCheckcode(String cardId, List<String> codeList) throws WxErrorException {
        this.checkCardId(cardId);
        if (codeList.size() == 0 || codeList.size() > 100) {
            throw new WxErrorException(WxError.builder().errorCode(40109).errorMsg("code\u6570\u91cf\u4e3a0\u6216\u8005code\u6570\u91cf\u8d85\u8fc7100\u4e2a").build());
        }
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        param.add("code", (JsonElement)WxGsonBuilder.create().toJsonTree(codeList, new TypeToken<List<String>>(){}.getType()).getAsJsonArray());
        String response = this.wxMpService.post(WxMpApiUrl.Card.CARD_CODE_CHECKCODE, param.toString());
        return WxMpCardCodeCheckcodeResult.fromJson(response);
    }

    @Override
    public WxMpCardMpnewsGethtmlResult cardMpnewsGethtml(String cardId) throws WxErrorException {
        this.checkCardId(cardId);
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        String response = this.wxMpService.post(WxMpApiUrl.Card.CARD_MPNEWS_GETHTML, param.toString());
        return WxMpCardMpnewsGethtmlResult.fromJson(response);
    }

    @Override
    public void cardModifyStock(String cardId, Integer changeValue) throws WxErrorException {
        this.checkCardId(cardId);
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        if (changeValue > 0) {
            param.addProperty("increase_stock_value", (Number)changeValue);
        } else {
            param.addProperty("reduce_stock_value", (Number)Math.abs(changeValue));
        }
        this.wxMpService.post(WxMpApiUrl.Card.CARD_MODIFY_STOCK, param.toString());
    }

    @Override
    public void cardCodeUpdate(String cardId, String oldCode, String newCode) throws WxErrorException {
        this.checkCardId(cardId);
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        param.addProperty("code", oldCode);
        param.addProperty("new_code", newCode);
        this.wxMpService.post(WxMpApiUrl.Card.CARD_CODE_UPDATE, param.toString());
    }

    @Override
    public void cardPaycellSet(String cardId, Boolean isOpen) throws WxErrorException {
        this.checkCardId(cardId);
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        param.addProperty("is_open", isOpen);
        this.wxMpService.post(WxMpApiUrl.Card.CARD_PAYCELL_SET, param.toString());
    }

    @Override
    public void cardSelfConsumeCellSet(String cardId, Boolean isOpen, Boolean needVerifyCod, Boolean needRemarkAmount) throws WxErrorException {
        this.checkCardId(cardId);
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        param.addProperty("is_open", isOpen);
        param.addProperty("need_verify_cod", needVerifyCod);
        param.addProperty("need_remark_amount", needRemarkAmount);
        this.wxMpService.post(WxMpApiUrl.Card.CARD_SELF_CONSUME_CELL_SET, param.toString());
    }

    private void checkCardId(String cardId) throws WxErrorException {
        if (StringUtils.isEmpty((CharSequence)cardId)) {
            throw new WxErrorException(WxError.builder().errorCode(41012).errorMsg("cardId\u4e0d\u80fd\u4e3a\u7a7a").build());
        }
    }

    public WxMpCardServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

