/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.util.concurrent.locks.Lock;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.mp.api.impl.BaseWxMpServiceImpl;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpServiceJoddHttpImpl
extends BaseWxMpServiceImpl<HttpConnectionProvider, ProxyInfo> {
    private HttpConnectionProvider httpClient;
    private ProxyInfo httpProxy;

    public HttpConnectionProvider getRequestHttpClient() {
        return this.httpClient;
    }

    public ProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.JODD_HTTP;
    }

    @Override
    public void initHttp() {
        WxMpConfigStorage configStorage = this.getWxMpConfigStorage();
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort(), configStorage.getHttpProxyUsername(), configStorage.getHttpProxyPassword());
        }
        this.httpClient = new SocketHttpConnectionProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        WxMpConfigStorage config = this.getWxMpConfigStorage();
        if (!config.isAccessTokenExpired() && !forceRefresh) {
            return config.getAccessToken();
        }
        Lock lock = config.getAccessTokenLock();
        lock.lock();
        try {
            if (!config.isAccessTokenExpired() && !forceRefresh) {
                String string = config.getAccessToken();
                return string;
            }
            String url = String.format(WxMpApiUrl.Other.GET_ACCESS_TOKEN_URL.getUrl(config), config.getAppId(), config.getSecret());
            HttpRequest request = HttpRequest.get((String)url);
            if (this.getRequestHttpProxy() != null) {
                SocketHttpConnectionProvider provider = new SocketHttpConnectionProvider();
                provider.useProxy(this.getRequestHttpProxy());
                request.withConnectionProvider((HttpConnectionProvider)provider);
            }
            String string = this.extractAccessToken(request.send().bodyText());
            return string;
        }
        finally {
            lock.unlock();
        }
    }
}

