/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.requestexecuter.material;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.bean.material.WxMpMaterial;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialUploadRequestExecutor;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;

public class MaterialUploadApacheHttpRequestExecutor
extends MaterialUploadRequestExecutor<CloseableHttpClient, HttpHost> {
    public MaterialUploadApacheHttpRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    /*
     * Loose catch block
     */
    public WxMpMaterialUploadResult execute(String uri, WxMpMaterial material, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig response = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(response);
        }
        if (material == null) {
            throw new WxErrorException("\u975e\u6cd5\u8bf7\u6c42\uff0cmaterial\u53c2\u6570\u4e3a\u7a7a");
        }
        File file = material.getFile();
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addBinaryBody("media", file).setMode(HttpMultipartMode.RFC6532);
        Map<String, String> form = material.getForm();
        if (material.getForm() != null) {
            multipartEntityBuilder.addPart("description", (ContentBody)new StringBody(WxGsonBuilder.create().toJson(form), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        }
        httpPost.setEntity(multipartEntityBuilder.build());
        try {
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost);){
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                WxError error = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxMpMaterialUploadResult wxMpMaterialUploadResult = WxMpMaterialUploadResult.fromJson(responseContent);
                return wxMpMaterialUploadResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }
}

