/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.mp.api.impl.BaseWxMpServiceImpl;
import me.chanjar.weixin.mp.bean.WxMpStableAccessTokenRequest;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpServiceJoddHttpImpl
extends BaseWxMpServiceImpl<HttpConnectionProvider, ProxyInfo> {
    private HttpConnectionProvider httpClient;
    private ProxyInfo httpProxy;

    public HttpConnectionProvider getRequestHttpClient() {
        return this.httpClient;
    }

    public ProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.JODD_HTTP;
    }

    @Override
    public void initHttp() {
        WxMpConfigStorage configStorage = this.getWxMpConfigStorage();
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort(), configStorage.getHttpProxyUsername(), configStorage.getHttpProxyPassword());
        }
        this.httpClient = new SocketHttpConnectionProvider();
    }

    @Override
    protected String doGetAccessTokenRequest() throws IOException {
        String url = String.format(WxMpApiUrl.Other.GET_ACCESS_TOKEN_URL.getUrl(this.getWxMpConfigStorage()), this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret());
        HttpRequest request = HttpRequest.get((String)url);
        if (this.getRequestHttpProxy() != null) {
            SocketHttpConnectionProvider provider = new SocketHttpConnectionProvider();
            provider.useProxy(this.getRequestHttpProxy());
            request.withConnectionProvider((HttpConnectionProvider)provider);
        }
        return request.send().bodyText();
    }

    @Override
    protected String doGetStableAccessTokenRequest(boolean forceRefresh) throws IOException {
        String url = WxMpApiUrl.Other.GET_STABLE_ACCESS_TOKEN_URL.getUrl(this.getWxMpConfigStorage());
        WxMpStableAccessTokenRequest wxMaAccessTokenRequest = new WxMpStableAccessTokenRequest();
        wxMaAccessTokenRequest.setAppid(this.getWxMpConfigStorage().getAppId());
        wxMaAccessTokenRequest.setSecret(this.getWxMpConfigStorage().getSecret());
        wxMaAccessTokenRequest.setGrantType("client_credential");
        wxMaAccessTokenRequest.setForceRefresh(forceRefresh);
        HttpRequest request = (HttpRequest)((HttpRequest)HttpRequest.post((String)url).contentType("application/json", StandardCharsets.UTF_8.name())).body(wxMaAccessTokenRequest.toJson());
        if (this.getRequestHttpProxy() != null) {
            SocketHttpConnectionProvider provider = new SocketHttpConnectionProvider();
            provider.useProxy(this.getRequestHttpProxy());
            request.withConnectionProvider((HttpConnectionProvider)provider);
        }
        return request.send().bodyText();
    }
}

