/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaUserService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.util.crypt.WxMaCryptUtils;
import com.google.common.base.Joiner;
import java.util.HashMap;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import org.apache.commons.codec.digest.DigestUtils;

class WxOpenMaUserServiceImpl
implements WxMaUserService {
    private static final String COMPONENT_JSCODE_TO_SESSION_URL = "https://api.weixin.qq.com/sns/component/jscode2session";
    private WxOpenComponentService wxOpenComponentService;
    private WxMaService wxMaService;

    public WxOpenMaUserServiceImpl(WxOpenComponentService wxOpenComponentService, WxMaService wxMaService) {
        this.wxOpenComponentService = wxOpenComponentService;
        this.wxMaService = wxMaService;
    }

    public WxMaJscode2SessionResult getSessionInfo(String jsCode) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("appid", this.wxMaService.getWxMaConfig().getAppid());
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        params.put("component_appid", this.wxOpenComponentService.getWxOpenConfigStorage().getComponentAppId());
        params.put("component_access_token", this.wxOpenComponentService.getComponentAccessToken(false));
        String result = this.wxMaService.get(COMPONENT_JSCODE_TO_SESSION_URL, Joiner.on((String)"&").withKeyValueSeparator("=").join(params));
        return WxMaJscode2SessionResult.fromJson((String)result);
    }

    public WxMaUserInfo getUserInfo(String sessionKey, String encryptedData, String ivStr) {
        return WxMaUserInfo.fromJson((String)WxMaCryptUtils.decrypt((String)sessionKey, (String)encryptedData, (String)ivStr));
    }

    public WxMaPhoneNumberInfo getPhoneNoInfo(String sessionKey, String encryptedData, String ivStr) {
        return WxMaPhoneNumberInfo.fromJson((String)WxMaCryptUtils.decrypt((String)sessionKey, (String)encryptedData, (String)ivStr));
    }

    public boolean checkUserInfo(String sessionKey, String rawData, String signature) {
        String generatedSignature = DigestUtils.sha1Hex((String)(rawData + sessionKey));
        return generatedSignature.equals(signature);
    }
}

