/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.bean.WxOpenAuthorizerAccessToken;
import me.chanjar.weixin.open.bean.WxOpenComponentAccessToken;

public class WxOpenInMemoryConfigStorage
implements WxOpenConfigStorage {
    private String componentAppId;
    private String componentAppSecret;
    private String componentToken;
    private String componentAesKey;
    private String componentVerifyTicket;
    private String componentAccessToken;
    private long componentExpiresTime;
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private ApacheHttpClientBuilder apacheHttpClientBuilder;
    private Map<String, Token> authorizerRefreshTokens = new Hashtable<String, Token>();
    private Map<String, Token> authorizerAccessTokens = new Hashtable<String, Token>();
    private Map<String, Token> jsapiTickets = new Hashtable<String, Token>();
    private Map<String, Token> cardApiTickets = new Hashtable<String, Token>();

    @Override
    public String getComponentAppId() {
        return this.componentAppId;
    }

    @Override
    public void setComponentAppId(String componentAppId) {
        this.componentAppId = componentAppId;
    }

    @Override
    public String getComponentAppSecret() {
        return this.componentAppSecret;
    }

    @Override
    public void setComponentAppSecret(String componentAppSecret) {
        this.componentAppSecret = componentAppSecret;
    }

    @Override
    public String getComponentToken() {
        return this.componentToken;
    }

    @Override
    public void setComponentToken(String componentToken) {
        this.componentToken = componentToken;
    }

    @Override
    public String getComponentAesKey() {
        return this.componentAesKey;
    }

    @Override
    public void setComponentAesKey(String componentAesKey) {
        this.componentAesKey = componentAesKey;
    }

    @Override
    public String getComponentVerifyTicket() {
        return this.componentVerifyTicket;
    }

    @Override
    public void setComponentVerifyTicket(String componentVerifyTicket) {
        this.componentVerifyTicket = componentVerifyTicket;
    }

    @Override
    public String getComponentAccessToken() {
        return this.componentAccessToken;
    }

    @Override
    public boolean isComponentAccessTokenExpired() {
        return System.currentTimeMillis() > this.componentExpiresTime;
    }

    @Override
    public void expireComponentAccessToken() {
        this.componentExpiresTime = 0L;
    }

    @Override
    public void updateComponentAccessTokent(WxOpenComponentAccessToken componentAccessToken) {
        this.updateComponentAccessTokent(componentAccessToken.getComponentAccessToken(), componentAccessToken.getExpiresIn());
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    public ApacheHttpClientBuilder setApacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
        return this.apacheHttpClientBuilder;
    }

    @Override
    public WxMpConfigStorage getWxMpConfigStorage(String appId) {
        return new WxOpenInnerConfigStorage(this, appId);
    }

    @Override
    public WxMaConfig getWxMaConfig(String appId) {
        return new WxOpenInnerConfigStorage(this, appId);
    }

    @Override
    public void updateComponentAccessTokent(String componentAccessToken, int expiresInSeconds) {
        this.componentAccessToken = componentAccessToken;
        this.componentExpiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
    }

    @Override
    public boolean autoRefreshToken() {
        return true;
    }

    private String getTokenString(Map<String, Token> map, String key) {
        Token token = map.get(key);
        if (token == null || token.expiresTime != null && System.currentTimeMillis() > token.expiresTime) {
            return null;
        }
        return token.token;
    }

    private void expireToken(Map<String, Token> map, String key) {
        Token token = map.get(key);
        if (token != null) {
            token.expiresTime = 0L;
        }
    }

    private void updateToken(Map<String, Token> map, String key, String tokenString, Integer expiresInSeconds) {
        Token token = map.get(key);
        if (token == null) {
            token = new Token();
            map.put(key, token);
        }
        token.token = tokenString;
        if (expiresInSeconds != null) {
            token.expiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
        }
    }

    @Override
    public String getAuthorizerRefreshToken(String appId) {
        return this.getTokenString(this.authorizerRefreshTokens, appId);
    }

    @Override
    public void setAuthorizerRefreshToken(String appId, String authorizerRefreshToken) {
        this.updateToken(this.authorizerRefreshTokens, appId, authorizerRefreshToken, null);
    }

    @Override
    public String getAuthorizerAccessToken(String appId) {
        return this.getTokenString(this.authorizerAccessTokens, appId);
    }

    @Override
    public boolean isAuthorizerAccessTokenExpired(String appId) {
        return this.getTokenString(this.authorizerAccessTokens, appId) == null;
    }

    @Override
    public void expireAuthorizerAccessToken(String appId) {
        this.expireToken(this.authorizerAccessTokens, appId);
    }

    @Override
    public void updateAuthorizerAccessToken(String appId, WxOpenAuthorizerAccessToken authorizerAccessToken) {
        this.updateAuthorizerAccessToken(appId, authorizerAccessToken.getAuthorizerAccessToken(), authorizerAccessToken.getExpiresIn());
    }

    @Override
    public void updateAuthorizerAccessToken(String appId, String authorizerAccessToken, int expiresInSeconds) {
        this.updateToken(this.authorizerAccessTokens, appId, authorizerAccessToken, expiresInSeconds);
    }

    @Override
    public String getJsapiTicket(String appId) {
        return this.getTokenString(this.jsapiTickets, appId);
    }

    @Override
    public boolean isJsapiTicketExpired(String appId) {
        return this.getTokenString(this.jsapiTickets, appId) == null;
    }

    @Override
    public void expireJsapiTicket(String appId) {
        this.expireToken(this.jsapiTickets, appId);
    }

    @Override
    public void updateJsapiTicket(String appId, String jsapiTicket, int expiresInSeconds) {
        this.updateToken(this.jsapiTickets, appId, jsapiTicket, expiresInSeconds);
    }

    @Override
    public String getCardApiTicket(String appId) {
        return this.getTokenString(this.cardApiTickets, appId);
    }

    @Override
    public boolean isCardApiTicketExpired(String appId) {
        return this.getTokenString(this.cardApiTickets, appId) == null;
    }

    @Override
    public void expireCardApiTicket(String appId) {
        this.expireToken(this.cardApiTickets, appId);
    }

    @Override
    public void updateCardApiTicket(String appId, String cardApiTicket, int expiresInSeconds) {
        this.updateToken(this.cardApiTickets, appId, cardApiTicket, expiresInSeconds);
    }

    private static class WxOpenInnerConfigStorage
    implements WxMpConfigStorage,
    WxMaConfig {
        private WxOpenConfigStorage wxOpenConfigStorage;
        private String appId;
        private Lock accessTokenLock = new ReentrantLock();
        private Lock jsapiTicketLock = new ReentrantLock();
        private Lock cardApiTicketLock = new ReentrantLock();

        private WxOpenInnerConfigStorage(WxOpenConfigStorage wxOpenConfigStorage, String appId) {
            this.wxOpenConfigStorage = wxOpenConfigStorage;
            this.appId = appId;
        }

        public String getAccessToken() {
            return this.wxOpenConfigStorage.getAuthorizerAccessToken(this.appId);
        }

        public Lock getAccessTokenLock() {
            return this.accessTokenLock;
        }

        public boolean isAccessTokenExpired() {
            return this.wxOpenConfigStorage.isAuthorizerAccessTokenExpired(this.appId);
        }

        public synchronized void updateAccessToken(WxAccessToken accessToken) {
            this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        }

        public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
            this.wxOpenConfigStorage.updateAuthorizerAccessToken(this.appId, accessToken, expiresInSeconds);
        }

        public String getAppid() {
            return this.appId;
        }

        public void expireAccessToken() {
            this.wxOpenConfigStorage.expireAuthorizerAccessToken(this.appId);
        }

        public String getJsapiTicket() {
            return this.wxOpenConfigStorage.getJsapiTicket(this.appId);
        }

        public Lock getJsapiTicketLock() {
            return this.jsapiTicketLock;
        }

        public boolean isJsapiTicketExpired() {
            return this.wxOpenConfigStorage.isJsapiTicketExpired(this.appId);
        }

        public synchronized void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
            this.wxOpenConfigStorage.updateJsapiTicket(this.appId, jsapiTicket, expiresInSeconds);
        }

        public void expireJsapiTicket() {
            this.wxOpenConfigStorage.expireJsapiTicket(this.appId);
        }

        public String getCardApiTicket() {
            return this.wxOpenConfigStorage.getCardApiTicket(this.appId);
        }

        public Lock getCardApiTicketLock() {
            return this.cardApiTicketLock;
        }

        public boolean isCardApiTicketExpired() {
            return this.wxOpenConfigStorage.isCardApiTicketExpired(this.appId);
        }

        public synchronized void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
            this.wxOpenConfigStorage.updateCardApiTicket(this.appId, cardApiTicket, expiresInSeconds);
        }

        public void expireCardApiTicket() {
            this.wxOpenConfigStorage.expireCardApiTicket(this.appId);
        }

        public String getAppId() {
            return this.appId;
        }

        public String getSecret() {
            return null;
        }

        public String getToken() {
            return this.wxOpenConfigStorage.getComponentToken();
        }

        public String getTemplateId() {
            return null;
        }

        public long getExpiresTime() {
            return 0L;
        }

        public String getAesKey() {
            return this.wxOpenConfigStorage.getComponentAesKey();
        }

        public String getMsgDataFormat() {
            return null;
        }

        public String getOauth2redirectUri() {
            return null;
        }

        public String getHttpProxyHost() {
            return this.wxOpenConfigStorage.getHttpProxyHost();
        }

        public int getHttpProxyPort() {
            return this.wxOpenConfigStorage.getHttpProxyPort();
        }

        public String getHttpProxyUsername() {
            return this.wxOpenConfigStorage.getHttpProxyUsername();
        }

        public String getHttpProxyPassword() {
            return this.wxOpenConfigStorage.getHttpProxyPassword();
        }

        public String toString() {
            return ToStringUtils.toSimpleString((Object)this);
        }

        public File getTmpDirFile() {
            return null;
        }

        public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
            return this.wxOpenConfigStorage.getApacheHttpClientBuilder();
        }

        public boolean autoRefreshToken() {
            return true;
        }
    }

    private static class Token {
        private String token;
        private Long expiresTime;

        private Token() {
        }
    }
}

