/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.util.SignUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.math.BigDecimal;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.BeanUtils;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.apache.commons.lang3.StringUtils;

public abstract class WxPayBaseRequest {
    @XStreamAlias(value="appid")
    protected String appid;
    @XStreamAlias(value="mch_id")
    protected String mchId;
    @XStreamAlias(value="sub_appid")
    protected String subAppId;
    @XStreamAlias(value="sub_mch_id")
    protected String subMchId;
    @XStreamAlias(value="nonce_str")
    protected String nonceStr;
    @XStreamAlias(value="sign")
    protected String sign;

    protected void checkFields() throws WxErrorException {
        BeanUtils.checkRequiredFields((Object)this);
        this.checkConstraints();
    }

    protected abstract void checkConstraints();

    public static Integer yuanToFee(String yuan) {
        return new BigDecimal(yuan).setScale(2, 4).multiply(new BigDecimal(100)).intValue();
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }

    public String toString() {
        return ToStringUtils.toSimpleString((Object)this);
    }

    public String toXML() {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(this.getClass());
        return xstream.toXML((Object)this);
    }

    public void checkAndSign(WxPayConfig config) throws WxErrorException {
        this.checkFields();
        if (StringUtils.isBlank((CharSequence)this.getAppid())) {
            this.setAppid(config.getAppId());
        }
        if (StringUtils.isBlank((CharSequence)this.getMchId())) {
            this.setMchId(config.getMchId());
        }
        if (StringUtils.isBlank((CharSequence)this.getSubAppId())) {
            this.setSubAppId(config.getSubAppId());
        }
        if (StringUtils.isBlank((CharSequence)this.getSubMchId())) {
            this.setSubMchId(config.getSubMchId());
        }
        if (StringUtils.isBlank((CharSequence)this.getNonceStr())) {
            this.setNonceStr(String.valueOf(System.currentTimeMillis()));
        }
        this.setSign(SignUtils.createSign(this, config.getMchKey()));
    }
}

