/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.github.binarywang.wxpay.util.SignUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class WxPayBaseResult {
    @XStreamAlias(value="return_code")
    protected String returnCode;
    @XStreamAlias(value="return_msg")
    protected String returnMsg;
    @XStreamAlias(value="result_code")
    private String resultCode;
    @XStreamAlias(value="err_code")
    private String errCode;
    @XStreamAlias(value="err_code_des")
    private String errCodeDes;
    @XStreamAlias(value="appid")
    private String appid;
    @XStreamAlias(value="mch_id")
    private String mchId;
    @XStreamAlias(value="sub_appid")
    private String subAppId;
    @XStreamAlias(value="sub_mch_id")
    private String subMchId;
    @XStreamAlias(value="nonce_str")
    private String nonceStr;
    @XStreamAlias(value="sign")
    private String sign;
    private String xmlString;
    private Document xmlDoc;

    public static String feeToYuan(Integer fee) {
        return new BigDecimal(Double.valueOf(fee.intValue()) / 100.0).setScale(2, 4).toPlainString();
    }

    public static <T extends WxPayBaseResult> T fromXML(String xmlString, Class<T> clz) {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(clz);
        WxPayBaseResult result = (WxPayBaseResult)xstream.fromXML(xmlString);
        result.setXmlString(xmlString);
        return (T)result;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public String toString() {
        return ToStringUtils.toSimpleString((Object)this);
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMsg() {
        return this.returnMsg;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrCodeDes() {
        return this.errCodeDes;
    }

    public void setErrCodeDes(String errCodeDes) {
        this.errCodeDes = errCodeDes;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }

    public Map<String, String> toMap() {
        if (StringUtils.isBlank((CharSequence)this.xmlString)) {
            throw new RuntimeException("xml\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        HashMap result = Maps.newHashMap();
        Document doc = this.getXmlDoc();
        try {
            NodeList list = (NodeList)XPathFactory.newInstance().newXPath().compile("/xml/*").evaluate(doc, XPathConstants.NODESET);
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                result.put(list.item(i).getNodeName(), list.item(i).getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("\u975e\u6cd5\u7684xml\u6587\u672c\u5185\u5bb9\uff1a" + this.xmlString);
        }
        return result;
    }

    protected Document getXmlDoc() {
        if (this.xmlDoc != null) {
            return this.xmlDoc;
        }
        try {
            this.xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(this.xmlString.getBytes("UTF-8")));
            return this.xmlDoc;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("\u975e\u6cd5\u7684xml\u6587\u672c\u5185\u5bb9\uff1a" + this.xmlString);
        }
    }

    protected String getXmlValue(String ... path) {
        Document doc = this.getXmlDoc();
        String expression = String.format("/%s//text()", Joiner.on((String)"/").join((Object[])path));
        try {
            return (String)XPathFactory.newInstance().newXPath().compile(expression).evaluate(doc, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("\u672a\u627e\u5230\u76f8\u5e94\u8def\u5f84\u7684\u6587\u672c\uff1a" + expression);
        }
    }

    protected Integer getXmlValueAsInt(String ... path) {
        String result = this.getXmlValue(path);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return Integer.valueOf(result);
    }

    public void checkResult(WxPayServiceImpl wxPayService) throws WxErrorException {
        Map<String, String> map = this.toMap();
        if (this.getSign() != null && !SignUtils.checkSign(map, wxPayService.getConfig().getMchKey())) {
            this.getLogger().debug("\u6821\u9a8c\u7ed3\u679c\u7b7e\u540d\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", map);
            throw new WxErrorException(WxError.newBuilder().setErrorCode(-1).setErrorMsg("\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u9519\u8bef\uff01").build());
        }
        if (!"SUCCESS".equalsIgnoreCase(this.getReturnCode()) || !"SUCCESS".equalsIgnoreCase(this.getResultCode())) {
            StringBuilder errorMsg = new StringBuilder();
            if (this.getReturnCode() != null) {
                errorMsg.append("\u8fd4\u56de\u4ee3\u7801\uff1a").append(this.getReturnCode());
            }
            if (this.getReturnMsg() != null) {
                errorMsg.append("\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a").append(this.getReturnMsg());
            }
            if (this.getResultCode() != null) {
                errorMsg.append("\uff0c\u7ed3\u679c\u4ee3\u7801\uff1a").append(this.getResultCode());
            }
            if (this.getErrCode() != null) {
                errorMsg.append("\uff0c\u9519\u8bef\u4ee3\u7801\uff1a").append(this.getErrCode());
            }
            if (this.getErrCodeDes() != null) {
                errorMsg.append("\uff0c\u9519\u8bef\u8be6\u60c5\uff1a").append(this.getErrCodeDes());
            }
            WxError error = WxError.newBuilder().setErrorCode(-1).setErrorMsg(errorMsg.toString()).build();
            this.getLogger().error("\n\u7ed3\u679c\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38\uff0c\u8fd4\u56de\u7d50\u679c\uff1a{},\n{}", map, (Object)error);
            throw new WxErrorException(error);
        }
    }
}

