/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.config;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContexts;

public class WxPayConfig {
    private String appId;
    private String subAppId;
    private String mchId;
    private String mchKey;
    private String subMchId;
    private String notifyUrl;
    private String tradeType;
    private SSLContext sslContext;
    private String keyPath;

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setMchKey(String mchKey) {
        this.mchKey = mchKey;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getMchKey() {
        return this.mchKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public boolean useSandboxForWxPay() {
        return false;
    }

    public SSLContext initSSLContext() {
        if (null == this.mchId) {
            throw new IllegalArgumentException("\u8bf7\u786e\u4fdd\u5546\u6237\u53f7mch_id\u5df2\u8bbe\u7f6e");
        }
        File file = new File(this.keyPath);
        if (!file.exists()) {
            throw new RuntimeException("\u8bc1\u4e66\u6587\u4ef6\uff1a\u3010" + file.getPath() + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            char[] partnerId2charArray = this.mchId.toCharArray();
            keystore.load(inputStream, partnerId2charArray);
            this.sslContext = SSLContexts.custom().loadKeyMaterial(keystore, partnerId2charArray).build();
            return this.sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bc1\u4e66\u6587\u4ef6\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01", e);
        }
    }
}

