/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingFinishRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingQueryRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingQueryResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReceiverRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReceiverResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingResult;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnQueryRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnRequest;
import com.github.binarywang.wxpay.bean.profitsharing.ProfitSharingReturnResult;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.ProfitSharingService;
import com.github.binarywang.wxpay.service.WxPayService;

public class ProfitSharingServiceImpl
implements ProfitSharingService {
    private WxPayService payService;

    public ProfitSharingServiceImpl(WxPayService payService) {
        this.payService = payService;
    }

    @Override
    public ProfitSharingResult profitSharing(ProfitSharingRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/secapi/pay/profitsharing";
        String responseContent = this.payService.post(url, request.toXML(), true);
        ProfitSharingResult result = BaseWxPayResult.fromXML(responseContent, ProfitSharingResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public ProfitSharingResult multiProfitSharing(ProfitSharingRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/secapi/pay/multiprofitsharing";
        String responseContent = this.payService.post(url, request.toXML(), true);
        ProfitSharingResult result = BaseWxPayResult.fromXML(responseContent, ProfitSharingResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public ProfitSharingResult profitSharingFinish(ProfitSharingFinishRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/secapi/pay/profitsharingfinish";
        String responseContent = this.payService.post(url, request.toXML(), true);
        ProfitSharingResult result = BaseWxPayResult.fromXML(responseContent, ProfitSharingResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public ProfitSharingReceiverResult addReceiver(ProfitSharingReceiverRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/profitsharingaddreceiver";
        String responseContent = this.payService.post(url, request.toXML(), true);
        ProfitSharingReceiverResult result = BaseWxPayResult.fromXML(responseContent, ProfitSharingReceiverResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public ProfitSharingReceiverResult removeReceiver(ProfitSharingReceiverRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/profitsharingremovereceiver";
        String responseContent = this.payService.post(url, request.toXML(), true);
        ProfitSharingReceiverResult result = BaseWxPayResult.fromXML(responseContent, ProfitSharingReceiverResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public ProfitSharingQueryResult profitSharingQuery(ProfitSharingQueryRequest request) throws WxPayException {
        throw new WxPayException("\u6682\u4e0d\u652f\u6301\uff0c\u5fae\u4fe1\u4e00\u76f4\u8fd4\u56de\u7b7e\u540d\u5931\u8d25");
    }

    @Override
    public ProfitSharingReturnResult profitSharingReturn(ProfitSharingReturnRequest returnRequest) throws WxPayException {
        returnRequest.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/secapi/pay/profitsharingreturn";
        String responseContent = this.payService.post(url, returnRequest.toXML(), true);
        ProfitSharingReturnResult result = BaseWxPayResult.fromXML(responseContent, ProfitSharingReturnResult.class);
        result.checkResult(this.payService, returnRequest.getSignType(), true);
        return result;
    }

    @Override
    public ProfitSharingReturnResult profitSharingReturnQuery(ProfitSharingReturnQueryRequest queryRequest) throws WxPayException {
        queryRequest.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/profitsharingreturnquery";
        String responseContent = this.payService.post(url, queryRequest.toXML(), true);
        ProfitSharingReturnResult result = BaseWxPayResult.fromXML(responseContent, ProfitSharingReturnResult.class);
        result.checkResult(this.payService, queryRequest.getSignType(), true);
        return result;
    }
}

