/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import java.util.Objects;
import me.chanjar.weixin.common.annotation.Required;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxTerminatedContractRequest
extends BaseWxPayRequest {
    @XStreamAlias(value="contract_id")
    private String contractId;
    @Required
    @XStreamAlias(value="contract_termination_remark")
    private String contractTerminationRemark;
    @Required
    @XStreamAlias(value="version")
    private String version;
    @XStreamAlias(value="plan_id")
    private Integer planId;
    @XStreamAlias(value="contract_code")
    private String contractCode;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isNotBlank((CharSequence)this.contractId) && (Objects.nonNull(this.planId) || StringUtils.isNotBlank((CharSequence)this.contractCode))) {
            throw new WxPayException("contractId \u548c planId&contractCode \u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
    }

    @Override
    protected boolean needNonceStr() {
        return false;
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("contract_id", this.contractId);
        map.put("contract_termination_remark", this.contractTerminationRemark);
        map.put("version", this.version);
        if (Objects.nonNull(this.planId)) {
            map.put("plan_id", this.planId.toString());
        }
        map.put("contract_code", this.contractCode);
    }

    public static WxTerminatedContractRequestBuilder newBuilder() {
        return new WxTerminatedContractRequestBuilder();
    }

    public String getContractId() {
        return this.contractId;
    }

    public String getContractTerminationRemark() {
        return this.contractTerminationRemark;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getPlanId() {
        return this.planId;
    }

    public String getContractCode() {
        return this.contractCode;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public void setContractTerminationRemark(String contractTerminationRemark) {
        this.contractTerminationRemark = contractTerminationRemark;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPlanId(Integer planId) {
        this.planId = planId;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    @Override
    public String toString() {
        return "WxTerminatedContractRequest(contractId=" + this.getContractId() + ", contractTerminationRemark=" + this.getContractTerminationRemark() + ", version=" + this.getVersion() + ", planId=" + this.getPlanId() + ", contractCode=" + this.getContractCode() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxTerminatedContractRequest)) {
            return false;
        }
        WxTerminatedContractRequest other = (WxTerminatedContractRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$contractId = this.getContractId();
        String other$contractId = other.getContractId();
        if (this$contractId == null ? other$contractId != null : !this$contractId.equals(other$contractId)) {
            return false;
        }
        String this$contractTerminationRemark = this.getContractTerminationRemark();
        String other$contractTerminationRemark = other.getContractTerminationRemark();
        if (this$contractTerminationRemark == null ? other$contractTerminationRemark != null : !this$contractTerminationRemark.equals(other$contractTerminationRemark)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Integer this$planId = this.getPlanId();
        Integer other$planId = other.getPlanId();
        if (this$planId == null ? other$planId != null : !((Object)this$planId).equals(other$planId)) {
            return false;
        }
        String this$contractCode = this.getContractCode();
        String other$contractCode = other.getContractCode();
        return !(this$contractCode == null ? other$contractCode != null : !this$contractCode.equals(other$contractCode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxTerminatedContractRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $contractId = this.getContractId();
        result = result * 59 + ($contractId == null ? 43 : $contractId.hashCode());
        String $contractTerminationRemark = this.getContractTerminationRemark();
        result = result * 59 + ($contractTerminationRemark == null ? 43 : $contractTerminationRemark.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Integer $planId = this.getPlanId();
        result = result * 59 + ($planId == null ? 43 : ((Object)$planId).hashCode());
        String $contractCode = this.getContractCode();
        result = result * 59 + ($contractCode == null ? 43 : $contractCode.hashCode());
        return result;
    }

    public WxTerminatedContractRequest() {
    }

    public WxTerminatedContractRequest(String contractId, String contractTerminationRemark, String version, Integer planId, String contractCode) {
        this.contractId = contractId;
        this.contractTerminationRemark = contractTerminationRemark;
        this.version = version;
        this.planId = planId;
        this.contractCode = contractCode;
    }

    public static class WxTerminatedContractRequestBuilder {
        private String contractId;
        private String contractTerminationRemark;
        private String version;
        private Integer planId;
        private String contractCode;

        WxTerminatedContractRequestBuilder() {
        }

        public WxTerminatedContractRequestBuilder contractId(String contractId) {
            this.contractId = contractId;
            return this;
        }

        public WxTerminatedContractRequestBuilder contractTerminationRemark(String contractTerminationRemark) {
            this.contractTerminationRemark = contractTerminationRemark;
            return this;
        }

        public WxTerminatedContractRequestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public WxTerminatedContractRequestBuilder planId(Integer planId) {
            this.planId = planId;
            return this;
        }

        public WxTerminatedContractRequestBuilder contractCode(String contractCode) {
            this.contractCode = contractCode;
            return this;
        }

        public WxTerminatedContractRequest build() {
            return new WxTerminatedContractRequest(this.contractId, this.contractTerminationRemark, this.version, this.planId, this.contractCode);
        }

        public String toString() {
            return "WxTerminatedContractRequest.WxTerminatedContractRequestBuilder(contractId=" + this.contractId + ", contractTerminationRemark=" + this.contractTerminationRemark + ", version=" + this.version + ", planId=" + this.planId + ", contractCode=" + this.contractCode + ")";
        }
    }
}

