/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.utils.qrcode.QrcodeUtils;
import com.github.binarywang.wxpay.bean.WxPayApiData;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponInfoQueryRequest;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponInfoQueryResult;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponSendRequest;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponSendResult;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponStockQueryRequest;
import com.github.binarywang.wxpay.bean.coupon.WxPayCouponStockQueryResult;
import com.github.binarywang.wxpay.bean.notify.CombineNotifyResult;
import com.github.binarywang.wxpay.bean.notify.OriginNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.SignatureHeader;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyV3Result;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyV3Result;
import com.github.binarywang.wxpay.bean.notify.WxScanPayNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayNativeOrderResult;
import com.github.binarywang.wxpay.bean.request.CombineCloseRequest;
import com.github.binarywang.wxpay.bean.request.CombineTransactionsRequest;
import com.github.binarywang.wxpay.bean.request.WxPayApplyFundFlowBillV3Request;
import com.github.binarywang.wxpay.bean.request.WxPayApplyTradeBillV3Request;
import com.github.binarywang.wxpay.bean.request.WxPayAuthcode2OpenidRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDefaultRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadBillRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadFundFlowRequest;
import com.github.binarywang.wxpay.bean.request.WxPayFaceAuthInfoRequest;
import com.github.binarywang.wxpay.bean.request.WxPayFacepayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayMicropayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderCloseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderCloseV3Request;
import com.github.binarywang.wxpay.bean.request.WxPayOrderQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderQueryV3Request;
import com.github.binarywang.wxpay.bean.request.WxPayOrderReverseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayQueryCommentRequest;
import com.github.binarywang.wxpay.bean.request.WxPayQueryExchangeRateRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundQueryV3Request;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundV3Request;
import com.github.binarywang.wxpay.bean.request.WxPayReportRequest;
import com.github.binarywang.wxpay.bean.request.WxPayShorturlRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderV3Request;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.bean.result.CombineQueryResult;
import com.github.binarywang.wxpay.bean.result.CombineTransactionsResult;
import com.github.binarywang.wxpay.bean.result.WxPayApplyBillV3Result;
import com.github.binarywang.wxpay.bean.result.WxPayAuthcode2OpenidResult;
import com.github.binarywang.wxpay.bean.result.WxPayBillResult;
import com.github.binarywang.wxpay.bean.result.WxPayCommonResult;
import com.github.binarywang.wxpay.bean.result.WxPayFaceAuthInfoResult;
import com.github.binarywang.wxpay.bean.result.WxPayFacepayResult;
import com.github.binarywang.wxpay.bean.result.WxPayFundFlowBaseResult;
import com.github.binarywang.wxpay.bean.result.WxPayFundFlowResult;
import com.github.binarywang.wxpay.bean.result.WxPayMicropayResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderCloseResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryV3Result;
import com.github.binarywang.wxpay.bean.result.WxPayOrderReverseResult;
import com.github.binarywang.wxpay.bean.result.WxPayQueryExchangeRateResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundQueryV3Result;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundV3Result;
import com.github.binarywang.wxpay.bean.result.WxPaySandboxSignKeyResult;
import com.github.binarywang.wxpay.bean.result.WxPayShorturlResult;
import com.github.binarywang.wxpay.bean.result.WxPayUnifiedOrderResult;
import com.github.binarywang.wxpay.bean.result.WxPayUnifiedOrderV3Result;
import com.github.binarywang.wxpay.bean.result.enums.TradeTypeEnum;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.config.WxPayConfigHolder;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.BusinessCircleService;
import com.github.binarywang.wxpay.service.EcommerceService;
import com.github.binarywang.wxpay.service.EntPayService;
import com.github.binarywang.wxpay.service.MarketingBusiFavorService;
import com.github.binarywang.wxpay.service.MarketingFavorService;
import com.github.binarywang.wxpay.service.MarketingMediaService;
import com.github.binarywang.wxpay.service.MerchantMediaService;
import com.github.binarywang.wxpay.service.PayScoreService;
import com.github.binarywang.wxpay.service.ProfitSharingService;
import com.github.binarywang.wxpay.service.ProfitSharingV3Service;
import com.github.binarywang.wxpay.service.RedpackService;
import com.github.binarywang.wxpay.service.WxEntrustPapService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.BusinessCircleServiceImpl;
import com.github.binarywang.wxpay.service.impl.EcommerceServiceImpl;
import com.github.binarywang.wxpay.service.impl.EntPayServiceImpl;
import com.github.binarywang.wxpay.service.impl.MarketingBusiFavorServiceImpl;
import com.github.binarywang.wxpay.service.impl.MarketingFavorServiceImpl;
import com.github.binarywang.wxpay.service.impl.MarketingMediaServiceImpl;
import com.github.binarywang.wxpay.service.impl.MerchantMediaServiceImpl;
import com.github.binarywang.wxpay.service.impl.PayScoreServiceImpl;
import com.github.binarywang.wxpay.service.impl.ProfitSharingServiceImpl;
import com.github.binarywang.wxpay.service.impl.ProfitSharingV3ServiceImpl;
import com.github.binarywang.wxpay.service.impl.RedpackServiceImpl;
import com.github.binarywang.wxpay.service.impl.WxEntrustPapServiceImpl;
import com.github.binarywang.wxpay.util.SignUtils;
import com.github.binarywang.wxpay.util.XmlConfig;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipException;
import jodd.io.ZipUtil;
import me.chanjar.weixin.common.error.WxRuntimeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxPayServiceImpl
implements WxPayService {
    private static final String TOTAL_FUND_COUNT = "\u8d44\u91d1\u6d41\u6c34\u603b\u7b14\u6570";
    private static final Gson GSON = new GsonBuilder().create();
    final Logger log = LoggerFactory.getLogger(this.getClass());
    static ThreadLocal<WxPayApiData> wxApiData = new ThreadLocal();
    private EntPayService entPayService = new EntPayServiceImpl(this);
    private final ProfitSharingService profitSharingService = new ProfitSharingServiceImpl(this);
    private final ProfitSharingV3Service profitSharingV3Service = new ProfitSharingV3ServiceImpl(this);
    private final RedpackService redpackService = new RedpackServiceImpl(this);
    private final PayScoreService payScoreService = new PayScoreServiceImpl(this);
    private final EcommerceService ecommerceService = new EcommerceServiceImpl(this);
    private final BusinessCircleService businessCircleService = new BusinessCircleServiceImpl(this);
    private final MerchantMediaService merchantMediaService = new MerchantMediaServiceImpl(this);
    private final MarketingMediaService marketingMediaService = new MarketingMediaServiceImpl(this);
    private final MarketingFavorService marketingFavorService = new MarketingFavorServiceImpl(this);
    private final MarketingBusiFavorService marketingBusiFavorService = new MarketingBusiFavorServiceImpl(this);
    private final WxEntrustPapService wxEntrustPapService = new WxEntrustPapServiceImpl(this);
    protected Map<String, WxPayConfig> configMap;

    @Override
    public EntPayService getEntPayService() {
        return this.entPayService;
    }

    @Override
    public ProfitSharingService getProfitSharingService() {
        return this.profitSharingService;
    }

    @Override
    public ProfitSharingV3Service getProfitSharingV3Service() {
        return this.profitSharingV3Service;
    }

    @Override
    public PayScoreService getPayScoreService() {
        return this.payScoreService;
    }

    @Override
    public RedpackService getRedpackService() {
        return this.redpackService;
    }

    @Override
    public EcommerceService getEcommerceService() {
        return this.ecommerceService;
    }

    @Override
    public BusinessCircleService getBusinessCircleService() {
        return this.businessCircleService;
    }

    @Override
    public MerchantMediaService getMerchantMediaService() {
        return this.merchantMediaService;
    }

    @Override
    public MarketingMediaService getMarketingMediaService() {
        return this.marketingMediaService;
    }

    @Override
    public MarketingFavorService getMarketingFavorService() {
        return this.marketingFavorService;
    }

    @Override
    public MarketingBusiFavorService getMarketingBusiFavorService() {
        return this.marketingBusiFavorService;
    }

    @Override
    public void setEntPayService(EntPayService entPayService) {
        this.entPayService = entPayService;
    }

    @Override
    public WxEntrustPapService getWxEntrustPapService() {
        return this.wxEntrustPapService;
    }

    @Override
    public WxPayConfig getConfig() {
        if (this.configMap.size() == 1) {
            return this.configMap.values().iterator().next();
        }
        return this.configMap.get(WxPayConfigHolder.get());
    }

    @Override
    public void setConfig(WxPayConfig config) {
        String defaultMchId = config.getMchId();
        this.setMultiConfig((Map<String, WxPayConfig>)ImmutableMap.of((Object)defaultMchId, (Object)config), defaultMchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfig(String mchId, WxPayConfig wxPayConfig) {
        BaseWxPayServiceImpl baseWxPayServiceImpl = this;
        synchronized (baseWxPayServiceImpl) {
            if (this.configMap == null) {
                this.setConfig(wxPayConfig);
            } else {
                WxPayConfigHolder.set(mchId);
                this.configMap.put(mchId, wxPayConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfig(String mchId) {
        BaseWxPayServiceImpl baseWxPayServiceImpl = this;
        synchronized (baseWxPayServiceImpl) {
            if (this.configMap.size() == 1) {
                this.configMap.remove(mchId);
                this.log.warn("\u5df2\u5220\u9664\u6700\u540e\u4e00\u4e2a\u5546\u6237\u53f7\u914d\u7f6e\uff1a{}\uff0c\u987b\u7acb\u5373\u4f7f\u7528setConfig\u6216setMultiConfig\u6dfb\u52a0\u914d\u7f6e", (Object)mchId);
                return;
            }
            if (WxPayConfigHolder.get().equals(mchId)) {
                this.configMap.remove(mchId);
                String defaultMpId = this.configMap.keySet().iterator().next();
                WxPayConfigHolder.set(defaultMpId);
                this.log.warn("\u5df2\u5220\u9664\u9ed8\u8ba4\u5546\u6237\u53f7\u914d\u7f6e\uff0c\u5546\u6237\u53f7\u3010{}\u3011\u88ab\u8bbe\u4e3a\u9ed8\u8ba4\u914d\u7f6e", (Object)defaultMpId);
                return;
            }
            this.configMap.remove(mchId);
        }
    }

    @Override
    public void setMultiConfig(Map<String, WxPayConfig> wxPayConfigs) {
        this.setMultiConfig(wxPayConfigs, wxPayConfigs.keySet().iterator().next());
    }

    @Override
    public void setMultiConfig(Map<String, WxPayConfig> wxPayConfigs, String defaultMchId) {
        this.configMap = Maps.newHashMap(wxPayConfigs);
        WxPayConfigHolder.set(defaultMchId);
    }

    @Override
    public boolean switchover(String mchId) {
        if (this.configMap.containsKey(mchId)) {
            WxPayConfigHolder.set(mchId);
            return true;
        }
        this.log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010{}\u3011\u7684\u5546\u6237\u53f7\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", (Object)mchId);
        return false;
    }

    @Override
    public WxPayService switchoverTo(String mchId) {
        if (this.configMap.containsKey(mchId)) {
            WxPayConfigHolder.set(mchId);
            return this;
        }
        throw new WxRuntimeException(String.format("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010%s\u3011\u7684\u5546\u6237\u53f7\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", mchId));
    }

    @Override
    public String getPayBaseUrl() {
        if (this.getConfig().isUseSandboxEnv()) {
            return this.getConfig().getPayBaseUrl() + "/sandboxnew";
        }
        return this.getConfig().getPayBaseUrl();
    }

    @Override
    public WxPayRefundResult refund(WxPayRefundRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/refund";
        if (this.getConfig().isUseSandboxEnv()) {
            url = this.getConfig().getPayBaseUrl() + "/sandboxnew/pay/refund";
        }
        String responseContent = this.post(url, request.toXML(), true);
        WxPayRefundResult result = BaseWxPayResult.fromXML(responseContent, WxPayRefundResult.class);
        result.composeRefundCoupons();
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayRefundResult refundV2(WxPayRefundRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/refundv2";
        if (this.getConfig().isUseSandboxEnv()) {
            url = this.getConfig().getPayBaseUrl() + "/sandboxnew/pay/refundv2";
        }
        String responseContent = this.post(url, request.toXML(), true);
        WxPayRefundResult result = BaseWxPayResult.fromXML(responseContent, WxPayRefundResult.class);
        result.composePromotionDetails();
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayRefundV3Result refundV3(WxPayRefundV3Request request) throws WxPayException {
        String url = String.format("%s/v3/refund/domestic/refunds", this.getPayBaseUrl());
        String response = this.postV3(url, GSON.toJson((Object)request));
        return (WxPayRefundV3Result)GSON.fromJson(response, WxPayRefundV3Result.class);
    }

    @Override
    public WxPayRefundQueryResult refundQuery(String transactionId, String outTradeNo, String outRefundNo, String refundId) throws WxPayException {
        WxPayRefundQueryRequest request = new WxPayRefundQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.setOutRefundNo(StringUtils.trimToNull((String)outRefundNo));
        request.setRefundId(StringUtils.trimToNull((String)refundId));
        return this.refundQuery(request);
    }

    @Override
    public WxPayRefundQueryResult refundQuery(WxPayRefundQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/refundquery";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayRefundQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayRefundQueryResult.class);
        result.composeRefundRecords();
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayRefundQueryResult refundQueryV2(WxPayRefundQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/refundqueryv2";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayRefundQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayRefundQueryResult.class);
        result.composePromotionDetails();
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayRefundQueryV3Result refundQueryV3(String outTradeNo) throws WxPayException {
        String url = String.format("%s/v3/refund/domestic/refunds/%s", this.getPayBaseUrl(), outTradeNo);
        String response = this.getV3(url);
        return (WxPayRefundQueryV3Result)GSON.fromJson(response, WxPayRefundQueryV3Result.class);
    }

    @Override
    public WxPayRefundQueryV3Result refundQueryV3(WxPayRefundQueryV3Request request) throws WxPayException {
        String url = String.format("%s/v3/refund/domestic/refunds/%s", this.getPayBaseUrl(), request.getOutTradeNo());
        String response = this.getV3(url);
        return (WxPayRefundQueryV3Result)GSON.fromJson(response, WxPayRefundQueryV3Result.class);
    }

    @Override
    public WxPayOrderNotifyResult parseOrderNotifyResult(String xmlData) throws WxPayException {
        return this.parseOrderNotifyResult(xmlData, null);
    }

    @Override
    public WxPayOrderNotifyResult parseOrderNotifyResult(String xmlData, String signType) throws WxPayException {
        try {
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)xmlData);
            WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
            if (signType == null) {
                if (result.getSignType() != null) {
                    signType = result.getSignType();
                } else if (this.getConfig().getSignType() != null) {
                    signType = this.getConfig().getSignType();
                }
            }
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u8bf7\u6c42\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            result.checkResult(this, signType, false);
            return result;
        }
        catch (WxPayException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff01", e);
        }
    }

    private boolean verifyNotifySign(SignatureHeader header, String data) {
        String beforeSign = String.format("%s\n%s\n%s\n", header.getTimeStamp(), header.getNonce(), data);
        return this.getConfig().getVerifier().verify(header.getSerial(), beforeSign.getBytes(StandardCharsets.UTF_8), header.getSignature());
    }

    @Override
    public WxPayOrderNotifyV3Result parseOrderNotifyV3Result(String notifyData, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, notifyData)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        OriginNotifyResponse response = (OriginNotifyResponse)GSON.fromJson(notifyData, OriginNotifyResponse.class);
        OriginNotifyResponse.Resource resource = response.getResource();
        String cipherText = resource.getCiphertext();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            WxPayOrderNotifyV3Result.DecryptNotifyResult decryptNotifyResult = (WxPayOrderNotifyV3Result.DecryptNotifyResult)GSON.fromJson(result, WxPayOrderNotifyV3Result.DecryptNotifyResult.class);
            WxPayOrderNotifyV3Result notifyResult = new WxPayOrderNotifyV3Result();
            notifyResult.setRawData(response);
            notifyResult.setResult(decryptNotifyResult);
            return notifyResult;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public CombineNotifyResult parseCombineNotifyResult(String notifyData, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, notifyData)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        OriginNotifyResponse response = (OriginNotifyResponse)GSON.fromJson(notifyData, OriginNotifyResponse.class);
        OriginNotifyResponse.Resource resource = response.getResource();
        String cipherText = resource.getCiphertext();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            CombineNotifyResult.DecryptNotifyResult decryptNotifyResult = (CombineNotifyResult.DecryptNotifyResult)GSON.fromJson(result, CombineNotifyResult.DecryptNotifyResult.class);
            CombineNotifyResult notifyResult = new CombineNotifyResult();
            notifyResult.setRawData(response);
            notifyResult.setResult(decryptNotifyResult);
            return notifyResult;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPayRefundNotifyResult parseRefundNotifyResult(String xmlData) throws WxPayException {
        try {
            WxPayRefundNotifyResult result;
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u5f02\u6b65\u901a\u77e5\u53c2\u6570\uff1a{}", (Object)xmlData);
            if (XmlConfig.fastMode) {
                result = BaseWxPayResult.fromXML(xmlData, WxPayRefundNotifyResult.class);
                result.decryptReqInfo(this.getConfig().getMchKey());
            } else {
                result = WxPayRefundNotifyResult.fromXML(xmlData, this.getConfig().getMchKey());
            }
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u5f02\u6b65\u901a\u77e5\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), e);
        }
    }

    @Override
    public WxPayRefundNotifyV3Result parseRefundNotifyV3Result(String notifyData, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, notifyData)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        OriginNotifyResponse response = (OriginNotifyResponse)GSON.fromJson(notifyData, OriginNotifyResponse.class);
        OriginNotifyResponse.Resource resource = response.getResource();
        String cipherText = resource.getCiphertext();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            WxPayRefundNotifyV3Result.DecryptNotifyResult decryptNotifyResult = (WxPayRefundNotifyV3Result.DecryptNotifyResult)GSON.fromJson(result, WxPayRefundNotifyV3Result.DecryptNotifyResult.class);
            WxPayRefundNotifyV3Result notifyResult = new WxPayRefundNotifyV3Result();
            notifyResult.setRawData(response);
            notifyResult.setResult(decryptNotifyResult);
            return notifyResult;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxScanPayNotifyResult parseScanPayNotifyResult(String xmlData, String signType) throws WxPayException {
        try {
            this.log.debug("\u626b\u7801\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)xmlData);
            WxScanPayNotifyResult result = BaseWxPayResult.fromXML(xmlData, WxScanPayNotifyResult.class);
            this.log.debug("\u626b\u7801\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u89e3\u6790\u540e\u7684\u5bf9\u8c61\uff1a{}", (Object)result);
            result.checkResult(this, signType, false);
            return result;
        }
        catch (WxPayException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), e);
        }
    }

    @Override
    public WxScanPayNotifyResult parseScanPayNotifyResult(String xmlData) throws WxPayException {
        String signType = this.getConfig().getSignType();
        return this.parseScanPayNotifyResult(xmlData, signType);
    }

    @Override
    public WxPayOrderQueryResult queryOrder(String transactionId, String outTradeNo) throws WxPayException {
        WxPayOrderQueryRequest request = new WxPayOrderQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        return this.queryOrder(request);
    }

    @Override
    public WxPayOrderQueryResult queryOrder(WxPayOrderQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/orderquery";
        String responseContent = this.post(url, request.toXML(), false);
        if (StringUtils.isBlank((CharSequence)responseContent)) {
            throw new WxPayException("\u65e0\u54cd\u5e94\u7ed3\u679c");
        }
        WxPayOrderQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayOrderQueryResult.class);
        result.composeCoupons();
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayOrderQueryV3Result queryOrderV3(String transactionId, String outTradeNo) throws WxPayException {
        WxPayOrderQueryV3Request request = new WxPayOrderQueryV3Request();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        return this.queryOrderV3(request);
    }

    @Override
    public WxPayOrderQueryV3Result queryOrderV3(WxPayOrderQueryV3Request request) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)request.getMchid())) {
            request.setMchid(this.getConfig().getMchId());
        }
        String url = String.format("%s/v3/pay/transactions/out-trade-no/%s", this.getPayBaseUrl(), request.getOutTradeNo());
        if (Objects.isNull(request.getOutTradeNo())) {
            url = String.format("%s/v3/pay/transactions/id/%s", this.getPayBaseUrl(), request.getTransactionId());
        }
        String query = String.format("?mchid=%s", request.getMchid());
        String response = this.getV3(url + query);
        return (WxPayOrderQueryV3Result)GSON.fromJson(response, WxPayOrderQueryV3Result.class);
    }

    @Override
    public CombineQueryResult queryCombine(String combineOutTradeNo) throws WxPayException {
        String url = String.format("%s/v3/combine-transactions/out-trade-no/%s", this.getPayBaseUrl(), combineOutTradeNo);
        String response = this.getV3(url);
        return (CombineQueryResult)GSON.fromJson(response, CombineQueryResult.class);
    }

    @Override
    public WxPayOrderCloseResult closeOrder(String outTradeNo) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new WxPayException("out_trade_no\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayOrderCloseRequest request = new WxPayOrderCloseRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        return this.closeOrder(request);
    }

    @Override
    public WxPayOrderCloseResult closeOrder(WxPayOrderCloseRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/closeorder";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayOrderCloseResult result = BaseWxPayResult.fromXML(responseContent, WxPayOrderCloseResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public void closeOrderV3(String outTradeNo) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new WxPayException("out_trade_no\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayOrderCloseV3Request request = new WxPayOrderCloseV3Request();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        this.closeOrderV3(request);
    }

    @Override
    public void closeOrderV3(WxPayOrderCloseV3Request request) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)request.getMchid())) {
            request.setMchid(this.getConfig().getMchId());
        }
        String url = String.format("%s/v3/pay/transactions/out-trade-no/%s/close", this.getPayBaseUrl(), request.getOutTradeNo());
        this.postV3(url, GSON.toJson((Object)request));
    }

    @Override
    public void closeCombine(CombineCloseRequest request) throws WxPayException {
        String url = String.format("%s/v3/combine-transactions/out-trade-no/%s/close", this.getPayBaseUrl(), request.getCombineOutTradeNo());
        this.postV3(url, GSON.toJson((Object)request));
    }

    @Override
    public <T> T createOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new WxPayException(String.format("\u65e0\u6cd5\u83b7\u53d6prepay id\uff0c\u9519\u8bef\u4ee3\u7801\uff1a '%s'\uff0c\u4fe1\u606f\uff1a%s\u3002", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = unifiedOrderResult.getNonceStr();
        switch (request.getTradeType()) {
            case "MWEB": {
                return (T)new WxPayMwebOrderResult(unifiedOrderResult.getMwebUrl());
            }
            case "NATIVE": {
                return (T)new WxPayNativeOrderResult(unifiedOrderResult.getCodeURL());
            }
            case "APP": {
                String appId = unifiedOrderResult.getAppid();
                if (StringUtils.isNotEmpty((CharSequence)unifiedOrderResult.getSubAppId())) {
                    appId = unifiedOrderResult.getSubAppId();
                }
                HashMap<String, String> configMap = new HashMap<String, String>(8);
                String partnerId = unifiedOrderResult.getMchId();
                if (StringUtils.isNotEmpty((CharSequence)unifiedOrderResult.getSubMchId())) {
                    partnerId = unifiedOrderResult.getSubMchId();
                }
                configMap.put("prepayid", prepayId);
                configMap.put("partnerid", partnerId);
                String packageValue = "Sign=WXPay";
                configMap.put("package", packageValue);
                configMap.put("timestamp", timestamp);
                configMap.put("noncestr", nonceStr);
                configMap.put("appid", appId);
                WxPayAppOrderResult result = WxPayAppOrderResult.builder().sign(SignUtils.createSign(configMap, request.getSignType(), this.getConfig().getMchKey(), null)).prepayId(prepayId).partnerId(partnerId).appId(appId).packageValue(packageValue).timeStamp(timestamp).nonceStr(nonceStr).build();
                return (T)result;
            }
            case "JSAPI": {
                String signType = request.getSignType();
                if (signType == null) {
                    signType = "MD5";
                }
                String appid = unifiedOrderResult.getAppid();
                if (StringUtils.isNotEmpty((CharSequence)unifiedOrderResult.getSubAppId())) {
                    appid = unifiedOrderResult.getSubAppId();
                }
                WxPayMpOrderResult payResult = WxPayMpOrderResult.builder().appId(appid).timeStamp(timestamp).nonceStr(nonceStr).packageValue("prepay_id=" + prepayId).signType(signType).build();
                payResult.setPaySign(SignUtils.createSign(payResult, signType, this.getConfig().getMchKey(), null));
                return (T)payResult;
            }
        }
        throw new WxPayException("\u8be5\u4ea4\u6613\u7c7b\u578b\u6682\u4e0d\u652f\u6301");
    }

    @Override
    public <T> T createOrder(WxPayConstants.TradeType.Specific<T> specificTradeType, WxPayUnifiedOrderRequest request) throws WxPayException {
        if (specificTradeType == null) {
            throw new IllegalArgumentException("specificTradeType \u4e0d\u80fd\u4e3a null");
        }
        request.setTradeType(specificTradeType.getType());
        return this.createOrder(request);
    }

    @Override
    public WxPayUnifiedOrderResult unifiedOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/unifiedorder";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayUnifiedOrderResult result = BaseWxPayResult.fromXML(responseContent, WxPayUnifiedOrderResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public <T> T createOrderV3(TradeTypeEnum tradeType, WxPayUnifiedOrderV3Request request) throws WxPayException {
        WxPayUnifiedOrderV3Result result = this.unifiedOrderV3(tradeType, request);
        return result.getPayInfo(tradeType, request.getAppid(), request.getMchid(), this.getConfig().getPrivateKey());
    }

    @Override
    public WxPayUnifiedOrderV3Result unifiedOrderV3(TradeTypeEnum tradeType, WxPayUnifiedOrderV3Request request) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)request.getAppid())) {
            request.setAppid(this.getConfig().getAppId());
        }
        if (StringUtils.isBlank((CharSequence)request.getMchid())) {
            request.setMchid(this.getConfig().getMchId());
        }
        String url = this.getPayBaseUrl() + tradeType.getPartnerUrl();
        String response = this.postV3(url, GSON.toJson((Object)request));
        return (WxPayUnifiedOrderV3Result)GSON.fromJson(response, WxPayUnifiedOrderV3Result.class);
    }

    @Override
    public CombineTransactionsResult combine(TradeTypeEnum tradeType, CombineTransactionsRequest request) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)request.getCombineAppid())) {
            request.setCombineAppid(this.getConfig().getAppId());
        }
        if (StringUtils.isBlank((CharSequence)request.getCombineMchid())) {
            request.setCombineMchid(this.getConfig().getMchId());
        }
        String url = this.getPayBaseUrl() + tradeType.getCombineUrl();
        String response = this.postV3(url, GSON.toJson((Object)request));
        return (CombineTransactionsResult)GSON.fromJson(response, CombineTransactionsResult.class);
    }

    @Override
    public <T> T combineTransactions(TradeTypeEnum tradeType, CombineTransactionsRequest request) throws WxPayException {
        CombineTransactionsResult result = this.combine(tradeType, request);
        return result.getPayInfo(tradeType, request.getCombineAppid(), request.getCombineAppid(), this.getConfig().getPrivateKey());
    }

    @Override
    @Deprecated
    public Map<String, String> getPayInfo(WxPayUnifiedOrderRequest request) throws WxPayException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new WxRuntimeException(String.format("\u65e0\u6cd5\u83b7\u53d6prepay id\uff0c\u9519\u8bef\u4ee3\u7801\uff1a '%s'\uff0c\u4fe1\u606f\uff1a%s\u3002", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        HashMap<String, String> payInfo = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = unifiedOrderResult.getNonceStr();
        if ("NATIVE".equals(request.getTradeType())) {
            payInfo.put("codeUrl", unifiedOrderResult.getCodeURL());
        } else if ("APP".equals(request.getTradeType())) {
            String appId = this.getConfig().getAppId();
            HashMap<String, String> configMap = new HashMap<String, String>();
            String partnerId = this.getConfig().getMchId();
            configMap.put("prepayid", prepayId);
            configMap.put("partnerid", partnerId);
            String packageValue = "Sign=WXPay";
            configMap.put("package", packageValue);
            configMap.put("timestamp", timestamp);
            configMap.put("noncestr", nonceStr);
            configMap.put("appid", appId);
            payInfo.put("sign", SignUtils.createSign(configMap, request.getSignType(), this.getConfig().getMchKey(), null));
            payInfo.put("prepayId", prepayId);
            payInfo.put("partnerId", partnerId);
            payInfo.put("appId", appId);
            payInfo.put("packageValue", packageValue);
            payInfo.put("timeStamp", timestamp);
            payInfo.put("nonceStr", nonceStr);
        } else if ("JSAPI".equals(request.getTradeType())) {
            payInfo.put("appId", unifiedOrderResult.getAppid());
            payInfo.put("timeStamp", timestamp);
            payInfo.put("nonceStr", nonceStr);
            payInfo.put("package", "prepay_id=" + prepayId);
            payInfo.put("signType", request.getSignType());
            payInfo.put("paySign", SignUtils.createSign(payInfo, request.getSignType(), this.getConfig().getMchKey(), null));
        }
        return payInfo;
    }

    @Override
    public byte[] createScanPayQrcodeMode1(String productId, File logoFile, Integer sideLength) {
        String content = this.createScanPayQrcodeMode1(productId);
        return this.createQrcode(content, logoFile, sideLength);
    }

    @Override
    public String createScanPayQrcodeMode1(String productId) {
        StringBuilder codeUrl = new StringBuilder("weixin://wxpay/bizpayurl?");
        HashMap params = Maps.newHashMap();
        params.put("appid", this.getConfig().getAppId());
        params.put("mch_id", this.getConfig().getMchId());
        params.put("product_id", productId);
        params.put("time_stamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonce_str", String.valueOf(System.currentTimeMillis()));
        String sign = SignUtils.createSign(params, "MD5", this.getConfig().getMchKey(), null);
        params.put("sign", sign);
        for (String key : params.keySet()) {
            codeUrl.append(key).append("=").append((String)params.get(key)).append("&");
        }
        String content = codeUrl.toString().substring(0, codeUrl.length() - 1);
        this.log.debug("\u626b\u7801\u652f\u4ed8\u6a21\u5f0f\u4e00\u751f\u6210\u4e8c\u7ef4\u7801\u7684URL:{}", (Object)content);
        return content;
    }

    @Override
    public byte[] createScanPayQrcodeMode2(String codeUrl, File logoFile, Integer sideLength) {
        return this.createQrcode(codeUrl, logoFile, sideLength);
    }

    private byte[] createQrcode(String content, File logoFile, Integer sideLength) {
        if (sideLength == null || sideLength < 1) {
            return QrcodeUtils.createQrcode((String)content, (File)logoFile);
        }
        return QrcodeUtils.createQrcode((String)content, (int)sideLength, (File)logoFile);
    }

    @Override
    public void report(WxPayReportRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/payitil/report";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCommonResult result = BaseWxPayResult.fromXML(responseContent, WxPayCommonResult.class);
        result.checkResult(this, request.getSignType(), true);
    }

    @Override
    public String downloadRawBill(String billDate, String billType, String tarType, String deviceInfo) throws WxPayException {
        return this.downloadRawBill(this.buildDownloadBillRequest(billDate, billType, tarType, deviceInfo));
    }

    @Override
    public WxPayBillResult downloadBill(String billDate, String billType, String tarType, String deviceInfo) throws WxPayException {
        return this.downloadBill(this.buildDownloadBillRequest(billDate, billType, tarType, deviceInfo));
    }

    private WxPayDownloadBillRequest buildDownloadBillRequest(String billDate, String billType, String tarType, String deviceInfo) {
        WxPayDownloadBillRequest request = new WxPayDownloadBillRequest();
        request.setBillType(billType);
        request.setBillDate(billDate);
        request.setTarType(tarType);
        request.setDeviceInfo(deviceInfo);
        return request;
    }

    @Override
    public WxPayBillResult downloadBill(WxPayDownloadBillRequest request) throws WxPayException {
        String responseContent = this.downloadRawBill(request);
        if (StringUtils.isEmpty((CharSequence)responseContent)) {
            return null;
        }
        return this.handleBill(request.getBillType(), responseContent);
    }

    @Override
    public String downloadRawBill(WxPayDownloadBillRequest request) throws WxPayException {
        String responseContent;
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/downloadbill";
        if ("GZIP".equals(request.getTarType())) {
            responseContent = this.handleGzipBill(url, request.toXML());
        } else {
            responseContent = this.post(url, request.toXML(), false);
            if (responseContent.startsWith("<")) {
                throw WxPayException.from(BaseWxPayResult.fromXML(responseContent, WxPayCommonResult.class));
            }
        }
        return responseContent;
    }

    private WxPayBillResult handleBill(String billType, String responseContent) {
        return WxPayBillResult.fromRawBillResultString(responseContent, billType);
    }

    private String handleGzipBill(String url, String requestStr) throws WxPayException {
        try {
            byte[] responseBytes = this.postForBytes(url, requestStr, false);
            Path tempDirectory = Files.createTempDirectory("bill", new FileAttribute[0]);
            Path path = Paths.get(tempDirectory.toString(), System.currentTimeMillis() + ".gzip");
            Files.write(path, responseBytes, new OpenOption[0]);
            try {
                List<String> allLines = Files.readAllLines(ZipUtil.ungzip((File)path.toFile()).toPath(), StandardCharsets.UTF_8);
                return Joiner.on((String)"\n").join(allLines);
            }
            catch (ZipException e) {
                if (e.getMessage().contains("Not in GZIP format")) {
                    throw WxPayException.from(BaseWxPayResult.fromXML(new String(responseBytes, StandardCharsets.UTF_8), WxPayCommonResult.class));
                }
                throw new WxPayException("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519\uff01", e);
            }
        }
        catch (Exception e) {
            throw new WxPayException("\u89e3\u6790\u5bf9\u8d26\u5355\u6587\u4ef6\u65f6\u51fa\u9519\uff01", e);
        }
    }

    @Override
    public WxPayFundFlowResult downloadFundFlow(String billDate, String accountType, String tarType) throws WxPayException {
        WxPayDownloadFundFlowRequest request = new WxPayDownloadFundFlowRequest();
        request.setBillDate(billDate);
        request.setAccountType(accountType);
        request.setTarType(tarType);
        return this.downloadFundFlow(request);
    }

    @Override
    public WxPayFundFlowResult downloadFundFlow(WxPayDownloadFundFlowRequest request) throws WxPayException {
        String responseContent;
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/downloadfundflow";
        if ("GZIP".equals(request.getTarType())) {
            responseContent = this.handleGzipFundFlow(url, request.toXML());
        } else {
            responseContent = this.post(url, request.toXML(), true);
            if (responseContent.startsWith("<")) {
                throw WxPayException.from(BaseWxPayResult.fromXML(responseContent, WxPayCommonResult.class));
            }
        }
        return this.handleFundFlow(responseContent);
    }

    private String handleGzipFundFlow(String url, String requestStr) throws WxPayException {
        try {
            byte[] responseBytes = this.postForBytes(url, requestStr, true);
            Path tempDirectory = Files.createTempDirectory("fundFlow", new FileAttribute[0]);
            Path path = Paths.get(tempDirectory.toString(), System.currentTimeMillis() + ".gzip");
            Files.write(path, responseBytes, new OpenOption[0]);
            try {
                List<String> allLines = Files.readAllLines(ZipUtil.ungzip((File)path.toFile()).toPath(), StandardCharsets.UTF_8);
                return Joiner.on((String)"\n").join(allLines);
            }
            catch (ZipException e) {
                if (e.getMessage().contains("Not in GZIP format")) {
                    throw WxPayException.from(BaseWxPayResult.fromXML(new String(responseBytes, StandardCharsets.UTF_8), WxPayCommonResult.class));
                }
                throw new WxPayException("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519", e);
            }
        }
        catch (WxPayException wxPayException) {
            throw wxPayException;
        }
        catch (Exception e) {
            throw new WxPayException("\u89e3\u538bzip\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    private WxPayFundFlowResult handleFundFlow(String responseContent) {
        WxPayFundFlowResult wxPayFundFlowResult = new WxPayFundFlowResult();
        String listStr = "";
        String objStr = "";
        if (StringUtils.isNotBlank((CharSequence)responseContent) && responseContent.contains(TOTAL_FUND_COUNT)) {
            listStr = responseContent.substring(0, responseContent.indexOf(TOTAL_FUND_COUNT));
            objStr = responseContent.substring(responseContent.indexOf(TOTAL_FUND_COUNT));
        }
        LinkedList<WxPayFundFlowBaseResult> wxPayFundFlowBaseResultList = new LinkedList<WxPayFundFlowBaseResult>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayFundFlowBaseResult wxPayFundFlowBaseResult = new WxPayFundFlowBaseResult();
            wxPayFundFlowBaseResult.setBillingTime(tempStr[k].trim());
            wxPayFundFlowBaseResult.setBizTransactionId(tempStr[k + 1].trim());
            wxPayFundFlowBaseResult.setFundFlowId(tempStr[k + 2].trim());
            wxPayFundFlowBaseResult.setBizName(tempStr[k + 3].trim());
            wxPayFundFlowBaseResult.setBizType(tempStr[k + 4].trim());
            wxPayFundFlowBaseResult.setFinancialType(tempStr[k + 5].trim());
            wxPayFundFlowBaseResult.setFinancialFee(tempStr[k + 6].trim());
            wxPayFundFlowBaseResult.setAccountBalance(tempStr[k + 7].trim());
            wxPayFundFlowBaseResult.setFundApplicant(tempStr[k + 8].trim());
            wxPayFundFlowBaseResult.setMemo(tempStr[k + 9].trim());
            wxPayFundFlowBaseResult.setBizVoucherId(tempStr[k + 10].trim());
            wxPayFundFlowBaseResultList.add(wxPayFundFlowBaseResult);
            k += t.length;
        }
        wxPayFundFlowResult.setWxPayFundFlowBaseResultList(wxPayFundFlowBaseResultList);
        String totalStr = objStr.replaceAll(",", " ");
        String[] totalTempStr = totalStr.split("`");
        wxPayFundFlowResult.setTotalRecord(totalTempStr[1]);
        wxPayFundFlowResult.setIncomeRecord(totalTempStr[2]);
        wxPayFundFlowResult.setIncomeAmount(totalTempStr[3]);
        wxPayFundFlowResult.setExpenditureRecord(totalTempStr[4]);
        wxPayFundFlowResult.setExpenditureAmount(totalTempStr[5]);
        return wxPayFundFlowResult;
    }

    @Override
    public WxPayApplyBillV3Result applyTradeBill(WxPayApplyTradeBillV3Request request) throws WxPayException {
        String url = StringUtils.isBlank((CharSequence)request.getTarType()) ? String.format("%s/v3/bill/tradebill?bill_date=%s&bill_type=%s", this.getPayBaseUrl(), request.getBillDate(), request.getBillType()) : String.format("%s/v3/bill/tradebill?bill_date=%s&bill_type=%s&tar_type=%s", this.getPayBaseUrl(), request.getBillDate(), request.getBillType(), request.getTarType());
        String response = this.getV3(url);
        return (WxPayApplyBillV3Result)GSON.fromJson(response, WxPayApplyBillV3Result.class);
    }

    @Override
    public WxPayApplyBillV3Result applyFundFlowBill(WxPayApplyFundFlowBillV3Request request) throws WxPayException {
        String url = StringUtils.isBlank((CharSequence)request.getTarType()) ? String.format("%s/v3/bill/fundflowbill?bill_date=%s&bill_type=%s", this.getPayBaseUrl(), request.getBillDate(), request.getAccountType()) : String.format("%s/v3/bill/fundflowbill?bill_date=%s&bill_type=%s&tar_type=%s", this.getPayBaseUrl(), request.getBillDate(), request.getAccountType(), request.getTarType());
        String response = this.getV3(url);
        return (WxPayApplyBillV3Result)GSON.fromJson(response, WxPayApplyBillV3Result.class);
    }

    @Override
    public InputStream downloadBill(String url) throws WxPayException {
        return this.downloadV3(url);
    }

    @Override
    public WxPayMicropayResult micropay(WxPayMicropayRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/micropay";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayMicropayResult result = BaseWxPayResult.fromXML(responseContent, WxPayMicropayResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayOrderReverseResult reverseOrder(WxPayOrderReverseRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/reverse";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayOrderReverseResult result = BaseWxPayResult.fromXML(responseContent, WxPayOrderReverseResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public String shorturl(WxPayShorturlRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/shorturl";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayShorturlResult result = BaseWxPayResult.fromXML(responseContent, WxPayShorturlResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result.getShortUrl();
    }

    @Override
    public String shorturl(String longUrl) throws WxPayException {
        return this.shorturl(new WxPayShorturlRequest(longUrl));
    }

    @Override
    public String authcode2Openid(WxPayAuthcode2OpenidRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/authcodetoopenid";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayAuthcode2OpenidResult result = BaseWxPayResult.fromXML(responseContent, WxPayAuthcode2OpenidResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result.getOpenid();
    }

    @Override
    public String authcode2Openid(String authCode) throws WxPayException {
        return this.authcode2Openid(new WxPayAuthcode2OpenidRequest(authCode));
    }

    @Override
    public String getSandboxSignKey() throws WxPayException {
        WxPayDefaultRequest request = new WxPayDefaultRequest();
        request.checkAndSign(this.getConfig());
        String url = "https://api.mch.weixin.qq.com/sandboxnew/pay/getsignkey";
        String responseContent = this.post(url, request.toXML(), false);
        WxPaySandboxSignKeyResult result = BaseWxPayResult.fromXML(responseContent, WxPaySandboxSignKeyResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result.getSandboxSignKey();
    }

    @Override
    public WxPayCouponSendResult sendCoupon(WxPayCouponSendRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/send_coupon";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayCouponSendResult result = BaseWxPayResult.fromXML(responseContent, WxPayCouponSendResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayCouponStockQueryResult queryCouponStock(WxPayCouponStockQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/query_coupon_stock";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCouponStockQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayCouponStockQueryResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayCouponInfoQueryResult queryCouponInfo(WxPayCouponInfoQueryRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/querycouponsinfo";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayCouponInfoQueryResult result = BaseWxPayResult.fromXML(responseContent, WxPayCouponInfoQueryResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayApiData getWxApiData() {
        try {
            WxPayApiData wxPayApiData = wxApiData.get();
            return wxPayApiData;
        }
        finally {
            wxApiData.remove();
        }
    }

    @Override
    public String queryComment(Date beginDate, Date endDate, Integer offset, Integer limit) throws WxPayException {
        WxPayQueryCommentRequest request = new WxPayQueryCommentRequest();
        request.setBeginTime(WxPayConstants.QUERY_COMMENT_DATE_FORMAT.format(beginDate));
        request.setEndTime(WxPayConstants.QUERY_COMMENT_DATE_FORMAT.format(endDate));
        request.setOffset(offset);
        request.setLimit(limit);
        return this.queryComment(request);
    }

    @Override
    public String queryComment(WxPayQueryCommentRequest request) throws WxPayException {
        request.setSignType("HMAC-SHA256");
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/billcommentsp/batchquerycomment";
        String responseContent = this.post(url, request.toXML(), true);
        if (responseContent.startsWith("<")) {
            throw WxPayException.from(BaseWxPayResult.fromXML(responseContent, WxPayCommonResult.class));
        }
        return responseContent;
    }

    @Override
    public WxPayFaceAuthInfoResult getWxPayFaceAuthInfo(WxPayFaceAuthInfoRequest request) throws WxPayException {
        if (StringUtils.isEmpty((CharSequence)request.getSignType())) {
            request.setSignType("MD5");
        }
        request.checkAndSign(this.getConfig());
        String url = "https://payapp.weixin.qq.com/face/get_wxpayface_authinfo";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayFaceAuthInfoResult result = BaseWxPayResult.fromXML(responseContent, WxPayFaceAuthInfoResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayFacepayResult facepay(WxPayFacepayRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/facepay";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayFacepayResult result = BaseWxPayResult.fromXML(responseContent, WxPayFacepayResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayQueryExchangeRateResult queryExchangeRate(String feeType, String date) throws WxPayException {
        WxPayQueryExchangeRateRequest request = new WxPayQueryExchangeRateRequest();
        request.setFeeType(feeType);
        request.setDate(date);
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/queryexchagerate";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayQueryExchangeRateResult result = BaseWxPayResult.fromXML(responseContent, WxPayQueryExchangeRateResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }
}

