/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.exception;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.google.common.base.Joiner;

public class WxPayException
extends Exception {
    private static final long serialVersionUID = 2214381471513460742L;
    private String customErrorMsg;
    private String returnCode;
    private String returnMsg;
    private String resultCode;
    private String errCode;
    private String errCodeDes;
    private String xmlString;

    public WxPayException(String customErrorMsg) {
        super(customErrorMsg);
        this.customErrorMsg = customErrorMsg;
    }

    public WxPayException(String customErrorMsg, Throwable tr) {
        super(customErrorMsg, tr);
        this.customErrorMsg = customErrorMsg;
    }

    private WxPayException(Builder builder) {
        super(builder.buildErrorMsg());
        this.returnCode = builder.returnCode;
        this.returnMsg = builder.returnMsg;
        this.resultCode = builder.resultCode;
        this.errCode = builder.errCode;
        this.errCodeDes = builder.errCodeDes;
        this.xmlString = builder.xmlString;
    }

    public static WxPayException from(BaseWxPayResult payBaseResult) {
        WxPayException exception = WxPayException.newBuilder().xmlString(payBaseResult.getXmlString()).returnMsg(payBaseResult.getReturnMsg()).returnCode(payBaseResult.getReturnCode()).resultCode(payBaseResult.getResultCode()).errCode(payBaseResult.getErrCode()).errCodeDes(payBaseResult.getErrCodeDes()).build();
        if (payBaseResult.getErrorCode() != null) {
            exception.setErrCode(payBaseResult.getErrorCode());
        }
        if (payBaseResult.getErrorMessage() != null) {
            exception.setErrCodeDes(payBaseResult.getErrorMessage());
        }
        return exception;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCustomErrorMsg() {
        return this.customErrorMsg;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getReturnMsg() {
        return this.returnMsg;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrCodeDes() {
        return this.errCodeDes;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public void setCustomErrorMsg(String customErrorMsg) {
        this.customErrorMsg = customErrorMsg;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public void setErrCodeDes(String errCodeDes) {
        this.errCodeDes = errCodeDes;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
    }

    @Override
    public String toString() {
        return "WxPayException(customErrorMsg=" + this.getCustomErrorMsg() + ", returnCode=" + this.getReturnCode() + ", returnMsg=" + this.getReturnMsg() + ", resultCode=" + this.getResultCode() + ", errCode=" + this.getErrCode() + ", errCodeDes=" + this.getErrCodeDes() + ", xmlString=" + this.getXmlString() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayException)) {
            return false;
        }
        WxPayException other = (WxPayException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$customErrorMsg = this.getCustomErrorMsg();
        String other$customErrorMsg = other.getCustomErrorMsg();
        if (this$customErrorMsg == null ? other$customErrorMsg != null : !this$customErrorMsg.equals(other$customErrorMsg)) {
            return false;
        }
        String this$returnCode = this.getReturnCode();
        String other$returnCode = other.getReturnCode();
        if (this$returnCode == null ? other$returnCode != null : !this$returnCode.equals(other$returnCode)) {
            return false;
        }
        String this$returnMsg = this.getReturnMsg();
        String other$returnMsg = other.getReturnMsg();
        if (this$returnMsg == null ? other$returnMsg != null : !this$returnMsg.equals(other$returnMsg)) {
            return false;
        }
        String this$resultCode = this.getResultCode();
        String other$resultCode = other.getResultCode();
        if (this$resultCode == null ? other$resultCode != null : !this$resultCode.equals(other$resultCode)) {
            return false;
        }
        String this$errCode = this.getErrCode();
        String other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
            return false;
        }
        String this$errCodeDes = this.getErrCodeDes();
        String other$errCodeDes = other.getErrCodeDes();
        if (this$errCodeDes == null ? other$errCodeDes != null : !this$errCodeDes.equals(other$errCodeDes)) {
            return false;
        }
        String this$xmlString = this.getXmlString();
        String other$xmlString = other.getXmlString();
        return !(this$xmlString == null ? other$xmlString != null : !this$xmlString.equals(other$xmlString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPayException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $customErrorMsg = this.getCustomErrorMsg();
        result = result * 59 + ($customErrorMsg == null ? 43 : $customErrorMsg.hashCode());
        String $returnCode = this.getReturnCode();
        result = result * 59 + ($returnCode == null ? 43 : $returnCode.hashCode());
        String $returnMsg = this.getReturnMsg();
        result = result * 59 + ($returnMsg == null ? 43 : $returnMsg.hashCode());
        String $resultCode = this.getResultCode();
        result = result * 59 + ($resultCode == null ? 43 : $resultCode.hashCode());
        String $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
        String $errCodeDes = this.getErrCodeDes();
        result = result * 59 + ($errCodeDes == null ? 43 : $errCodeDes.hashCode());
        String $xmlString = this.getXmlString();
        result = result * 59 + ($xmlString == null ? 43 : $xmlString.hashCode());
        return result;
    }

    public static final class Builder {
        private String returnCode;
        private String returnMsg;
        private String resultCode;
        private String errCode;
        private String errCodeDes;
        private String xmlString;

        private Builder() {
        }

        public Builder returnCode(String returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public Builder returnMsg(String returnMsg) {
            this.returnMsg = returnMsg;
            return this;
        }

        public Builder resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public Builder errCode(String errCode) {
            this.errCode = errCode;
            return this;
        }

        public Builder errCodeDes(String errCodeDes) {
            this.errCodeDes = errCodeDes;
            return this;
        }

        public Builder xmlString(String xmlString) {
            this.xmlString = xmlString;
            return this;
        }

        public WxPayException build() {
            return new WxPayException(this);
        }

        public String buildErrorMsg() {
            return Joiner.on((String)"\uff0c").skipNulls().join((Object)(this.returnCode == null ? null : String.format("\u8fd4\u56de\u4ee3\u7801\uff1a[%s]", this.returnCode)), (Object)(this.returnMsg == null ? null : String.format("\u8fd4\u56de\u4fe1\u606f\uff1a[%s]", this.returnMsg)), new Object[]{this.resultCode == null ? null : String.format("\u7ed3\u679c\u4ee3\u7801\uff1a[%s]", this.resultCode), this.errCode == null ? null : String.format("\u9519\u8bef\u4ee3\u7801\uff1a[%s]", this.errCode), this.errCodeDes == null ? null : String.format("\u9519\u8bef\u8be6\u60c5\uff1a[%s]", this.errCodeDes), this.xmlString == null ? null : "\u5fae\u4fe1\u8fd4\u56de\u7684\u539f\u59cb\u62a5\u6587\uff1a\n" + this.xmlString});
        }
    }
}

