/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AesUtils {
    static final int KEY_LENGTH_BYTE = 32;
    static final int TAG_LENGTH_BIT = 128;
    private final byte[] aesKey;

    public AesUtils(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684ApiV3Key\uff0c\u957f\u5ea6\u5fc5\u987b\u4e3a32\u4e2a\u5b57\u8282");
        }
        this.aesKey = key;
    }

    public static byte[] decryptToByte(byte[] nonce, byte[] cipherData, byte[] key) throws GeneralSecurityException {
        return AesUtils.decryptToByte(null, nonce, cipherData, key);
    }

    public static byte[] decryptToByte(byte[] associatedData, byte[] nonce, byte[] cipherData, byte[] key) throws GeneralSecurityException {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
            cipher.init(2, (Key)secretKeySpec, spec);
            if (associatedData != null) {
                cipher.updateAAD(associatedData);
            }
            return cipher.doFinal(cipherData);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String decryptToString(byte[] associatedData, byte[] nonce, String ciphertext) throws GeneralSecurityException, IOException {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec key = new SecretKeySpec(this.aesKey, "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
            cipher.init(2, (Key)key, spec);
            cipher.updateAAD(associatedData);
            return new String(cipher.doFinal(Base64.getDecoder().decode(StringUtils.remove((String)ciphertext, (String)" "))), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String decryptToString(String associatedData, String nonce, String ciphertext, String apiV3Key) throws GeneralSecurityException, IOException {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec key = new SecretKeySpec(apiV3Key.getBytes(), "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce.getBytes());
            cipher.init(2, (Key)key, spec);
            cipher.updateAAD(associatedData.getBytes());
            return new String(cipher.doFinal(Base64.getDecoder().decode(ciphertext)), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String createSign(Map<String, String> map, String mchKey) {
        Map<String, String> params = map;
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(params);
        StringBuilder toSign = new StringBuilder();
        for (String key : sortedMap.keySet()) {
            String value = params.get(key);
            if ("sign".equals(key) || StringUtils.isEmpty((CharSequence)value)) continue;
            toSign.append(key).append("=").append(value).append("&");
        }
        toSign.append("key=" + mchKey);
        return AesUtils.HMACSHA256(toSign.toString(), mchKey);
    }

    public static String HMACSHA256(String data, String key) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] array = sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte item : array) {
                sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString().toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

