/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.auth;

import com.github.binarywang.wxpay.v3.Credentials;
import com.github.binarywang.wxpay.v3.WechatPayUploadHttpPost;
import com.github.binarywang.wxpay.v3.auth.Signer;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPayCredentials
implements Credentials {
    private static final Logger log = LoggerFactory.getLogger(WxPayCredentials.class);
    private static final String SYMBOLS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final SecureRandom RANDOM = new SecureRandom();
    protected String merchantId;
    protected Signer signer;

    public WxPayCredentials(String merchantId, Signer signer) {
        this.merchantId = merchantId;
        this.signer = signer;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    protected long generateTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    protected String generateNonceStr() {
        char[] nonceChars = new char[32];
        for (int index = 0; index < nonceChars.length; ++index) {
            nonceChars[index] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
        }
        return new String(nonceChars);
    }

    @Override
    public final String getSchema() {
        return "WECHATPAY2-SHA256-RSA2048";
    }

    @Override
    public final String getToken(HttpRequestWrapper request) throws IOException {
        String nonceStr = this.generateNonceStr();
        long timestamp = this.generateTimestamp();
        String message = this.buildMessage(nonceStr, timestamp, request);
        log.debug("authorization message=[{}]", (Object)message);
        Signer.SignatureResult signature = this.signer.sign(message.getBytes(StandardCharsets.UTF_8));
        String token = "mchid=\"" + this.getMerchantId() + "\",nonce_str=\"" + nonceStr + "\",timestamp=\"" + timestamp + "\",serial_no=\"" + signature.certificateSerialNumber + "\",signature=\"" + signature.sign + "\"";
        log.debug("authorization token=[{}]", (Object)token);
        return token;
    }

    protected final String buildMessage(String nonce, long timestamp, HttpRequestWrapper request) throws IOException {
        URI uri = request.getURI();
        String canonicalUrl = uri.getRawPath();
        if (uri.getQuery() != null) {
            canonicalUrl = canonicalUrl + "?" + uri.getRawQuery();
        }
        String body = "";
        if (request.getOriginal() instanceof WechatPayUploadHttpPost) {
            body = ((WechatPayUploadHttpPost)request.getOriginal()).getMeta();
        } else if (request instanceof HttpEntityEnclosingRequest) {
            body = EntityUtils.toString((HttpEntity)((HttpEntityEnclosingRequest)request).getEntity());
        }
        return request.getRequestLine().getMethod() + "\n" + canonicalUrl + "\n" + timestamp + "\n" + nonce + "\n" + body + "\n";
    }
}

