/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import me.chanjar.weixin.common.annotation.Required;

@XStreamAlias(value="xml")
public class WxDepositConsumeRequest
extends BaseWxPayRequest {
    @Required
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @Required
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @Required
    @XStreamAlias(value="consume_fee")
    private Integer consumeFee;
    @XStreamAlias(value="consume_desc")
    private String consumeDesc;

    @Override
    protected void checkConstraints() throws WxPayException {
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("transaction_id", this.transactionId);
        map.put("out_trade_no", this.outTradeNo);
        map.put("consume_fee", this.consumeFee.toString());
        if (this.consumeDesc != null) {
            map.put("consume_desc", this.consumeDesc);
        }
    }

    public static WxDepositConsumeRequestBuilder newBuilder() {
        return new WxDepositConsumeRequestBuilder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public Integer getConsumeFee() {
        return this.consumeFee;
    }

    public String getConsumeDesc() {
        return this.consumeDesc;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setConsumeFee(Integer consumeFee) {
        this.consumeFee = consumeFee;
    }

    public void setConsumeDesc(String consumeDesc) {
        this.consumeDesc = consumeDesc;
    }

    @Override
    public String toString() {
        return "WxDepositConsumeRequest(transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", consumeFee=" + this.getConsumeFee() + ", consumeDesc=" + this.getConsumeDesc() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxDepositConsumeRequest)) {
            return false;
        }
        WxDepositConsumeRequest other = (WxDepositConsumeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$consumeFee = this.getConsumeFee();
        Integer other$consumeFee = other.getConsumeFee();
        if (this$consumeFee == null ? other$consumeFee != null : !((Object)this$consumeFee).equals(other$consumeFee)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$consumeDesc = this.getConsumeDesc();
        String other$consumeDesc = other.getConsumeDesc();
        return !(this$consumeDesc == null ? other$consumeDesc != null : !this$consumeDesc.equals(other$consumeDesc));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxDepositConsumeRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $consumeFee = this.getConsumeFee();
        result = result * 59 + ($consumeFee == null ? 43 : ((Object)$consumeFee).hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $consumeDesc = this.getConsumeDesc();
        result = result * 59 + ($consumeDesc == null ? 43 : $consumeDesc.hashCode());
        return result;
    }

    public WxDepositConsumeRequest() {
    }

    public WxDepositConsumeRequest(String transactionId, String outTradeNo, Integer consumeFee, String consumeDesc) {
        this.transactionId = transactionId;
        this.outTradeNo = outTradeNo;
        this.consumeFee = consumeFee;
        this.consumeDesc = consumeDesc;
    }

    public static class WxDepositConsumeRequestBuilder {
        private String transactionId;
        private String outTradeNo;
        private Integer consumeFee;
        private String consumeDesc;

        WxDepositConsumeRequestBuilder() {
        }

        public WxDepositConsumeRequestBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public WxDepositConsumeRequestBuilder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public WxDepositConsumeRequestBuilder consumeFee(Integer consumeFee) {
            this.consumeFee = consumeFee;
            return this;
        }

        public WxDepositConsumeRequestBuilder consumeDesc(String consumeDesc) {
            this.consumeDesc = consumeDesc;
            return this;
        }

        public WxDepositConsumeRequest build() {
            return new WxDepositConsumeRequest(this.transactionId, this.outTradeNo, this.consumeFee, this.consumeDesc);
        }

        public String toString() {
            return "WxDepositConsumeRequest.WxDepositConsumeRequestBuilder(transactionId=" + this.transactionId + ", outTradeNo=" + this.outTradeNo + ", consumeFee=" + this.consumeFee + ", consumeDesc=" + this.consumeDesc + ")";
        }
    }
}

