/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;

@XStreamAlias(value="xml")
public class WxDepositOrderQueryRequest
extends BaseWxPayRequest {
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (this.transactionId == null && this.outTradeNo == null) {
            throw new WxPayException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        if (this.transactionId != null) {
            map.put("transaction_id", this.transactionId);
        }
        if (this.outTradeNo != null) {
            map.put("out_trade_no", this.outTradeNo);
        }
    }

    public static WxDepositOrderQueryRequestBuilder newBuilder() {
        return new WxDepositOrderQueryRequestBuilder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    @Override
    public String toString() {
        return "WxDepositOrderQueryRequest(transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxDepositOrderQueryRequest)) {
            return false;
        }
        WxDepositOrderQueryRequest other = (WxDepositOrderQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        return !(this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxDepositOrderQueryRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        return result;
    }

    public WxDepositOrderQueryRequest() {
    }

    public WxDepositOrderQueryRequest(String transactionId, String outTradeNo) {
        this.transactionId = transactionId;
        this.outTradeNo = outTradeNo;
    }

    public static class WxDepositOrderQueryRequestBuilder {
        private String transactionId;
        private String outTradeNo;

        WxDepositOrderQueryRequestBuilder() {
        }

        public WxDepositOrderQueryRequestBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public WxDepositOrderQueryRequestBuilder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public WxDepositOrderQueryRequest build() {
            return new WxDepositOrderQueryRequest(this.transactionId, this.outTradeNo);
        }

        public String toString() {
            return "WxDepositOrderQueryRequest.WxDepositOrderQueryRequestBuilder(transactionId=" + this.transactionId + ", outTradeNo=" + this.outTradeNo + ")";
        }
    }
}

